/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;

public class ReferralsHandlingWidget
extends BrowserWidget {
    private Connection.ReferralHandlingMethod initialReferralsHandlingMethod;
    private Group group;
    private Button followManuallyButton;
    private Button followAutomaticallyButton;
    private Button ignoreButton;

    public ReferralsHandlingWidget(Connection.ReferralHandlingMethod initialReferralsHandlingMethod) {
        this.initialReferralsHandlingMethod = initialReferralsHandlingMethod;
    }

    public ReferralsHandlingWidget() {
        this.initialReferralsHandlingMethod = Connection.ReferralHandlingMethod.FOLLOW;
    }

    public void createWidget(Composite parent, boolean followManuallyVisible) {
        this.group = BaseWidgetUtils.createGroup((Composite)parent, (String)Messages.getString("ReferralsHandlingWidget.ReferralsHandling"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)this.group, (int)1, (int)1);
        if (followManuallyVisible) {
            this.followManuallyButton = BaseWidgetUtils.createRadiobutton((Composite)groupComposite, (String)Messages.getString("ReferralsHandlingWidget.FollowManually"), (int)1);
            this.followManuallyButton.setToolTipText(Messages.getString("ReferralsHandlingWidget.FollowManuallyTooltip"));
            this.followManuallyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ReferralsHandlingWidget.this.notifyListeners();
                }
            });
        }
        this.followAutomaticallyButton = BaseWidgetUtils.createRadiobutton((Composite)groupComposite, (String)Messages.getString("ReferralsHandlingWidget.FollowAutomatically"), (int)1);
        this.followAutomaticallyButton.setToolTipText(Messages.getString("ReferralsHandlingWidget.FollowAutomaticallyTooltip"));
        this.followAutomaticallyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferralsHandlingWidget.this.notifyListeners();
            }
        });
        this.ignoreButton = BaseWidgetUtils.createRadiobutton((Composite)groupComposite, (String)Messages.getString("ReferralsHandlingWidget.Ignore"), (int)1);
        this.ignoreButton.setToolTipText(Messages.getString("ReferralsHandlingWidget.IgnoreTooltip"));
        this.ignoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferralsHandlingWidget.this.notifyListeners();
            }
        });
        this.setReferralsHandlingMethod(this.initialReferralsHandlingMethod);
    }

    public void setReferralsHandlingMethod(Connection.ReferralHandlingMethod referralsHandlingMethod) {
        this.initialReferralsHandlingMethod = referralsHandlingMethod;
        if (this.followManuallyButton == null && referralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY) {
            this.initialReferralsHandlingMethod = Connection.ReferralHandlingMethod.FOLLOW;
        }
        if (this.followManuallyButton != null) {
            this.followManuallyButton.setSelection(this.initialReferralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW_MANUALLY);
        }
        this.followAutomaticallyButton.setSelection(this.initialReferralsHandlingMethod == Connection.ReferralHandlingMethod.FOLLOW);
        this.ignoreButton.setSelection(this.initialReferralsHandlingMethod == Connection.ReferralHandlingMethod.IGNORE);
    }

    public Connection.ReferralHandlingMethod getReferralsHandlingMethod() {
        if (this.ignoreButton.getSelection()) {
            return Connection.ReferralHandlingMethod.IGNORE;
        }
        if (this.followAutomaticallyButton.getSelection()) {
            return Connection.ReferralHandlingMethod.FOLLOW;
        }
        return Connection.ReferralHandlingMethod.FOLLOW_MANUALLY;
    }

    public void setEnabled(boolean b) {
        this.group.setEnabled(b);
        if (this.followManuallyButton != null) {
            this.followManuallyButton.setEnabled(b);
        }
        this.followAutomaticallyButton.setEnabled(b);
        this.ignoreButton.setEnabled(b);
    }
}

