/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.search;

import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.DnUtils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.dialogs.SelectEntryDialog;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.search.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.ReadEntryRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IRootDSE;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class EntryWidget
extends BrowserWidget {
    private Combo dnCombo;
    private Button upButton;
    private Button entryBrowseButton;
    private IBrowserConnection browserConnection;
    private Dn dn;
    private Dn suffix;
    boolean useLocalName;

    public EntryWidget() {
        this.browserConnection = null;
        this.dn = null;
    }

    public EntryWidget(IBrowserConnection browserConnection, Dn dn) {
        this(browserConnection, dn, null, false);
    }

    public EntryWidget(IBrowserConnection browserConnection, Dn dn, Dn suffix, boolean useLocalName) {
        this.browserConnection = browserConnection;
        this.dn = dn;
        this.suffix = suffix;
        this.useLocalName = useLocalName;
    }

    public void createWidget(final Composite parent) {
        Composite textAndUpComposite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)2, (int)1);
        this.dnCombo = BaseWidgetUtils.createCombo((Composite)textAndUpComposite, (String[])new String[0], (int)-1, (int)1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 1;
        gd.widthHint = 30;
        this.dnCombo.setLayoutData((Object)gd);
        String[] history = HistoryUtils.load((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"dnHistory");
        this.dnCombo.setItems(history);
        this.dnCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    EntryWidget.this.dn = new Dn(new String[]{EntryWidget.this.dnCombo.getText()});
                }
                catch (LdapInvalidDnException e1) {
                    EntryWidget.this.dn = null;
                }
                EntryWidget.this.internalSetEnabled();
                EntryWidget.this.notifyListeners();
            }
        });
        this.upButton = new Button(textAndUpComposite, 8);
        this.upButton.setToolTipText(Messages.getString("EntryWidget.Parent"));
        this.upButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/parent.gif"));
        this.upButton.setEnabled(false);
        this.upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Dn.isNullOrEmpty((Dn)EntryWidget.this.dn)) {
                    EntryWidget.this.dn = EntryWidget.this.dn.getParent();
                    EntryWidget.this.dnChanged();
                    EntryWidget.this.internalSetEnabled();
                    EntryWidget.this.notifyListeners();
                }
            }
        });
        this.entryBrowseButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("EntryWidget.BrowseButton"), (int)1);
        this.entryBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EntryWidget.this.browserConnection != null) {
                    IRootDSE rootEntry = EntryWidget.this.browserConnection.getRootDSE();
                    if (EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0 && (rootEntry = EntryWidget.this.browserConnection.getEntryFromCache(EntryWidget.this.suffix)) == null) {
                        ReadEntryRunnable runnable = new ReadEntryRunnable(EntryWidget.this.browserConnection, EntryWidget.this.suffix);
                        RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
                        rootEntry = runnable.getReadEntry();
                    }
                    Dn initialDn = EntryWidget.this.dn;
                    if (EntryWidget.this.useLocalName && EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0 && initialDn != null && initialDn.size() > 0) {
                        try {
                            initialDn = initialDn.add(EntryWidget.this.suffix);
                        }
                        catch (LdapInvalidDnException lide) {
                            // empty catch block
                        }
                    }
                    IRootDSE entry = rootEntry;
                    if (initialDn != null && initialDn.size() > 0 && (entry = EntryWidget.this.browserConnection.getEntryFromCache(initialDn)) == null) {
                        ReadEntryRunnable runnable = new ReadEntryRunnable(EntryWidget.this.browserConnection, initialDn);
                        RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
                        entry = runnable.getReadEntry();
                    }
                    SelectEntryDialog dialog = new SelectEntryDialog(parent.getShell(), Messages.getString("EntryWidget.SelectDN"), (IEntry)rootEntry, (IEntry)entry);
                    dialog.open();
                    IEntry selectedEntry = dialog.getSelectedEntry();
                    if (selectedEntry != null) {
                        EntryWidget.this.dn = selectedEntry.getDn();
                        if (EntryWidget.this.useLocalName && EntryWidget.this.suffix != null && EntryWidget.this.suffix.size() > 0) {
                            EntryWidget.this.dn = DnUtils.getPrefixName((Dn)EntryWidget.this.dn, (Dn)EntryWidget.this.suffix);
                        }
                        EntryWidget.this.dnChanged();
                        EntryWidget.this.internalSetEnabled();
                        EntryWidget.this.notifyListeners();
                    }
                }
            }
        });
        this.dnChanged();
        this.internalSetEnabled();
    }

    private void dnChanged() {
        if (this.dnCombo != null && this.entryBrowseButton != null) {
            this.dnCombo.setText(this.dn != null ? this.dn.getName() : "");
        }
    }

    public void setEnabled(boolean b) {
        this.dnCombo.setEnabled(b);
        if (b) {
            this.dnChanged();
        }
        this.internalSetEnabled();
    }

    private void internalSetEnabled() {
        this.upButton.setEnabled(!Dn.isNullOrEmpty((Dn)this.dn) && this.dnCombo.isEnabled());
        this.entryBrowseButton.setEnabled(this.browserConnection != null && this.dnCombo.isEnabled());
    }

    public void saveDialogSettings() {
        HistoryUtils.save((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"dnHistory", (String)this.dnCombo.getText());
    }

    public Dn getSuffix() {
        return this.suffix;
    }

    public Dn getDn() {
        return this.dn;
    }

    public IBrowserConnection getBrowserConnection() {
        return this.browserConnection;
    }

    public void setInput(IBrowserConnection browserConnection, Dn dn) {
        this.setInput(browserConnection, dn, null, false);
    }

    public void setInput(IBrowserConnection browserConnection, Dn dn, Dn suffix, boolean useLocalName) {
        if (this.browserConnection != browserConnection || this.dn != dn || this.suffix != suffix) {
            this.browserConnection = browserConnection;
            this.dn = dn;
            this.suffix = suffix;
            this.useLocalName = useLocalName;
            this.dnChanged();
        }
    }
}

