/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.ArrayList;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EntryEditorWidgetContentProvider
implements ITreeContentProvider {
    protected EntryEditorWidgetPreferences preferences;
    protected EntryEditorWidget mainWidget;

    public EntryEditorWidgetContentProvider(EntryEditorWidgetPreferences preferences, EntryEditorWidget mainWidget) {
        this.preferences = preferences;
        this.mainWidget = mainWidget;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.mainWidget != null) {
            String dn = "";
            boolean enabled = true;
            if (newInput != null && newInput instanceof IEntry) {
                IEntry entry = (IEntry)newInput;
                dn = Messages.getString("EntryEditorWidgetContentProvider.DNLabel") + entry.getDn().getName();
            } else if (newInput != null && newInput instanceof AttributeHierarchy) {
                AttributeHierarchy ah = (AttributeHierarchy)newInput;
                dn = Messages.getString("EntryEditorWidgetContentProvider.DNLabel") + ah.getAttribute().getEntry().getDn().getName();
            } else {
                dn = Messages.getString("EntryEditorWidgetContentProvider.NoEntrySelected");
                enabled = false;
            }
            if (this.mainWidget.getInfoText() != null && !this.mainWidget.getInfoText().isDisposed()) {
                this.mainWidget.getInfoText().setText(dn);
            }
            if (this.mainWidget.getQuickFilterWidget() != null) {
                this.mainWidget.getQuickFilterWidget().setEnabled(enabled);
            }
            if (this.mainWidget.getViewer() != null && !this.mainWidget.getViewer().getTree().isDisposed()) {
                this.mainWidget.getViewer().getTree().setEnabled(enabled);
            }
        }
    }

    public void dispose() {
        this.preferences = null;
        this.mainWidget = null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof IEntry) {
            IEntry entry = (IEntry)inputElement;
            if (!entry.isAttributesInitialized()) {
                InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(new IEntry[]{entry});
                StudioBrowserJob job = new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable});
                job.execute();
                return new Object[0];
            }
            IAttribute[] attributes = entry.getAttributes();
            Object[] values = this.getValues(attributes);
            return values;
        }
        if (inputElement != null && inputElement instanceof AttributeHierarchy) {
            AttributeHierarchy ah = (AttributeHierarchy)inputElement;
            IAttribute[] attributes = ah.getAttributes();
            Object[] values = this.getValues(attributes);
            return values;
        }
        return new Object[0];
    }

    private Object[] getValues(IAttribute[] attributes) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (attributes != null) {
            for (IAttribute attribute : attributes) {
                IValue[] values = attribute.getValues();
                if (this.preferences == null || !this.preferences.isUseFolding() || values.length <= this.preferences.getFoldingThreshold()) {
                    for (IValue value : values) {
                        valueList.add(value);
                    }
                    continue;
                }
                valueList.add(attribute);
            }
        }
        return valueList.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IAttribute) {
            IAttribute attribute = (IAttribute)parentElement;
            Object[] values = attribute.getValues();
            return values;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IValue) {
            return ((IValue)element).getAttribute();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IAttribute;
    }
}

