/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.browser;

import java.util.Arrays;
import java.util.Collection;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.widgets.ExtendedContentAssistCommandAdapter;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserSelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.ListContentProposalProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.SearchRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IQuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.impl.QuickSearch;
import org.apache.directory.studio.ldapbrowser.core.model.schema.SchemaUtils;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.fieldassist.ComboContentAdapter;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BrowserQuickSearchWidget {
    public static final String VALUE_HISTORY_DIALOGSETTING_KEY = BrowserQuickSearchWidget.class.getName() + ".valueHistory";
    public static final String ATTRIBUTE_HISTORY_DIALOGSETTING_KEY = BrowserQuickSearchWidget.class.getName() + ".attributeHistory";
    private static final String[] EMPTY = new String[0];
    private BrowserWidget browserWidget;
    private Composite parent;
    private Composite composite;
    private Composite innerComposite;
    private Combo quickSearchAttributeCombo;
    private ListContentProposalProvider quickSearchAttributePP;
    private Combo quickSearchOperatorCombo;
    private Combo quickSearchValueCombo;
    private ListContentProposalProvider quickSearchValuePP;
    private Button quickSearchScopeButton;
    private Button quickSearchRunButton;
    private ISelectionChangedListener selectionListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            BrowserQuickSearchWidget.this.setEnabled(BrowserQuickSearchWidget.this.getSelectedEntry() != null);
        }
    };

    public BrowserQuickSearchWidget(BrowserWidget browserWidget) {
        this.browserWidget = browserWidget;
        if (HistoryUtils.load((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)ATTRIBUTE_HISTORY_DIALOGSETTING_KEY).length == 0) {
            BrowserCommonActivator.getDefault().getDialogSettings().put(ATTRIBUTE_HISTORY_DIALOGSETTING_KEY, new String[]{"cn", "sn", "givenName", "mail", "uid", "description", "o", "ou", "member"});
        }
    }

    public void createComposite(Composite parent) {
        this.parent = parent;
        this.composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        GridLayout gl = new GridLayout();
        gl.marginHeight = 2;
        gl.marginWidth = 2;
        this.composite.setLayout((Layout)gl);
        GridData compositeGridData = new GridData(0, 0, false, false);
        compositeGridData.heightHint = 0;
        compositeGridData.widthHint = 0;
        this.composite.setLayoutData((Object)compositeGridData);
        this.innerComposite = null;
    }

    private void create() {
        this.browserWidget.getViewer().addPostSelectionChangedListener(this.selectionListener);
        IDialogSettings dialogSettings = BrowserCommonActivator.getDefault().getDialogSettings();
        GridData compositeGridData = new GridData(4, 0, true, false);
        this.composite.setLayoutData((Object)compositeGridData);
        this.innerComposite = BaseWidgetUtils.createColumnContainer((Composite)this.composite, (int)5, (int)1);
        String[] attributes = HistoryUtils.load((IDialogSettings)dialogSettings, (String)ATTRIBUTE_HISTORY_DIALOGSETTING_KEY);
        this.quickSearchAttributeCombo = BaseWidgetUtils.createCombo((Composite)this.innerComposite, (String[])attributes, (int)-1, (int)1);
        this.quickSearchAttributePP = new ListContentProposalProvider(attributes);
        new ExtendedContentAssistCommandAdapter((Control)this.quickSearchAttributeCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)this.quickSearchAttributePP, null, null, true);
        this.quickSearchAttributeCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BrowserQuickSearchWidget.this.quickSearchRunButton.setEnabled(!"".equals(BrowserQuickSearchWidget.this.quickSearchAttributeCombo.getText()));
            }
        });
        this.quickSearchAttributeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BrowserQuickSearchWidget.this.performSearch();
            }
        });
        GridData gd = new GridData(768);
        gd.widthHint = 50;
        this.quickSearchAttributeCombo.setLayoutData((Object)gd);
        String[] operators = new String[]{"=", "!=", "<=", ">=", "~="};
        this.quickSearchOperatorCombo = BaseWidgetUtils.createReadonlyCombo((Composite)this.innerComposite, (String[])operators, (int)0, (int)1);
        GridData data = new GridData();
        this.quickSearchOperatorCombo.setLayoutData((Object)data);
        String[] values = HistoryUtils.load((IDialogSettings)dialogSettings, (String)VALUE_HISTORY_DIALOGSETTING_KEY);
        this.quickSearchValueCombo = BaseWidgetUtils.createCombo((Composite)this.innerComposite, (String[])values, (int)-1, (int)1);
        this.quickSearchValuePP = new ListContentProposalProvider(values);
        new ExtendedContentAssistCommandAdapter((Control)this.quickSearchValueCombo, (IControlContentAdapter)new ComboContentAdapter(), (IContentProposalProvider)this.quickSearchValuePP, null, null, true);
        this.quickSearchValueCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                BrowserQuickSearchWidget.this.performSearch();
            }
        });
        gd = new GridData(768);
        gd.widthHint = 50;
        this.quickSearchValueCombo.setLayoutData((Object)gd);
        this.quickSearchScopeButton = new Button(this.innerComposite, 2);
        this.quickSearchScopeButton.setToolTipText(Messages.getString("BrowserQuickSearchWidget.ScopeOneLevelToolTip"));
        this.quickSearchScopeButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/subtree.gif"));
        this.quickSearchScopeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String one = Messages.getString("BrowserQuickSearchWidget.ScopeOneLevelToolTip");
                String sub = Messages.getString("BrowserQuickSearchWidget.ScopeSubtreeToolTip");
                BrowserQuickSearchWidget.this.quickSearchScopeButton.setToolTipText(BrowserQuickSearchWidget.this.quickSearchScopeButton.getSelection() ? sub : one);
            }
        });
        this.quickSearchRunButton = new Button(this.innerComposite, 8);
        this.quickSearchRunButton.setToolTipText(Messages.getString("BrowserQuickSearchWidget.RunQuickSearch"));
        this.quickSearchRunButton.setImage(BrowserCommonActivator.getDefault().getImage("resources/icons/quicksearch.gif"));
        this.quickSearchRunButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BrowserQuickSearchWidget.this.performSearch();
            }
        });
        this.setEnabled(this.getSelectedEntry() != null);
        this.composite.layout(true, true);
        this.parent.layout(true, true);
    }

    private void performSearch() {
        if (!this.quickSearchRunButton.isEnabled()) {
            return;
        }
        IEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        IDialogSettings dialogSettings = BrowserCommonActivator.getDefault().getDialogSettings();
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)ATTRIBUTE_HISTORY_DIALOGSETTING_KEY, (String)this.quickSearchAttributeCombo.getText());
        String[] attributes = HistoryUtils.load((IDialogSettings)dialogSettings, (String)ATTRIBUTE_HISTORY_DIALOGSETTING_KEY);
        this.quickSearchAttributeCombo.setItems(attributes);
        this.quickSearchAttributeCombo.select(0);
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)VALUE_HISTORY_DIALOGSETTING_KEY, (String)this.quickSearchValueCombo.getText());
        String[] values = HistoryUtils.load((IDialogSettings)dialogSettings, (String)VALUE_HISTORY_DIALOGSETTING_KEY);
        this.quickSearchValueCombo.setItems(values);
        this.quickSearchValueCombo.select(0);
        this.quickSearchValuePP.setProposals(Arrays.asList(values));
        IBrowserConnection conn = entry.getBrowserConnection();
        QuickSearch quickSearch = new QuickSearch(entry, conn);
        quickSearch.getSearchParameter().setScope(this.quickSearchScopeButton.getSelection() ? SearchScope.SUBTREE : SearchScope.ONELEVEL);
        StringBuffer filter = new StringBuffer();
        filter.append("(");
        if ("!=".equals(this.quickSearchOperatorCombo.getText())) {
            filter.append("!(");
        }
        filter.append(this.quickSearchAttributeCombo.getText());
        filter.append(Messages.getString("BrowserQuickSearchWidget.9").equals(this.quickSearchOperatorCombo.getText()) ? "=" : this.quickSearchOperatorCombo.getText());
        String value = this.quickSearchValueCombo.getText();
        value = value.replaceAll("\\\\", "\\\\5c");
        value = value.replaceAll("\u0000", "\\\\00");
        value = value.replaceAll("\\(", "\\\\28");
        value = value.replaceAll("\\)", "\\\\29");
        filter.append(value);
        if ("!=".equals(this.quickSearchOperatorCombo.getText())) {
            filter.append(")");
        }
        filter.append(")");
        quickSearch.getSearchParameter().setFilter(filter.toString());
        this.browserWidget.setQuickSearch((IQuickSearch)quickSearch);
        new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{new SearchRunnable(new ISearch[]{quickSearch})}).execute();
    }

    private IEntry getSelectedEntry() {
        ISelection selection = this.browserWidget.getViewer().getSelection();
        IEntry[] entries = BrowserSelectionUtils.getEntries(selection);
        ISearch[] searches = BrowserSelectionUtils.getSearches(selection);
        if (entries != null && entries.length == 1) {
            IEntry entry = entries[0];
            return entry;
        }
        if (searches != null && searches.length == 1 && searches[0] instanceof IQuickSearch) {
            IQuickSearch quickSearch = (IQuickSearch)searches[0];
            IEntry entry = quickSearch.getSearchBaseEntry();
            return entry;
        }
        return null;
    }

    private void destroy() {
        this.browserWidget.getViewer().removePostSelectionChangedListener(this.selectionListener);
        GridData compositeGridData = new GridData(0, 0, false, false);
        compositeGridData.heightHint = 0;
        compositeGridData.widthHint = 0;
        this.composite.setLayoutData((Object)compositeGridData);
        this.innerComposite.dispose();
        this.innerComposite = null;
        this.composite.layout(true, true);
        this.parent.layout(true, true);
    }

    public void dispose() {
        if (this.browserWidget != null) {
            this.quickSearchAttributeCombo = null;
            this.quickSearchOperatorCombo = null;
            this.quickSearchValueCombo = null;
            this.quickSearchRunButton = null;
            this.innerComposite = null;
            this.composite.dispose();
            this.composite = null;
            this.parent = null;
            this.browserWidget = null;
        }
    }

    private void setEnabled(boolean enabled) {
        if (this.composite != null && !this.composite.isDisposed()) {
            this.composite.setEnabled(enabled);
        }
        if (this.innerComposite != null && !this.innerComposite.isDisposed()) {
            this.innerComposite.setEnabled(enabled);
            this.quickSearchAttributeCombo.setEnabled(enabled);
            this.quickSearchOperatorCombo.setEnabled(enabled);
            this.quickSearchValueCombo.setEnabled(enabled);
            this.quickSearchScopeButton.setEnabled(enabled);
            this.quickSearchRunButton.setEnabled(enabled && !"".equals(this.quickSearchAttributeCombo.getText()));
            if (!enabled) {
                this.quickSearchAttributeCombo.setToolTipText(null);
                this.quickSearchOperatorCombo.setToolTipText(null);
                this.quickSearchValueCombo.setToolTipText(null);
                this.parent.setToolTipText(Messages.getString("BrowserQuickSearchWidget.DisabledToolTipText"));
            } else {
                this.quickSearchAttributeCombo.setToolTipText(Messages.getString("BrowserQuickSearchWidget.SearchAttribute"));
                this.quickSearchOperatorCombo.setToolTipText(Messages.getString("BrowserQuickSearchWidget.SearchOperator"));
                this.quickSearchValueCombo.setToolTipText(Messages.getString("BrowserQuickSearchWidget.SearchValue"));
                this.parent.setToolTipText(null);
            }
        }
    }

    public void setActive(boolean visible) {
        if (visible && this.innerComposite == null && this.composite != null) {
            this.create();
            Object input = this.browserWidget.getViewer().getInput();
            if (input != null && input instanceof IBrowserConnection) {
                this.setInput((IBrowserConnection)input);
            } else if (input != null && input instanceof IEntry[]) {
                this.setInput(((IEntry[])input)[0].getBrowserConnection());
            }
            this.quickSearchAttributeCombo.setFocus();
        } else if (!visible && this.innerComposite != null && this.composite != null) {
            this.destroy();
            this.browserWidget.getViewer().getTree().setFocus();
        }
    }

    public void setInput(IBrowserConnection connection) {
        if (this.innerComposite != null && !this.innerComposite.isDisposed()) {
            String[] atdNames;
            if (connection != null) {
                Collection atds = connection.getSchema().getAttributeTypeDescriptions();
                atdNames = SchemaUtils.getNames((Collection)atds).toArray(EMPTY);
            } else {
                atdNames = EMPTY;
                this.setEnabled(false);
            }
            this.quickSearchAttributePP.setProposals(Arrays.asList(atdNames));
        }
    }
}

