/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets;

import java.io.File;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.BrowserWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.Messages;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;

public class FileBrowserWidget
extends BrowserWidget {
    public static final int TYPE_OPEN = 4096;
    public static final int TYPE_SAVE = 8192;
    protected Combo fileCombo;
    protected Button browseButton;
    protected String title;
    protected String[] extensions;
    protected int type;

    public FileBrowserWidget(String title, String[] extensions, int type) {
        this.title = title;
        this.extensions = extensions;
        this.type = type;
    }

    public void createWidget(Composite parent) {
        this.fileCombo = new Combo(parent, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 50;
        this.fileCombo.setLayoutData((Object)gd);
        this.fileCombo.setVisibleItemCount(20);
        this.fileCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FileBrowserWidget.this.notifyListeners();
            }
        });
        this.browseButton = BaseWidgetUtils.createButton((Composite)parent, (String)Messages.getString("FileBrowserWidget.BrowseButton"), (int)1);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog fileDialog = new FileDialog(FileBrowserWidget.this.browseButton.getShell(), FileBrowserWidget.this.type);
                fileDialog.setText(FileBrowserWidget.this.title);
                fileDialog.setFilterExtensions(FileBrowserWidget.this.extensions);
                File file = new File(FileBrowserWidget.this.fileCombo.getText());
                if (file.isFile()) {
                    fileDialog.setFilterPath(file.getParent());
                    fileDialog.setFileName(file.getName());
                } else if (file.isDirectory()) {
                    fileDialog.setFilterPath(file.getPath());
                } else {
                    fileDialog.setFilterPath(BrowserCommonActivator.getDefault().getDialogSettings().get("recentFilePath"));
                }
                String returnedFileName = fileDialog.open();
                if (returnedFileName != null) {
                    FileBrowserWidget.this.fileCombo.setText(returnedFileName);
                    File file2 = new File(returnedFileName);
                    BrowserCommonActivator.getDefault().getDialogSettings().put("recentFilePath", file2.getParent());
                }
            }
        });
        String[] history = HistoryUtils.load((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"fileHistory");
        this.fileCombo.setItems(history);
    }

    public String getFilename() {
        return this.fileCombo.getText();
    }

    public void setFilename(String filename) {
        this.fileCombo.setText(filename);
    }

    public void saveDialogSettings() {
        HistoryUtils.save((IDialogSettings)BrowserCommonActivator.getDefault().getDialogSettings(), (String)"fileHistory", (String)this.fileCombo.getText());
    }

    public void setFocus() {
        this.fileCombo.setFocus();
    }

    public void setEnabled(boolean b) {
        this.fileCombo.setEnabled(b);
        this.browseButton.setEnabled(b);
    }
}

