/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.ui.actions.SelectionUtils;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserCategory;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserEntryPage;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserSearchResultPage;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IBookmark;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.impl.Search;
import org.apache.directory.studio.ldapbrowser.core.utils.LdapFilterUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;

public abstract class BrowserSelectionUtils
extends SelectionUtils {
    public static ISearch getExampleSearch(ISelection selection) {
        Search exampleSearch = new Search();
        String oldName = exampleSearch.getSearchParameter().getName();
        exampleSearch.getSearchParameter().setName(null);
        exampleSearch.setScope(SearchScope.SUBTREE);
        if (selection != null && !selection.isEmpty() && selection instanceof StructuredSelection) {
            Object[] objects = ((IStructuredSelection)selection).toArray();
            Comparator<Object> comparator = new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof IValue && !(o2 instanceof IValue)) {
                        return -1;
                    }
                    if (!(o1 instanceof IValue) && o2 instanceof IValue) {
                        return 1;
                    }
                    if (o1 instanceof IAttribute && !(o2 instanceof IAttribute)) {
                        return -1;
                    }
                    if (!(o1 instanceof IAttribute) && o2 instanceof IAttribute) {
                        return 1;
                    }
                    if (o1 instanceof AttributeHierarchy && !(o2 instanceof AttributeHierarchy)) {
                        return -1;
                    }
                    if (!(o1 instanceof AttributeHierarchy) && o2 instanceof AttributeHierarchy) {
                        return 1;
                    }
                    return 0;
                }
            };
            Arrays.sort(objects, comparator);
            Object obj = objects[0];
            if (obj instanceof ISearch) {
                ISearch search = (ISearch)obj;
                exampleSearch = (ISearch)search.clone();
                exampleSearch.setName(null);
            } else if (obj instanceof IEntry) {
                IEntry entry = (IEntry)obj;
                exampleSearch.setBrowserConnection(entry.getBrowserConnection());
                exampleSearch.setSearchBase(entry.getDn());
                exampleSearch.setFilter(entry.getChildrenFilter());
            } else if (obj instanceof ISearchResult) {
                ISearchResult searchResult = (ISearchResult)obj;
                exampleSearch.setBrowserConnection(searchResult.getEntry().getBrowserConnection());
                exampleSearch.setSearchBase(searchResult.getEntry().getDn());
            } else if (obj instanceof IBookmark) {
                IBookmark bookmark = (IBookmark)obj;
                exampleSearch.setBrowserConnection(bookmark.getBrowserConnection());
                exampleSearch.setSearchBase(bookmark.getDn());
            } else if (obj instanceof AttributeHierarchy || obj instanceof IAttribute || obj instanceof IValue) {
                IEntry entry = null;
                LinkedHashSet<String> filterSet = new LinkedHashSet<String>();
                for (int i = 0; i < objects.length; ++i) {
                    Object object = objects[i];
                    if (object instanceof AttributeHierarchy) {
                        AttributeHierarchy ah = (AttributeHierarchy)object;
                        for (IAttribute attribute : ah) {
                            entry = attribute.getEntry();
                            IValue[] values = attribute.getValues();
                            for (int v = 0; v < values.length; ++v) {
                                filterSet.add(LdapFilterUtils.getFilter((IValue)values[v]));
                            }
                        }
                        continue;
                    }
                    if (object instanceof IAttribute) {
                        IAttribute attribute = (IAttribute)object;
                        entry = attribute.getEntry();
                        IValue[] values = attribute.getValues();
                        for (int v = 0; v < values.length; ++v) {
                            filterSet.add(LdapFilterUtils.getFilter((IValue)values[v]));
                        }
                        continue;
                    }
                    if (!(object instanceof IValue)) continue;
                    IValue value = (IValue)object;
                    entry = value.getAttribute().getEntry();
                    filterSet.add(LdapFilterUtils.getFilter((IValue)value));
                }
                exampleSearch.setBrowserConnection(entry.getBrowserConnection());
                exampleSearch.setSearchBase(entry.getDn());
                StringBuffer filter = new StringBuffer();
                if (filterSet.size() > 1) {
                    filter.append("(&");
                    Iterator filterIterator = filterSet.iterator();
                    while (filterIterator.hasNext()) {
                        filter.append((String)filterIterator.next());
                    }
                    filter.append(")");
                } else if (filterSet.size() == 1) {
                    filter.append(filterSet.toArray()[0]);
                } else {
                    filter.append("(objectClass=*)");
                }
                exampleSearch.setFilter(filter.toString());
            } else if (obj instanceof Connection) {
                IBrowserConnection connection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection((Connection)obj);
                exampleSearch.setBrowserConnection(connection);
                if (connection.getRootDSE().getChildrenCount() > 0) {
                    exampleSearch.setSearchBase(connection.getRootDSE().getChildren()[0].getDn());
                } else {
                    exampleSearch.setSearchBase(connection.getRootDSE().getDn());
                }
            } else if (obj instanceof IBrowserConnection) {
                IBrowserConnection connection = (IBrowserConnection)obj;
                exampleSearch.setBrowserConnection(connection);
                if (connection.getRootDSE().getChildrenCount() > 0) {
                    exampleSearch.setSearchBase(connection.getRootDSE().getChildren()[0].getDn());
                } else {
                    exampleSearch.setSearchBase(connection.getRootDSE().getDn());
                }
            } else if (obj instanceof BrowserCategory) {
                BrowserCategory cat = (BrowserCategory)obj;
                exampleSearch.setBrowserConnection(cat.getParent());
                if (cat.getParent().getRootDSE().getChildrenCount() > 0) {
                    exampleSearch.setSearchBase(cat.getParent().getRootDSE().getChildren()[0].getDn());
                } else {
                    exampleSearch.setSearchBase(cat.getParent().getRootDSE().getDn());
                }
            }
        }
        exampleSearch.getSearchParameter().setName(oldName);
        return exampleSearch;
    }

    public static BrowserCategory[] getBrowserViewCategories(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, BrowserCategory.class);
        return list.toArray(new BrowserCategory[list.size()]);
    }

    public static IValue[] getValues(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, IValue.class);
        return list.toArray(new IValue[list.size()]);
    }

    public static IAttribute[] getAttributes(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, IAttribute.class);
        return list.toArray(new IAttribute[list.size()]);
    }

    public static AttributeHierarchy[] getAttributeHierarchie(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, AttributeHierarchy.class);
        return list.toArray(new AttributeHierarchy[list.size()]);
    }

    public static String[] getProperties(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, String.class);
        return list.toArray(new String[list.size()]);
    }

    public static AttributeType[] getAttributeTypeDescription(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, AttributeType.class);
        return list.toArray(new AttributeType[list.size()]);
    }

    public static IEntry[] getEntries(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, IEntry.class);
        return list.toArray(new IEntry[list.size()]);
    }

    public static IBookmark[] getBookmarks(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, IBookmark.class);
        return list.toArray(new IBookmark[list.size()]);
    }

    public static ISearchResult[] getSearchResults(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, ISearchResult.class);
        return list.toArray(new ISearchResult[list.size()]);
    }

    private static List<Object> getTypes(ISelection selection, Class<?> type) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            for (Object o : structuredSelection) {
                if (!type.isInstance(o)) continue;
                list.add(o);
            }
        }
        return list;
    }

    public static ISearch[] getSearches(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, ISearch.class);
        return list.toArray(new ISearch[list.size()]);
    }

    public static BrowserEntryPage[] getBrowserEntryPages(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, BrowserEntryPage.class);
        return list.toArray(new BrowserEntryPage[list.size()]);
    }

    public static BrowserSearchResultPage[] getBrowserSearchResultPages(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, BrowserSearchResultPage.class);
        return list.toArray(new BrowserSearchResultPage[list.size()]);
    }

    public static Object[] getObjects(ISelection selection) {
        List<Object> list = BrowserSelectionUtils.getTypes(selection, Object.class);
        return list.toArray(new Object[list.size()]);
    }
}

