/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core.io;

import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ICertificateHandler;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;

public class StudioTrustManager
implements X509TrustManager {
    private X509TrustManager jvmTrustManager;
    private String host;

    public StudioTrustManager(X509TrustManager jvmTrustManager) throws Exception {
        this.jvmTrustManager = jvmTrustManager;
    }

    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.jvmTrustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        ArrayList<ICertificateHandler.FailCause> failCauses;
        block23: {
            try {
                X509TrustManager permanentTrustManager = this.getPermanentTrustManager();
                if (permanentTrustManager != null) {
                    permanentTrustManager.checkServerTrusted(chain, authType);
                    return;
                }
            }
            catch (CertificateException ce) {
                // empty catch block
            }
            try {
                X509TrustManager sessionTrustManager = this.getSessionTrustManager();
                if (sessionTrustManager != null) {
                    sessionTrustManager.checkServerTrusted(chain, authType);
                    return;
                }
            }
            catch (CertificateException ce) {
                // empty catch block
            }
            failCauses = new ArrayList<ICertificateHandler.FailCause>();
            try {
                this.jvmTrustManager.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ce) {
                X500Principal subjectX500Principal;
                if (ce instanceof CertificateExpiredException) {
                    failCauses.add(ICertificateHandler.FailCause.CertificateExpired);
                }
                if (ce instanceof CertificateNotYetValidException) {
                    failCauses.add(ICertificateHandler.FailCause.CertificateNotYetValid);
                }
                X500Principal issuerX500Principal = chain[0].getIssuerX500Principal();
                if (issuerX500Principal.equals(subjectX500Principal = chain[0].getSubjectX500Principal())) {
                    failCauses.add(ICertificateHandler.FailCause.SelfSignedCertificate);
                } else {
                    failCauses.add(ICertificateHandler.FailCause.NoValidCertificationPath);
                }
                try {
                    chain[0].checkValidity();
                }
                catch (CertificateException ve) {
                    if (ve instanceof CertificateExpiredException) {
                        failCauses.add(ICertificateHandler.FailCause.CertificateExpired);
                        break block23;
                    }
                    if (!(ve instanceof CertificateNotYetValidException)) break block23;
                    failCauses.add(ICertificateHandler.FailCause.CertificateNotYetValid);
                }
            }
        }
        try {
            BrowserCompatHostnameVerifier hostnameVerifier = new BrowserCompatHostnameVerifier();
            hostnameVerifier.verify(this.host, chain[0]);
        }
        catch (SSLException ce) {
            failCauses.add(ICertificateHandler.FailCause.HostnameVerificationFailed);
        }
        if (!failCauses.isEmpty()) {
            ICertificateHandler ch = ConnectionCorePlugin.getDefault().getCertificateHandler();
            ICertificateHandler.TrustLevel trustLevel = ch.verifyTrustLevel(this.host, chain, failCauses);
            switch (trustLevel) {
                case Permanent: {
                    ConnectionCorePlugin.getDefault().getPermanentTrustStoreManager().addCertificate(chain[0]);
                    break;
                }
                case Session: {
                    ConnectionCorePlugin.getDefault().getSessionTrustStoreManager().addCertificate(chain[0]);
                    break;
                }
                case Not: {
                    throw new CertificateException(Messages.error__untrusted_certificate);
                }
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.jvmTrustManager.getAcceptedIssuers();
    }

    private X509TrustManager getPermanentTrustManager() throws CertificateException {
        KeyStore permanentTrustStore = ConnectionCorePlugin.getDefault().getPermanentTrustStoreManager().getKeyStore();
        X509TrustManager permanentTrustManager = this.getTrustManager(permanentTrustStore);
        return permanentTrustManager;
    }

    private X509TrustManager getSessionTrustManager() throws CertificateException {
        KeyStore sessionTrustStore = ConnectionCorePlugin.getDefault().getSessionTrustStoreManager().getKeyStore();
        X509TrustManager sessionTrustManager = this.getTrustManager(sessionTrustStore);
        return sessionTrustManager;
    }

    private X509TrustManager getTrustManager(KeyStore trustStore) throws CertificateException {
        try {
            Enumeration<String> aliases = trustStore.aliases();
            if (aliases.hasMoreElements()) {
                TrustManagerFactory factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                factory.init(trustStore);
                TrustManager[] permanentTrustManagers = factory.getTrustManagers();
                TrustManager permanentTrustManager = permanentTrustManagers[0];
                return (X509TrustManager)permanentTrustManager;
            }
        }
        catch (Exception e) {
            throw new CertificateException(Messages.StudioTrustManager_CantCreateTrustManager, e);
        }
        return null;
    }
}

