/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCoreConstants;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionFolder;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.Messages;
import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.connection.core.event.ConnectionEventRegistry;
import org.apache.directory.studio.connection.core.event.ConnectionUpdateListener;
import org.apache.directory.studio.connection.core.io.ConnectionIO;
import org.apache.directory.studio.connection.core.io.ConnectionIOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class ConnectionManager
implements ConnectionUpdateListener {
    private static final String LOGS_PATH = "logs";
    private static final String SEARCH_LOGS_PREFIX = "search-";
    private static final String MODIFICATIONS_LOG_PREFIX = "modifications-";
    private static final String LDIFLOG_SUFFIX = "-%u-%g.ldiflog";
    private static final String CONNECTIONS_XML = "connections.xml";
    public static final String ENCODING_UTF8 = "UTF-8";
    public static final String TEMP_SUFFIX = "-temp";
    private Set<Connection> connectionList = new HashSet<Connection>();

    public ConnectionManager() {
        this.loadInitializers();
        this.loadConnections();
        ConnectionEventRegistry.addConnectionUpdateListener(this, ConnectionCorePlugin.getDefault().getEventRunner());
    }

    private void loadInitializers() {
        IConfigurationElement[] configurationElements;
        File connectionStore = new File(ConnectionManager.getConnectionStoreFileName());
        if (connectionStore.exists()) {
            return;
        }
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(ConnectionCorePlugin.getDefault().getPluginProperties().getString("ExtensionPoint_ConnectionInitializer_id"));
        for (IConfigurationElement configurationElement : configurationElements = extensionPoint.getConfigurationElements()) {
            if (!"connection".equals(configurationElement.getName())) continue;
            this.addInitialConnection(configurationElement);
        }
    }

    private void addInitialConnection(IConfigurationElement configurationElement) {
        try {
            ConnectionParameter connectionParameter = (ConnectionParameter)configurationElement.createExecutableExtension("class");
            Connection conn = new Connection(connectionParameter);
            this.connectionList.add(conn);
        }
        catch (CoreException e) {
            Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, Messages.error__execute_connection_initializer + e.getMessage(), (Throwable)e);
            ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    public static final String getModificationLogFileName(Connection connection) {
        IPath p = ConnectionCorePlugin.getDefault().getStateLocation().append(LOGS_PATH);
        File file = p.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        return p.append(MODIFICATIONS_LOG_PREFIX + Utils.getFilenameString(connection.getId()) + LDIFLOG_SUFFIX).toOSString();
    }

    public static final String getSearchLogFileName(Connection connection) {
        IPath p = ConnectionCorePlugin.getDefault().getStateLocation().append(LOGS_PATH);
        File file = p.toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        return p.append(SEARCH_LOGS_PREFIX + Utils.getFilenameString(connection.getId()) + LDIFLOG_SUFFIX).toOSString();
    }

    public static final String getConnectionStoreFileName() {
        String filename = ConnectionCorePlugin.getDefault().getStateLocation().append(CONNECTIONS_XML).toOSString();
        return filename;
    }

    public void addConnection(Connection connection) {
        if (this.getConnectionByName(connection.getConnectionParameter().getName()) != null) {
            String newConnectionName = Messages.bind((String)Messages.copy_n_of_s, (Object)"", (Object)connection.getConnectionParameter().getName());
            int i = 2;
            while (this.getConnectionByName(newConnectionName) != null) {
                newConnectionName = Messages.bind((String)Messages.copy_n_of_s, (Object)(i + " "), (Object)connection.getConnectionParameter().getName());
                ++i;
            }
            connection.getConnectionParameter().setName(newConnectionName);
        }
        this.connectionList.add(connection);
        ConnectionEventRegistry.fireConnectionAdded(connection, this);
    }

    public Connection getConnectionById(String id) {
        for (Connection conn : this.connectionList) {
            if (!conn.getConnectionParameter().getId().equals(id)) continue;
            return conn;
        }
        return null;
    }

    public Connection getConnectionByName(String name) {
        for (Connection conn : this.connectionList) {
            if (!conn.getConnectionParameter().getName().equals(name)) continue;
            return conn;
        }
        return null;
    }

    public void removeConnection(Connection connection) {
        this.connectionList.remove(connection);
        ConnectionEventRegistry.fireConnectionRemoved(connection, this);
    }

    public Connection[] getConnections() {
        return this.connectionList.toArray(new Connection[0]);
    }

    public int getConnectionCount() {
        return this.connectionList.size();
    }

    @Override
    public void connectionAdded(Connection connection) {
        this.saveConnections();
    }

    @Override
    public void connectionRemoved(Connection connection) {
        this.saveConnections();
    }

    @Override
    public void connectionUpdated(Connection connection) {
        this.saveConnections();
    }

    @Override
    public void connectionOpened(Connection connection) {
    }

    @Override
    public void connectionClosed(Connection connection) {
    }

    @Override
    public void connectionFolderModified(ConnectionFolder connectionFolder) {
    }

    @Override
    public void connectionFolderAdded(ConnectionFolder connectionFolder) {
    }

    @Override
    public void connectionFolderRemoved(ConnectionFolder connectionFolder) {
    }

    public synchronized void saveConnections() {
        HashSet<ConnectionParameter> connectionParameters = new HashSet<ConnectionParameter>();
        for (Connection connection : this.connectionList) {
            connectionParameters.add(connection.getConnectionParameter());
        }
        try {
            ConnectionIO.save(connectionParameters, new FileOutputStream(ConnectionManager.getConnectionStoreFileName() + TEMP_SUFFIX));
        }
        catch (IOException e) {
            Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, Messages.error__saving_connections + e.getMessage(), (Throwable)e);
            ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
        }
        File file = new File(ConnectionManager.getConnectionStoreFileName());
        File tempFile = new File(ConnectionManager.getConnectionStoreFileName() + TEMP_SUFFIX);
        if (file.exists()) {
            file.delete();
        }
        try {
            String content = FileUtils.readFileToString((File)tempFile, (String)ENCODING_UTF8);
            FileUtils.writeStringToFile((File)file, (String)content, (String)ENCODING_UTF8);
        }
        catch (IOException e) {
            Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, Messages.error__saving_connections + e.getMessage(), (Throwable)e);
            ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }

    private synchronized void loadConnections() {
        Set<ConnectionParameter> connectionParameters = null;
        try {
            connectionParameters = ConnectionIO.load(new FileInputStream(ConnectionManager.getConnectionStoreFileName()));
        }
        catch (Exception e) {
            try {
                connectionParameters = ConnectionIO.load(new FileInputStream(ConnectionManager.getConnectionStoreFileName() + TEMP_SUFFIX));
            }
            catch (FileNotFoundException e1) {
                return;
            }
            catch (ConnectionIOException e1) {
                Status status = new Status(4, ConnectionCoreConstants.PLUGIN_ID, Messages.error__loading_connections + e.getMessage(), (Throwable)e);
                ConnectionCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        if (connectionParameters != null) {
            for (ConnectionParameter connectionParameter : connectionParameters) {
                Connection conn = new Connection(connectionParameter);
                this.connectionList.add(conn);
            }
        }
    }
}

