/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.converter.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.converter.schema.SchemaElement;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdifUtils;
import org.apache.directory.api.util.Strings;

public abstract class SchemaElementImpl
implements SchemaElement {
    protected String oid;
    protected String description;
    protected List<String> names = new ArrayList<String>();
    protected boolean obsolete = false;
    protected Map<String, List<String>> extensions = new HashMap<String, List<String>>();

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    @Override
    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public void setNames(List<String> names) {
        this.names = names;
    }

    @Override
    public List<String> getExtension(String key) {
        return this.extensions.get(key);
    }

    @Override
    public Map<String, List<String>> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(Map<String, List<String>> extensions) {
        this.extensions = extensions;
    }

    private String oidToLdif() {
        return "m-oid: " + this.oid + '\n';
    }

    private String nameToLdif() throws LdapException {
        if (this.names.size() == 0) {
            return "";
        }
        DefaultEntry entry = new DefaultEntry();
        DefaultAttribute attribute = new DefaultAttribute("m-name");
        for (String name : this.names) {
            attribute.add(new String[]{name});
        }
        entry.put(new Attribute[]{attribute});
        return LdifUtils.convertAttributesToLdif((Entry)entry);
    }

    private String descToLdif() throws LdapException {
        if (Strings.isEmpty((String)this.description)) {
            return "";
        }
        DefaultEntry entry = new DefaultEntry();
        DefaultAttribute attribute = new DefaultAttribute("m-description", new String[]{this.description});
        entry.put(new Attribute[]{attribute});
        return LdifUtils.convertAttributesToLdif((Entry)entry);
    }

    public abstract String dnToLdif(String var1) throws LdapException;

    protected String extensionsToLdif(String id) throws LdapException {
        StringBuilder sb = new StringBuilder();
        DefaultEntry entry = new DefaultEntry();
        DefaultAttribute attribute = new DefaultAttribute(id);
        for (String extension : this.extensions.keySet()) {
            attribute.add(new String[]{extension});
        }
        sb.append(LdifUtils.convertAttributesToLdif((Entry)entry));
        return sb.toString();
    }

    protected String schemaToLdif(String schemaName, String type) throws LdapException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dnToLdif(schemaName));
        sb.append("objectclass: ").append(type).append('\n');
        sb.append("objectclass: metaTop\n");
        sb.append("objectclass: top\n");
        sb.append(this.oidToLdif());
        sb.append(this.nameToLdif());
        sb.append(this.descToLdif());
        if (this.obsolete) {
            sb.append("m-obsolete: TRUE\n");
        }
        return sb.toString();
    }
}

