/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapservers.LdapServerAdapterExtensionsManager;
import org.apache.directory.studio.ldapservers.LdapServersManager;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterConfigurationPage;
import org.apache.directory.studio.ldapservers.model.LdapServerAdapterExtension;
import org.apache.directory.studio.ldapservers.wizards.Messages;
import org.apache.directory.studio.ldapservers.wizards.NewServerWizardConfigurationPage;
import org.apache.directory.studio.ldapservers.wizards.NewServerWizardSelectionPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewServerWizard
extends Wizard
implements INewWizard {
    private NewServerWizardSelectionPage adapterSelectionPage;
    private Map<String, NewServerWizardConfigurationPage> configurationPages = new HashMap<String, NewServerWizardConfigurationPage>();

    public void addPages() {
        this.adapterSelectionPage = new NewServerWizardSelectionPage();
        this.addPage((IWizardPage)this.adapterSelectionPage);
        List<LdapServerAdapterExtension> ldapServerAdapterExtensions = LdapServerAdapterExtensionsManager.getDefault().getLdapServerAdapterExtensions();
        for (LdapServerAdapterExtension ldapServerAdapterExtension : ldapServerAdapterExtensions) {
            String configurationPageClassName = ldapServerAdapterExtension.getConfigurationPageClassName();
            if (configurationPageClassName == null || "".equals(configurationPageClassName)) continue;
            try {
                LdapServerAdapterConfigurationPage configurationPage = ldapServerAdapterExtension.getNewConfigurationPageInstance();
                NewServerWizardConfigurationPage configurationWizardPage = new NewServerWizardConfigurationPage(configurationPage);
                this.configurationPages.put(ldapServerAdapterExtension.getId(), configurationWizardPage);
                this.addPage((IWizardPage)configurationWizardPage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean performFinish() {
        String serverName = this.adapterSelectionPage.getServerName();
        final LdapServerAdapterExtension adapterExtension = this.adapterSelectionPage.getLdapServerAdapterExtension();
        NewServerWizardConfigurationPage configurationPage = this.getConfigurationPage();
        final LdapServer server = new LdapServer();
        server.setName(serverName);
        server.setLdapServerAdapterExtension(adapterExtension);
        if (configurationPage != null) {
            configurationPage.saveConfiguration(server);
        }
        try {
            this.getContainer().run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    StudioProgressMonitor spm = new StudioProgressMonitor(monitor);
                    spm.beginTask(Messages.getString("NewServerWizard.CreatingLdapServer"), -1);
                    spm.subTask(Messages.getString("NewServerWizard.CreatingServerFolder"));
                    LdapServersManager.getDefault().addServer(server);
                    LdapServersManager.createNewServerFolder(server);
                    try {
                        adapterExtension.getInstance().add(server, spm);
                    }
                    catch (Exception e) {
                        spm.reportError(e);
                    }
                    spm.done();
                }
            });
        }
        catch (Exception e) {
            // empty catch block
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(Messages.getString("NewServerWizard.NewLdapServer"));
        this.setNeedsProgressMonitor(true);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        NewServerWizardConfigurationPage configurationPage = this.getConfigurationPage();
        if (((Object)((Object)this.adapterSelectionPage)).equals(page)) {
            return configurationPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.adapterSelectionPage.isPageComplete()) {
            NewServerWizardConfigurationPage configurationPage = this.getConfigurationPage();
            if (configurationPage != null) {
                return configurationPage.isPageComplete();
            }
            return true;
        }
        return false;
    }

    private NewServerWizardConfigurationPage getConfigurationPage() {
        String configurationPageClassName;
        LdapServerAdapterExtension ldapServerAdapterExtension = this.adapterSelectionPage.getLdapServerAdapterExtension();
        if (ldapServerAdapterExtension != null && (configurationPageClassName = ldapServerAdapterExtension.getConfigurationPageClassName()) != null && !"".equals(configurationPageClassName)) {
            return this.configurationPages.get(ldapServerAdapterExtension.getId());
        }
        return null;
    }
}

