/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.actions;

import org.apache.directory.studio.ldapservers.LdapServersPluginConstants;
import org.apache.directory.studio.ldapservers.actions.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.apache.directory.studio.ldapservers.views.ServersView;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PropertiesAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private ServersView view;

    public PropertiesAction() {
        super(Messages.getString("PropertiesAction.Properties"));
        this.init();
    }

    public PropertiesAction(ServersView view) {
        super(Messages.getString("PropertiesAction.Properties"));
        this.view = view;
        this.init();
    }

    private void init() {
        this.setId(LdapServersPluginConstants.CMD_PROPERTIES);
        this.setActionDefinitionId(LdapServersPluginConstants.CMD_PROPERTIES);
        this.setToolTipText(Messages.getString("PropertiesAction.PropertiesToolTip"));
    }

    public void run() {
        StructuredSelection selection;
        if (this.view != null && !(selection = (StructuredSelection)this.view.getViewer().getSelection()).isEmpty()) {
            LdapServer server = (LdapServer)selection.getFirstElement();
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.view.getViewSite().getShell(), (IAdaptable)server, (String)"org.apache.directory.studio.ldapservers.properties.ServerPropertyPage", null, null);
            dialog.getShell().setText(NLS.bind((String)Messages.getString("PropertiesAction.PropertiesFor"), (Object)PropertiesAction.shorten(server.getName(), 30)));
            dialog.open();
        }
    }

    public static String shorten(String label, int maxLength) {
        if (label == null) {
            return null;
        }
        if (maxLength < 3) {
            return "...";
        }
        if (label.length() > maxLength) {
            label = label.substring(0, maxLength / 2) + "..." + label.substring(label.length() - maxLength / 2, label.length());
        }
        StringBuffer sb = new StringBuffer(maxLength + 3);
        for (int i = 0; i < label.length(); ++i) {
            char c = label.charAt(i);
            if (Character.isISOControl(c)) {
                sb.append('.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

