/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.model;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.utils.UnixCrypt;
import org.apache.directory.studio.ldifparser.LdifUtils;

public class Password {
    private LdapSecurityConstants hashMethod;
    private byte[] hashedPassword;
    private byte[] salt;
    private boolean isUnsupportedHashMethod;
    private boolean isInvalidHashValue;
    private String trash;

    public Password(byte[] password) {
        this(LdifUtils.utf8decode((byte[])password));
    }

    public Password(String password) {
        block15: {
            this.isUnsupportedHashMethod = false;
            this.isInvalidHashValue = false;
            if (password == null) {
                throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
            }
            if (password.indexOf(123) == 0 && password.indexOf(125) > 0) {
                try {
                    String hashMethodString = password.substring(password.indexOf(123) + 1, password.indexOf(125));
                    this.hashMethod = LdapSecurityConstants.getAlgorithm((String)hashMethodString);
                    String rest = password.substring(hashMethodString.length() + 2);
                    if (LdapSecurityConstants.HASH_METHOD_SHA == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA256 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA384 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA512 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_MD5 == this.hashMethod) {
                        this.hashedPassword = LdifUtils.base64decodeToByteArray((String)rest);
                        this.salt = null;
                        break block15;
                    }
                    if (LdapSecurityConstants.HASH_METHOD_SSHA == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA256 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA384 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA512 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SMD5 == this.hashMethod) {
                        switch (this.hashMethod) {
                            case HASH_METHOD_SSHA: {
                                this.hashedPassword = new byte[20];
                                break;
                            }
                            case HASH_METHOD_SSHA256: {
                                this.hashedPassword = new byte[32];
                                break;
                            }
                            case HASH_METHOD_SSHA384: {
                                this.hashedPassword = new byte[48];
                                break;
                            }
                            case HASH_METHOD_SSHA512: {
                                this.hashedPassword = new byte[64];
                                break;
                            }
                            case HASH_METHOD_SMD5: {
                                this.hashedPassword = new byte[16];
                                break;
                            }
                        }
                        byte[] hashedPasswordWithSalt = LdifUtils.base64decodeToByteArray((String)rest);
                        this.salt = new byte[hashedPasswordWithSalt.length - this.hashedPassword.length];
                        Password.split(hashedPasswordWithSalt, this.hashedPassword, this.salt);
                        break block15;
                    }
                    if (LdapSecurityConstants.HASH_METHOD_CRYPT == this.hashMethod) {
                        byte[] saltWithPassword = LdifUtils.utf8encode((String)rest);
                        this.salt = new byte[2];
                        this.hashedPassword = new byte[saltWithPassword.length - this.salt.length];
                        Password.split(saltWithPassword, this.salt, this.hashedPassword);
                        break block15;
                    }
                    this.isUnsupportedHashMethod = true;
                    this.trash = password;
                }
                catch (RuntimeException e) {
                    this.isInvalidHashValue = true;
                    this.trash = password;
                }
            } else {
                this.hashMethod = null;
                this.hashedPassword = LdifUtils.utf8encode((String)password);
                this.salt = null;
            }
        }
    }

    public Password(LdapSecurityConstants hashMethod, String passwordAsPlaintext) {
        this.isUnsupportedHashMethod = false;
        this.isInvalidHashValue = false;
        if (passwordAsPlaintext == null) {
            throw new IllegalArgumentException(BrowserCoreMessages.model__empty_password);
        }
        this.hashMethod = hashMethod;
        if (LdapSecurityConstants.HASH_METHOD_SSHA == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA256 == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA384 == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA512 == hashMethod || LdapSecurityConstants.HASH_METHOD_SMD5 == hashMethod) {
            this.salt = new byte[8];
            new SecureRandom().nextBytes(this.salt);
        } else if (LdapSecurityConstants.HASH_METHOD_CRYPT == hashMethod) {
            this.salt = new byte[2];
            SecureRandom sr = new SecureRandom();
            int i1 = sr.nextInt(64);
            int i2 = sr.nextInt(64);
            this.salt[0] = (byte)(i1 < 12 ? i1 + 46 : (i1 < 38 ? i1 + 65 - 12 : i1 + 97 - 38));
            this.salt[1] = (byte)(i2 < 12 ? i2 + 46 : (i2 < 38 ? i2 + 65 - 12 : i2 + 97 - 38));
        } else {
            this.salt = null;
        }
        if (hashMethod == null) {
            this.hashedPassword = LdifUtils.utf8encode((String)passwordAsPlaintext);
        } else if (LdapSecurityConstants.HASH_METHOD_SHA == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA == hashMethod || LdapSecurityConstants.HASH_METHOD_SHA256 == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA256 == hashMethod || LdapSecurityConstants.HASH_METHOD_SHA384 == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA384 == hashMethod || LdapSecurityConstants.HASH_METHOD_SHA512 == hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA512 == hashMethod || LdapSecurityConstants.HASH_METHOD_MD5 == hashMethod || LdapSecurityConstants.HASH_METHOD_SMD5 == hashMethod) {
            this.hashedPassword = Password.digest(hashMethod, passwordAsPlaintext, this.salt);
        } else if (LdapSecurityConstants.HASH_METHOD_CRYPT == hashMethod) {
            this.hashedPassword = Password.crypt(passwordAsPlaintext, this.salt);
        }
    }

    public boolean verify(String testPasswordAsPlaintext) {
        if (testPasswordAsPlaintext == null) {
            return false;
        }
        boolean verified = false;
        if (this.isInvalidHashValue || this.isUnsupportedHashMethod) {
            return false;
        }
        if (this.hashMethod == null) {
            verified = testPasswordAsPlaintext.equals(LdifUtils.utf8decode((byte[])this.hashedPassword));
        } else if (LdapSecurityConstants.HASH_METHOD_SHA == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA256 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA256 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA384 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA384 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SHA512 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SSHA512 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_MD5 == this.hashMethod || LdapSecurityConstants.HASH_METHOD_SMD5 == this.hashMethod) {
            byte[] hash = Password.digest(this.hashMethod, testPasswordAsPlaintext, this.salt);
            verified = Password.equals(hash, this.hashedPassword);
        } else if (LdapSecurityConstants.HASH_METHOD_CRYPT == this.hashMethod) {
            byte[] crypted = Password.crypt(testPasswordAsPlaintext, this.salt);
            verified = Password.equals(crypted, this.hashedPassword);
        }
        return verified;
    }

    public LdapSecurityConstants getHashMethod() {
        return this.hashMethod;
    }

    public byte[] getHashedPassword() {
        return this.hashedPassword;
    }

    public String getHashedPasswordAsHexString() {
        return LdifUtils.hexEncode((byte[])this.hashedPassword);
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public String getSaltAsHexString() {
        return LdifUtils.hexEncode((byte[])this.salt);
    }

    public byte[] toBytes() {
        return LdifUtils.utf8encode((String)this.toString());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.isUnsupportedHashMethod || this.isInvalidHashValue) {
            sb.append(this.trash);
        } else if (LdapSecurityConstants.HASH_METHOD_CRYPT == this.hashMethod) {
            sb.append('{').append(this.hashMethod.getPrefix()).append('}');
            sb.append(LdifUtils.utf8decode((byte[])this.salt));
            sb.append(LdifUtils.utf8decode((byte[])this.hashedPassword));
        } else if (this.hashMethod != null) {
            sb.append('{').append(this.hashMethod.getPrefix()).append('}');
            if (this.salt != null) {
                byte[] hashedPasswordWithSaltBytes = new byte[this.hashedPassword.length + this.salt.length];
                Password.merge(hashedPasswordWithSaltBytes, this.hashedPassword, this.salt);
                sb.append(LdifUtils.base64encode((byte[])hashedPasswordWithSaltBytes));
            } else {
                sb.append(LdifUtils.base64encode((byte[])this.hashedPassword));
            }
        } else {
            sb.append(LdifUtils.utf8decode((byte[])this.hashedPassword));
        }
        return sb.toString();
    }

    private static void split(byte[] all, byte[] left, byte[] right) {
        System.arraycopy(all, 0, left, 0, left.length);
        System.arraycopy(all, left.length, right, 0, right.length);
    }

    private static void merge(byte[] all, byte[] left, byte[] right) {
        System.arraycopy(left, 0, all, 0, left.length);
        System.arraycopy(right, 0, all, left.length, right.length);
    }

    private static boolean equals(byte[] data1, byte[] data2) {
        if (data1 == data2) {
            return true;
        }
        if (data1 == null || data2 == null) {
            return false;
        }
        if (data1.length != data2.length) {
            return false;
        }
        for (int i = 0; i < data1.length; ++i) {
            if (data1[i] == data2[i]) continue;
            return false;
        }
        return true;
    }

    private static byte[] digest(LdapSecurityConstants hashMethod, String password, byte[] salt) {
        byte[] passwordBytes = LdifUtils.utf8encode((String)password);
        try {
            MessageDigest digest = MessageDigest.getInstance(hashMethod.getAlgorithm());
            if (salt != null) {
                digest.update(passwordBytes);
                digest.update(salt);
                return digest.digest();
            }
            return digest.digest(passwordBytes);
        }
        catch (NoSuchAlgorithmException e1) {
            return null;
        }
    }

    private static byte[] crypt(String password, byte[] salt) {
        String saltWithCrypted = UnixCrypt.crypt(password, LdifUtils.utf8decode((byte[])salt));
        String crypted = saltWithCrypted.substring(2);
        return LdifUtils.utf8encode((String)crypted);
    }
}

