/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldifeditor.editor.reconciler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.studio.ldifeditor.LdifEditorActivator;
import org.apache.directory.studio.ldifeditor.editor.ILdifEditor;
import org.apache.directory.studio.ldifparser.model.LdifFile;
import org.apache.directory.studio.ldifparser.model.LdifPart;
import org.apache.directory.studio.ldifparser.model.container.LdifCommentContainer;
import org.apache.directory.studio.ldifparser.model.container.LdifContainer;
import org.apache.directory.studio.ldifparser.model.lines.LdifNonEmptyLineBase;
import org.apache.directory.studio.ldifparser.model.lines.LdifSepLine;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class LdifFoldingRegionUpdater
implements IPropertyChangeListener {
    private ILdifEditor editor;

    public LdifFoldingRegionUpdater(ILdifEditor editor) {
        this.editor = editor;
        LdifEditorActivator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void dispose() {
        LdifEditorActivator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("ldifEditorFoldingEnable".equals(event.getProperty()) || "ldifEditorFoldingInitiallyFoldComments".equals(event.getProperty()) || "ldifEditoroldingInitiallyFoldRecords".equals(event.getProperty()) || "ldifEditorFoldingInitiallyFoldWrappedLines".equals(event.getProperty())) {
            this.updateFoldingRegions();
        }
    }

    public void updateFoldingRegions() {
        ISourceViewer viewer = (ISourceViewer)this.editor.getAdapter(ISourceViewer.class);
        if (viewer == null) {
            return;
        }
        IDocument document = viewer.getDocument();
        try {
            ProjectionAnnotationModel projectionAnnotationModel = (ProjectionAnnotationModel)this.editor.getAdapter(ProjectionAnnotationModel.class);
            if (projectionAnnotationModel == null) {
                return;
            }
            Map positionToAnnotationMap = this.createFoldingRegions(this.editor.getLdifModel(), document);
            ArrayList annotationsToDeleteList = new ArrayList();
            HashMap annotationsToAddMap = new HashMap();
            this.computeDifferences(projectionAnnotationModel, positionToAnnotationMap, annotationsToDeleteList, annotationsToAddMap);
            Annotation[] annotationsToDelete = annotationsToDeleteList.toArray(new Annotation[annotationsToDeleteList.size()]);
            if (!annotationsToDeleteList.isEmpty() || !annotationsToAddMap.isEmpty()) {
                projectionAnnotationModel.modifyAnnotations(annotationsToDelete, annotationsToAddMap, new Annotation[0]);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    private void computeDifferences(ProjectionAnnotationModel model, Map positionToAnnotationMap, List annotationsToDeleteList, Map annotationsToAddMap) {
        Iterator iter = model.getAnnotationIterator();
        while (iter.hasNext()) {
            Object annotation = iter.next();
            if (!(annotation instanceof ProjectionAnnotation)) continue;
            Position position = model.getPosition((Annotation)annotation);
            if (positionToAnnotationMap.containsKey(position)) {
                positionToAnnotationMap.remove(position);
                continue;
            }
            annotationsToDeleteList.add(annotation);
        }
        for (Position position : positionToAnnotationMap.keySet()) {
            ProjectionAnnotation annotation = (ProjectionAnnotation)positionToAnnotationMap.get(position);
            annotationsToAddMap.put(annotation, position);
        }
    }

    private Map createFoldingRegions(LdifFile model, IDocument document) throws BadLocationException {
        HashMap<Position, ProjectionAnnotation> positionToAnnotationMap = new HashMap<Position, ProjectionAnnotation>();
        LdifContainer[] containers = model.getContainers();
        boolean ENABLE_FOLDING = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingEnable");
        boolean FOLD_COMMENTS = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingInitiallyFoldComments");
        boolean FOLD_RECORDS = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditoroldingInitiallyFoldRecords");
        boolean FOLD_WRAPPEDLINES = LdifEditorActivator.getDefault().getPreferenceStore().getBoolean("ldifEditorFoldingInitiallyFoldWrappedLines");
        if (ENABLE_FOLDING) {
            for (int i = 0; i < containers.length; ++i) {
                ProjectionAnnotation annotation;
                Position position;
                LdifContainer container = containers[i];
                int containerStartLine = document.getLineOfOffset(container.getOffset());
                int containerEndLine = -1;
                LdifPart[] parts = container.getParts();
                for (int j = parts.length - 1; j >= 0; --j) {
                    LdifNonEmptyLineBase line;
                    if (containerEndLine == -1 && (!(parts[j] instanceof LdifSepLine) || container instanceof LdifCommentContainer && j < parts.length - 1)) {
                        containerEndLine = document.getLineOfOffset(parts[j].getOffset() + parts[j].getLength() - 1);
                    }
                    if (!(parts[j] instanceof LdifNonEmptyLineBase) || !(line = (LdifNonEmptyLineBase)parts[j]).isFolded()) continue;
                    position = new Position(line.getOffset(), line.getLength());
                    annotation = new ProjectionAnnotation(FOLD_WRAPPEDLINES);
                    positionToAnnotationMap.put(position, annotation);
                }
                if (containerStartLine >= containerEndLine) continue;
                int start = document.getLineOffset(containerStartLine);
                int end = document.getLineOffset(containerEndLine) + document.getLineLength(containerEndLine);
                position = new Position(start, end - start);
                annotation = new ProjectionAnnotation(FOLD_RECORDS || FOLD_COMMENTS && container instanceof LdifCommentContainer);
                positionToAnnotationMap.put(position, annotation);
            }
        }
        return positionToAnnotationMap;
    }
}

