/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.v2.editor;

import java.util.ArrayList;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.server.config.beans.JdbmIndexBean;
import org.apache.directory.server.config.beans.JdbmPartitionBean;
import org.apache.directory.server.config.beans.PartitionBean;
import org.apache.directory.studio.apacheds.configuration.v2.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.v2.editor.PartitionDetailsPage;
import org.apache.directory.studio.apacheds.configuration.v2.editor.PartitionsPage;
import org.apache.directory.studio.apacheds.configuration.v2.editor.ServerConfigurationEditor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.MasterDetailsBlock;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PartitionsMasterDetailsBlock
extends MasterDetailsBlock {
    private static final String NEW_ID = Messages.getString("PartitionsMasterDetailsBlock.PartitionNewId");
    private PartitionsPage page;
    private PartitionDetailsPage detailsPage;
    private TableViewer viewer;
    private Button addButton;
    private Button deleteButton;

    public PartitionsMasterDetailsBlock(PartitionsPage page) {
        this.page = page;
    }

    protected void createMasterPart(final IManagedForm managedForm, Composite parent) {
        FormToolkit toolkit = managedForm.getToolkit();
        Section section = toolkit.createSection(parent, 256);
        section.setText(Messages.getString("PartitionsMasterDetailsBlock.AllPartitions"));
        section.marginWidth = 10;
        section.marginHeight = 5;
        Composite client = toolkit.createComposite((Composite)section, 64);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        client.setLayout((Layout)layout);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        Table table = toolkit.createTable(client, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 2);
        gd.heightHint = 20;
        gd.widthHint = 100;
        table.setLayoutData((Object)gd);
        final SectionPart spart = new SectionPart(section);
        managedForm.addPart((IFormPart)spart);
        this.viewer = new TableViewer(table);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                managedForm.fireSelectionChanged((IFormPart)spart, event.getSelection());
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)PartitionsPage.PARTITIONS_LABEL_PROVIDER);
        this.viewer.setComparator(PartitionsPage.PARTITIONS_COMPARATOR);
        this.addButton = toolkit.createButton(client, Messages.getString("PartitionsMasterDetailsBlock.Add"), 8);
        this.addButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.deleteButton = toolkit.createButton(client, Messages.getString("PartitionsMasterDetailsBlock.Delete"), 8);
        this.deleteButton.setEnabled(false);
        this.deleteButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.initFromInput();
        this.addListeners();
    }

    private void initFromInput() {
        this.viewer.setInput((Object)this.page.getConfigBean().getDirectoryServiceBean().getPartitions());
    }

    private void addListeners() {
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JdbmPartitionBean partition;
                PartitionsMasterDetailsBlock.this.viewer.refresh();
                StructuredSelection selection = (StructuredSelection)PartitionsMasterDetailsBlock.this.viewer.getSelection();
                PartitionsMasterDetailsBlock.this.deleteButton.setEnabled(!selection.isEmpty());
                if (!selection.isEmpty() && PartitionsPage.isSystemPartition((PartitionBean)(partition = (JdbmPartitionBean)selection.getFirstElement()))) {
                    PartitionsMasterDetailsBlock.this.deleteButton.setEnabled(false);
                }
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartitionsMasterDetailsBlock.this.addNewPartition();
            }
        });
        this.deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PartitionsMasterDetailsBlock.this.deleteSelectedPartition();
            }
        });
    }

    private void addNewPartition() {
        String newId = this.getNewId();
        JdbmPartitionBean newPartitionBean = new JdbmPartitionBean();
        newPartitionBean.setPartitionId(newId);
        try {
            newPartitionBean.setPartitionSuffix(new Dn(new String[]{"dc=" + newId + ",dc=com"}));
        }
        catch (LdapInvalidDnException e1) {
            // empty catch block
        }
        newPartitionBean.setPartitionCacheSize(100);
        newPartitionBean.setJdbmPartitionOptimizerEnabled(true);
        newPartitionBean.setPartitionSyncOnWrite(true);
        newPartitionBean.setContextEntry(PartitionsMasterDetailsBlock.getContextEntryLdif(newPartitionBean.getPartitionSuffix()));
        ArrayList<JdbmIndexBean<String, Entry>> indexes = new ArrayList<JdbmIndexBean<String, Entry>>();
        indexes.add(this.createJdbmIndex("apacheAlias", 100));
        indexes.add(this.createJdbmIndex("apacheOneAlias", 100));
        indexes.add(this.createJdbmIndex("apacheOneLevel", 100));
        indexes.add(this.createJdbmIndex("apachePresence", 100));
        indexes.add(this.createJdbmIndex("apacheRdn", 100));
        indexes.add(this.createJdbmIndex("apacheSubAlias", 100));
        indexes.add(this.createJdbmIndex("apacheSubLevel", 100));
        indexes.add(this.createJdbmIndex("dc", 100));
        indexes.add(this.createJdbmIndex("entryCSN", 100));
        indexes.add(this.createJdbmIndex("entryUUID", 100));
        indexes.add(this.createJdbmIndex("krb5PrincipalName", 100));
        indexes.add(this.createJdbmIndex("objectClass", 100));
        indexes.add(this.createJdbmIndex("ou", 100));
        indexes.add(this.createJdbmIndex("uid", 100));
        newPartitionBean.setIndexes(indexes);
        this.page.getConfigBean().getDirectoryServiceBean().addPartitions(new PartitionBean[]{newPartitionBean});
        this.viewer.refresh();
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)newPartitionBean));
        this.setEditorDirty();
    }

    private String getNewId() {
        int counter = 1;
        String name = NEW_ID;
        boolean ok = false;
        while (!ok) {
            ok = true;
            name = NEW_ID + counter;
            for (PartitionBean partition : this.page.getConfigBean().getDirectoryServiceBean().getPartitions()) {
                if (!partition.getPartitionId().equalsIgnoreCase(name)) continue;
                ok = false;
            }
            ++counter;
        }
        return name;
    }

    public static String getContextEntryLdif(Dn dn) {
        try {
            DefaultEntry entry = new DefaultEntry(dn);
            entry.add("objectClass", new String[]{"domain"});
            entry.add("objectClass", new String[]{"top"});
            Rdn rdn = dn.getRdn();
            if (!"dc".equalsIgnoreCase(rdn.getType())) {
                entry.add("objectClass", new String[]{"extensibleObject"});
                entry.add("dc", new Value[]{rdn.getValue()});
            }
            entry.add(rdn.getType(), new Value[]{rdn.getValue()});
            LdifEntry ldifEntry = new LdifEntry((Entry)entry);
            return ldifEntry.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private void deleteSelectedPartition() {
        JdbmPartitionBean partition;
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && !PartitionsPage.isSystemPartition((PartitionBean)(partition = (JdbmPartitionBean)selection.getFirstElement())) && MessageDialog.openConfirm((Shell)this.page.getManagedForm().getForm().getShell(), (String)Messages.getString("PartitionsMasterDetailsBlock.ConfirmDelete"), (String)NLS.bind((String)Messages.getString("PartitionsMasterDetailsBlock.AreYouSureDeletePartition"), (Object)partition.getPartitionId(), (Object)partition.getPartitionSuffix()))) {
            this.page.getConfigBean().getDirectoryServiceBean().getPartitions().remove(partition);
            this.setEditorDirty();
        }
    }

    private JdbmIndexBean<String, Entry> createJdbmIndex(String indexAttributeId, int indexCacheSize) {
        JdbmIndexBean index = new JdbmIndexBean();
        index.setIndexAttributeId(indexAttributeId);
        index.setIndexCacheSize(indexCacheSize);
        return index;
    }

    protected void registerPages(DetailsPart detailsPart) {
        this.detailsPage = new PartitionDetailsPage(this);
        detailsPart.registerPage(JdbmPartitionBean.class, (IDetailsPage)this.detailsPage);
    }

    protected void createToolBarActions(IManagedForm managedForm) {
    }

    public void setEditorDirty() {
        ((ServerConfigurationEditor)this.page.getEditor()).setDirty(true);
        this.viewer.refresh();
    }

    public void save() {
        this.detailsPage.commit(true);
    }
}

