/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.authn.ppolicy;

import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordValidator;

public class DefaultPasswordValidator
implements PasswordValidator {
    public static final DefaultPasswordValidator INSTANCE = new DefaultPasswordValidator();

    @Override
    public void validate(String password, String entryRdnVal) throws PasswordPolicyException {
        this.checkUsernameSubstring(password, entryRdnVal);
    }

    private void checkUsernameSubstring(String password, String username) throws PasswordPolicyException {
        String[] tokens;
        if (username == null || username.trim().length() == 0) {
            return;
        }
        for (String token : tokens = username.split("[^a-zA-Z]")) {
            if (token == null || token.length() < 4 || !password.matches("(?i).*" + token + ".*")) continue;
            throw new PasswordPolicyException("Password shouldn't contain parts of the username", 5);
        }
    }
}

