/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.views.browser;

import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.CopyAction;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAction;
import org.apache.directory.studio.ldapbrowser.common.actions.DeleteAllAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FetchAliasesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FetchOperationalAttributesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FetchReferralsAction;
import org.apache.directory.studio.ldapbrowser.common.actions.FetchSubentriesAction;
import org.apache.directory.studio.ldapbrowser.common.actions.RenameAction;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.BrowserActionProxy;
import org.apache.directory.studio.ldapbrowser.common.actions.proxy.BrowserViewActionProxy;
import org.apache.directory.studio.ldapbrowser.common.widgets.browser.BrowserActionGroup;
import org.apache.directory.studio.ldapbrowser.ui.actions.BrowserPasteAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyDnAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsCsvAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyEntryAsLdifAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.CopyUrlAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.EntryEditorMenuManager;
import org.apache.directory.studio.ldapbrowser.ui.actions.GotoDnAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.ImportExportAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.LocateEntryInDitAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.MoveAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewBatchOperationAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewBookmarkAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewContextEntryAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewEntryAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.NewSearchAction;
import org.apache.directory.studio.ldapbrowser.ui.actions.OpenEntryEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.BrowserView;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.LinkWithEditorAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.Messages;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.OpenBrowserPreferencePageAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.ShowBookmarksAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.ShowDITAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.ShowDirectoryMetadataEntriesAction;
import org.apache.directory.studio.ldapbrowser.ui.views.browser.ShowSearchesAction;
import org.apache.directory.studio.utils.ActionUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.actions.ActionFactory;

public class BrowserViewActionGroup
extends BrowserActionGroup {
    private ShowDITAction showDITAction;
    private ShowSearchesAction showSearchesAction;
    private ShowBookmarksAction showBookmarksAction;
    private ShowDirectoryMetadataEntriesAction showDirectoryMetadataEntriesAction;
    private OpenBrowserPreferencePageAction openBrowserPreferencePageAction;
    private LinkWithEditorAction linkWithEditorAction;
    private static final String locateEntryInDitAction = "locateEntryInDitAction";
    private static final String gotoDnAction = "gotoDnAction";
    private static final String newEntryAction = "newEntryAction";
    private static final String newContextEntryAction = "newContextEntryAction";
    private static final String newSearchAction = "newSearchAction";
    private static final String newBookmarkAction = "newBookmarkAction";
    private static final String newBatchOperationAction = "newBatchOperationAction";
    private static final String copyAction = "copyAction";
    private static final String pasteAction = "pasteAction";
    private static final String deleteAction = "deleteAction";
    private static final String moveAction = "moveAction";
    private static final String renameAction = "renameAction";
    private static final String copyDnAction = "copyDnAction";
    private static final String copyUrlAction = "copyUrlAction";
    private static final String copyEntryAsLdifDnOnlyAction = "copyEntryAsLdifDnOnlyAction";
    private static final String copyEntryAsLdifReturningAttributesOnlyAction = "copyEntryAsLdifReturningAttributesOnlyAction";
    private static final String copyEntryAsLdifAction = "copyEntryAsLdifAction";
    private static final String copyEntryAsLdifOperationalAction = "copyEntryAsLdifOperationalAction";
    private static final String copyEntryAsCsvDnOnlyAction = "copyEntryAsCsvDnOnlyAction";
    private static final String copyEntryAsCsvReturningAttributesOnlyAction = "copyEntryAsCsvReturningAttributesOnlyAction";
    private static final String copyEntryAsCsvAction = "copyEntryAsCsvAction";
    private static final String copyEntryAsCsvOperationalAction = "copyEntryAsCsvOperationalAction";
    private static final String deleteAllAction = "deleteAllAction";
    private static final String importDsmlAction = "importDsmlAction";
    private static final String importLdifAction = "importLdifAction";
    private static final String exportLdifAction = "exportLdifAction";
    private static final String exportDsmlAction = "exportDsmlAction";
    private static final String exportCsvAction = "exportCsvAction";
    private static final String exportExcelAction = "exportExcelAction";
    private static final String exportOdfAction = "exportOdfAction";
    private static final String fetchOperationalAttributesAction = "fetchOperationalAttributesAction";
    private static final String fetchAliasesAction = "fetchAliasesAction";
    private static final String fetchReferralsAction = "fetchReferralsAction";
    private static final String fetchSubentriesAction = "fetchSubentriesAction";
    private static final String openEntryEditorAction = "openEntryEditor";

    public BrowserViewActionGroup(BrowserView view) {
        super(view.getMainWidget(), view.getConfiguration());
        TreeViewer viewer = view.getMainWidget().getViewer();
        this.linkWithEditorAction = new LinkWithEditorAction(view);
        this.showDITAction = new ShowDITAction();
        this.showSearchesAction = new ShowSearchesAction();
        this.showBookmarksAction = new ShowBookmarksAction();
        this.showDirectoryMetadataEntriesAction = new ShowDirectoryMetadataEntriesAction();
        this.openBrowserPreferencePageAction = new OpenBrowserPreferencePageAction();
        this.browserActionMap.put(newEntryAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new NewEntryAction(view.getSite().getWorkbenchWindow())));
        this.browserActionMap.put(newContextEntryAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new NewContextEntryAction(view.getSite().getWorkbenchWindow())));
        this.browserActionMap.put(newSearchAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new NewSearchAction()));
        this.browserActionMap.put(newBookmarkAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new NewBookmarkAction()));
        this.browserActionMap.put(newBatchOperationAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new NewBatchOperationAction()));
        this.browserActionMap.put(locateEntryInDitAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new LocateEntryInDitAction()));
        this.browserActionMap.put(gotoDnAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new GotoDnAction()));
        this.browserActionMap.put(pasteAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new BrowserPasteAction()));
        this.browserActionMap.put(copyAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyAction((BrowserActionProxy)this.browserActionMap.get(pasteAction))));
        this.browserActionMap.put(deleteAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new DeleteAction()));
        this.browserActionMap.put(moveAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new MoveAction()));
        this.browserActionMap.put(renameAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new RenameAction()));
        this.browserActionMap.put(copyDnAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyDnAction()));
        this.browserActionMap.put(copyUrlAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyUrlAction()));
        this.browserActionMap.put(copyEntryAsLdifAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsLdifAction(3)));
        this.browserActionMap.put(copyEntryAsLdifDnOnlyAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsLdifAction(1)));
        this.browserActionMap.put(copyEntryAsLdifReturningAttributesOnlyAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsLdifAction(2)));
        this.browserActionMap.put(copyEntryAsLdifOperationalAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsLdifAction(4)));
        this.browserActionMap.put(copyEntryAsCsvAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsCsvAction(3)));
        this.browserActionMap.put(copyEntryAsCsvDnOnlyAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsCsvAction(1)));
        this.browserActionMap.put(copyEntryAsCsvReturningAttributesOnlyAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsCsvAction(2)));
        this.browserActionMap.put(copyEntryAsCsvOperationalAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new CopyEntryAsCsvAction(4)));
        this.browserActionMap.put(deleteAllAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new DeleteAllAction()));
        this.browserActionMap.put(importDsmlAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(4)));
        this.browserActionMap.put(exportDsmlAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(5)));
        this.browserActionMap.put(importLdifAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(0)));
        this.browserActionMap.put(exportLdifAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(1)));
        this.browserActionMap.put(exportCsvAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(2)));
        this.browserActionMap.put(exportExcelAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(3)));
        this.browserActionMap.put(exportOdfAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new ImportExportAction(6)));
        this.browserActionMap.put(fetchOperationalAttributesAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new FetchOperationalAttributesAction()));
        this.browserActionMap.put(fetchAliasesAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new FetchAliasesAction()));
        this.browserActionMap.put(fetchReferralsAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new FetchReferralsAction()));
        this.browserActionMap.put(fetchSubentriesAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new FetchSubentriesAction()));
        this.browserActionMap.put(openEntryEditorAction, new BrowserViewActionProxy((Viewer)viewer, (BrowserAction)new OpenEntryEditorAction()));
    }

    public void dispose() {
        if (this.openBrowserPreferencePageAction != null) {
            this.linkWithEditorAction.dispose();
            this.linkWithEditorAction = null;
            this.showDITAction = null;
            this.showSearchesAction = null;
            this.showBookmarksAction = null;
            this.showDirectoryMetadataEntriesAction = null;
            this.openBrowserPreferencePageAction = null;
        }
        super.dispose();
    }

    public void fillToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.browserActionMap.get("upAction"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.browserActionMap.get("refreshAction"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.collapseAllAction);
        toolBarManager.add((IAction)this.linkWithEditorAction);
        toolBarManager.update(true);
    }

    public void fillMenu(IMenuManager menuManager) {
        menuManager.add((IAction)this.openSortDialogAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.showQuickSearchAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.showDITAction);
        menuManager.add((IAction)this.showSearchesAction);
        menuManager.add((IAction)this.showBookmarksAction);
        menuManager.add((IAction)this.showDirectoryMetadataEntriesAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.openBrowserPreferencePageAction);
        menuManager.update(true);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        MenuManager newMenuManager = new MenuManager(Messages.getString("BrowserViewActionGroup.New"));
        newMenuManager.add((IAction)this.browserActionMap.get(newEntryAction));
        newMenuManager.add((IAction)this.browserActionMap.get(newContextEntryAction));
        newMenuManager.add((IContributionItem)new Separator());
        newMenuManager.add((IAction)this.browserActionMap.get(newSearchAction));
        newMenuManager.add((IAction)this.browserActionMap.get(newBookmarkAction));
        newMenuManager.add((IContributionItem)new Separator());
        newMenuManager.add((IAction)this.browserActionMap.get(newBatchOperationAction));
        menuManager.add((IContributionItem)newMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get(openEntryEditorAction));
        EntryEditorMenuManager openWithEntryEditorMenuManager = new EntryEditorMenuManager((ISelectionProvider)this.mainWidget.getViewer());
        menuManager.add((IContributionItem)openWithEntryEditorMenuManager);
        BrowserViewActionProxy leid = (BrowserViewActionProxy)this.browserActionMap.get(locateEntryInDitAction);
        leid.setImageDescriptor(leid.getAction().getImageDescriptor());
        menuManager.add((IAction)leid);
        menuManager.add((IAction)this.browserActionMap.get(gotoDnAction));
        menuManager.add((IAction)this.browserActionMap.get("upAction"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get(copyAction));
        menuManager.add((IAction)this.browserActionMap.get(pasteAction));
        menuManager.add((IAction)this.browserActionMap.get(deleteAction));
        menuManager.add((IAction)this.browserActionMap.get(moveAction));
        menuManager.add((IAction)this.browserActionMap.get(renameAction));
        MenuManager advancedMenuManager = new MenuManager(Messages.getString("BrowserViewActionGroup.Advanced"));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyDnAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyUrlAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsLdifDnOnlyAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsLdifReturningAttributesOnlyAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsLdifAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsLdifOperationalAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsCsvDnOnlyAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsCsvReturningAttributesOnlyAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsCsvAction));
        advancedMenuManager.add((IAction)this.browserActionMap.get(copyEntryAsCsvOperationalAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        advancedMenuManager.add((IAction)this.browserActionMap.get(deleteAllAction));
        advancedMenuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)advancedMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get("filterChildrenAction"));
        if (((BrowserViewActionProxy)this.browserActionMap.get("unfilterChildrenAction")).isEnabled()) {
            menuManager.add((IAction)this.browserActionMap.get("unfilterChildrenAction"));
        }
        menuManager.add((IAction)this.browserActionMap.get("openQuickSearch"));
        menuManager.add((IContributionItem)new Separator());
        MenuManager importMenuManager = new MenuManager(Messages.getString("BrowserViewActionGroup.Import"));
        importMenuManager.add((IAction)this.browserActionMap.get(importLdifAction));
        importMenuManager.add((IAction)this.browserActionMap.get(importDsmlAction));
        importMenuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)importMenuManager);
        MenuManager exportMenuManager = new MenuManager(Messages.getString("BrowserViewActionGroup.Export"));
        exportMenuManager.add((IAction)this.browserActionMap.get(exportLdifAction));
        exportMenuManager.add((IAction)this.browserActionMap.get(exportDsmlAction));
        exportMenuManager.add((IContributionItem)new Separator());
        exportMenuManager.add((IAction)this.browserActionMap.get(exportCsvAction));
        exportMenuManager.add((IAction)this.browserActionMap.get(exportExcelAction));
        exportMenuManager.add((IAction)this.browserActionMap.get(exportOdfAction));
        menuManager.add((IContributionItem)exportMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get("refreshAction"));
        MenuManager fetchMenuManager = new MenuManager(Messages.getString("BrowserViewActionGroup.Fetch"));
        if (((BrowserViewActionProxy)this.browserActionMap.get(fetchOperationalAttributesAction)).isEnabled()) {
            fetchMenuManager.add((IAction)this.browserActionMap.get(fetchOperationalAttributesAction));
        }
        if (((BrowserViewActionProxy)this.browserActionMap.get(fetchAliasesAction)).isEnabled()) {
            fetchMenuManager.add((IAction)this.browserActionMap.get(fetchAliasesAction));
        }
        if (((BrowserViewActionProxy)this.browserActionMap.get(fetchReferralsAction)).isEnabled()) {
            fetchMenuManager.add((IAction)this.browserActionMap.get(fetchReferralsAction));
        }
        if (((BrowserViewActionProxy)this.browserActionMap.get(fetchSubentriesAction)).isEnabled()) {
            fetchMenuManager.add((IAction)this.browserActionMap.get(fetchSubentriesAction));
        }
        menuManager.add((IContributionItem)fetchMenuManager);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)this.browserActionMap.get("propertyDialogAction"));
    }

    public void activateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.browserActionMap.get(copyAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.browserActionMap.get(pasteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.browserActionMap.get(deleteAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.browserActionMap.get(moveAction));
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.browserActionMap.get(renameAction));
        }
        super.activateGlobalActionHandlers();
        IAction leid = (IAction)this.browserActionMap.get(locateEntryInDitAction);
        ActionUtils.activateActionHandler((IAction)leid);
    }

    public void deactivateGlobalActionHandlers() {
        if (this.actionBars != null) {
            this.actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), null);
            this.actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), null);
        }
        super.deactivateGlobalActionHandlers();
        IAction leid = (IAction)this.browserActionMap.get(locateEntryInDitAction);
        ActionUtils.deactivateActionHandler((IAction)leid);
    }
}

