/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.core.model.ISearchResult;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class SearchResultEditorLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    private ValueEditorManager valueEditorManager;
    private ISearch search;
    private boolean showDn;

    public SearchResultEditorLabelProvider(ValueEditorManager valueEditorManager) {
        this.valueEditorManager = valueEditorManager;
    }

    public void inputChanged(ISearch newSearch, boolean showDn) {
        this.search = newSearch;
        this.showDn = showDn;
    }

    public final String getColumnText(Object obj, int index) {
        if (obj != null && obj instanceof ISearchResult) {
            try {
                ISearchResult result = (ISearchResult)obj;
                String property = this.showDn && index == 0 ? "Dn" : (this.showDn && index > 0 ? this.search.getReturningAttributes()[index - 1] : this.search.getReturningAttributes()[index]);
                if (property == "Dn") {
                    return result.getDn().getName();
                }
                AttributeHierarchy ah = result.getAttributeWithSubtypes(property);
                return this.getDisplayValue(ah);
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                return "";
            }
        }
        if (obj != null) {
            return obj.toString();
        }
        return "";
    }

    public final Image getColumnImage(Object obj, int index) {
        return null;
    }

    private String getDisplayValue(AttributeHierarchy ah) {
        IValueEditor vp = this.valueEditorManager.getCurrentValueEditor(ah);
        if (vp == null) {
            return "";
        }
        String value = vp.getDisplayValue(ah);
        if (value.length() > 50) {
            value = value.substring(0, 47) + "...";
        }
        return value;
    }

    public Font getFont(Object element, int index) {
        if (element instanceof ISearchResult) {
            int i;
            AttributeHierarchy ah;
            ISearchResult result = (ISearchResult)element;
            String property = null;
            if (this.showDn && index == 0) {
                property = "Dn";
            } else if (this.showDn && index > 0 && index - 1 < result.getSearch().getReturningAttributes().length) {
                property = result.getSearch().getReturningAttributes()[index - 1];
            } else if (index < result.getSearch().getReturningAttributes().length) {
                property = result.getSearch().getReturningAttributes()[index];
            }
            if (property != null && property == "Dn") {
                return null;
            }
            if (property != null && (ah = result.getAttributeWithSubtypes(property)) != null && (i = 0) < ah.getAttributes().length) {
                IAttribute attribute = ah.getAttributes()[i];
                if (attribute.isObjectClassAttribute()) {
                    FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"objectClassFont");
                    return BrowserCommonActivator.getDefault().getFont(fontData);
                }
                if (attribute.isMustAttribute()) {
                    FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mustAttributeFont");
                    return BrowserCommonActivator.getDefault().getFont(fontData);
                }
                if (attribute.isOperationalAttribute()) {
                    FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"operationalAttributeFont");
                    return BrowserCommonActivator.getDefault().getFont(fontData);
                }
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mayAttributeFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
        }
        return null;
    }

    public Color getForeground(Object element, int index) {
        return null;
    }

    public Color getBackground(Object element, int index) {
        return null;
    }
}

