/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.editors.searchresult;

import org.apache.directory.studio.ldapbrowser.core.model.ISearch;
import org.apache.directory.studio.ldapbrowser.ui.BrowserUIPlugin;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.Messages;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorConfiguration;
import org.apache.directory.studio.ldapbrowser.ui.editors.searchresult.SearchResultEditorWidget;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;

public class SearchResultEditorContentProvider
implements ILazyContentProvider {
    private SearchResultEditorWidget mainWidget;
    private SearchResultEditorConfiguration configuration;
    private Object input;
    private Object[] elements;
    private Object[] filteredAndSortedElements;

    public SearchResultEditorContentProvider(SearchResultEditorWidget mainWidget, SearchResultEditorConfiguration configuration) {
        this.mainWidget = mainWidget;
        this.configuration = configuration;
        this.configuration.getFilter().connect(this);
        this.configuration.getSorter().connect(this);
    }

    public void dispose() {
        this.mainWidget = null;
        this.configuration = null;
        this.elements = null;
        this.filteredAndSortedElements = null;
    }

    public void refresh() {
        this.filterAndSort();
        this.mainWidget.getViewer().refresh();
    }

    private void filterAndSort() {
        this.filteredAndSortedElements = this.elements;
        if ((this.configuration.getFilter().isFiltered() || this.configuration.getSorter().isSorted()) && (this.elements.length <= 1000 || this.mainWidget.getViewer() == null || this.mainWidget.getViewer().getTable().isDisposed()) && this.elements.length > 0 && this.mainWidget.getViewer() != null && !this.mainWidget.getViewer().getTable().isDisposed()) {
            this.filteredAndSortedElements = this.configuration.getFilter().filter((Viewer)this.mainWidget.getViewer(), "", this.elements);
            this.configuration.getSorter().sort((Viewer)this.mainWidget.getViewer(), this.filteredAndSortedElements);
        }
        this.mainWidget.getViewer().setItemCount(this.filteredAndSortedElements.length);
        String url = "";
        boolean enabled = true;
        if (this.input != null && this.input instanceof ISearch) {
            ISearch search = (ISearch)this.input;
            if (this.filteredAndSortedElements.length < this.elements.length) {
                url = url + this.filteredAndSortedElements.length + Messages.getString("SearchResultEditorContentProvider.Of");
            }
            if (search.getSearchResults() == null) {
                url = url + Messages.getString("SearchResultEditorContentProvider.SearchNotPerformed");
                enabled = false;
            } else {
                url = search.getSearchResults().length == 1 ? url + search.getSearchResults().length + Messages.getString("SearchResultEditorContentProvider.Result") : url + search.getSearchResults().length + Messages.getString("SearchResultEditorContentProvider.Results");
            }
            url = url + Messages.getString("SearchResultEditorContentProvider.SearchBase") + search.getSearchBase().getName() + "  -  ";
            url = url + Messages.getString("SearchResultEditorContentProvider.Filter") + search.getFilter();
            boolean showDn = BrowserUIPlugin.getDefault().getPreferenceStore().getBoolean("searchResultEditorShowDn") || search.getReturningAttributes().length == 0;
            this.configuration.getFilter().inputChanged(search, showDn);
            this.configuration.getSorter().inputChanged(search, showDn);
        } else {
            url = Messages.getString("SearchResultEditorContentProvider.NoSearchSelected");
            enabled = false;
        }
        if (this.mainWidget.getInfoText() != null && !this.mainWidget.getInfoText().isDisposed()) {
            this.mainWidget.getInfoText().setText(url);
        }
        if (this.mainWidget.getQuickFilterWidget() != null) {
            this.mainWidget.getQuickFilterWidget().setEnabled(enabled);
        }
        if (this.mainWidget.getViewer() != null && !this.mainWidget.getViewer().getTable().isDisposed()) {
            this.mainWidget.getViewer().getTable().setEnabled(enabled);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = newInput;
        this.elements = this.getElements(newInput);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement != null && inputElement instanceof ISearch) {
            ISearch search = (ISearch)inputElement;
            return search.getSearchResults() != null ? search.getSearchResults() : new Object[]{};
        }
        return new Object[0];
    }

    public TableViewer getViewer() {
        return this.mainWidget.getViewer();
    }

    public void updateElement(int index) {
        if (this.filteredAndSortedElements != null && this.filteredAndSortedElements.length > 0 && index < this.filteredAndSortedElements.length) {
            this.mainWidget.getViewer().replace(this.filteredAndSortedElements[index], index);
        }
    }
}

