/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v156.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.editor.v156.dialogs.Messages;
import org.apache.directory.studio.apacheds.configuration.model.v156.InterceptorEnum;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.PlatformUI;

public class InterceptorDialog
extends Dialog {
    private List<InterceptorEnum> initialInterceptors;
    private List<InterceptorEnum> availableInterceptors;
    private InterceptorEnum selectedInterceptor;
    private Table interceptorsTable;
    private TableViewer interceptorsTableViewer;
    private Button addButton;

    public InterceptorDialog(List<InterceptorEnum> interceptors) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.initialInterceptors = interceptors;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.getString("InterceptorDialog.AddAnInterceptor"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label chooseLabel = new Label(composite, 0);
        chooseLabel.setText(Messages.getString("InterceptorDialog.ChooseAnInterceptor"));
        chooseLabel.setLayoutData((Object)new GridData(4, 0, true, false));
        this.interceptorsTable = new Table(composite, 101124);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 148;
        gridData.minimumHeight = 148;
        gridData.widthHint = 350;
        gridData.minimumWidth = 350;
        this.interceptorsTable.setLayoutData((Object)gridData);
        this.interceptorsTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (InterceptorDialog.this.interceptorsTable.getSelectionIndex() != -1) {
                    InterceptorDialog.this.okPressed();
                }
            }
        });
        this.interceptorsTableViewer = new TableViewer(this.interceptorsTable);
        this.interceptorsTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.interceptorsTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return ApacheDSConfigurationPlugin.getDefault().getImage("resources/icons/interceptor.gif");
            }

            public String getText(Object element) {
                if (element instanceof InterceptorEnum) {
                    return ((InterceptorEnum)((Object)element)).getName();
                }
                return super.getText(element);
            }
        });
        this.interceptorsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)InterceptorDialog.this.interceptorsTableViewer.getSelection();
                if (selection.isEmpty()) {
                    if (InterceptorDialog.this.addButton != null && !InterceptorDialog.this.addButton.isDisposed()) {
                        InterceptorDialog.this.addButton.setEnabled(false);
                    }
                } else if (InterceptorDialog.this.addButton != null && !InterceptorDialog.this.addButton.isDisposed()) {
                    InterceptorDialog.this.addButton.setEnabled(true);
                }
            }
        });
        this.initFromInput();
        return composite;
    }

    private void initFromInput() {
        this.availableInterceptors = new ArrayList<InterceptorEnum>();
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.NORMALIZATION)) {
            this.availableInterceptors.add(InterceptorEnum.NORMALIZATION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.AUTHENTICATION)) {
            this.availableInterceptors.add(InterceptorEnum.AUTHENTICATION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.ACI_AUTHORIZATION)) {
            this.availableInterceptors.add(InterceptorEnum.ACI_AUTHORIZATION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.DEFAULT_AUTHORIZATION)) {
            this.availableInterceptors.add(InterceptorEnum.DEFAULT_AUTHORIZATION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.EXCEPTION)) {
            this.availableInterceptors.add(InterceptorEnum.EXCEPTION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.OPERATIONAL_ATTRIBUTE)) {
            this.availableInterceptors.add(InterceptorEnum.OPERATIONAL_ATTRIBUTE);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.KEY_DERIVATION)) {
            this.availableInterceptors.add(InterceptorEnum.KEY_DERIVATION);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.SCHEMA)) {
            this.availableInterceptors.add(InterceptorEnum.SCHEMA);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.SUBENTRY)) {
            this.availableInterceptors.add(InterceptorEnum.SUBENTRY);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.COLLECTIVE_ATTRIBUTE)) {
            this.availableInterceptors.add(InterceptorEnum.COLLECTIVE_ATTRIBUTE);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.EVENT)) {
            this.availableInterceptors.add(InterceptorEnum.EVENT);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.TRIGGER)) {
            this.availableInterceptors.add(InterceptorEnum.TRIGGER);
        }
        if (!this.initialInterceptors.contains((Object)InterceptorEnum.REPLICATION)) {
            this.availableInterceptors.add(InterceptorEnum.REPLICATION);
        }
        this.interceptorsTableViewer.setInput(this.availableInterceptors);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.addButton = this.createButton(parent, 0, "Add", true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.addButton.setEnabled(false);
    }

    protected void okPressed() {
        StructuredSelection selection = (StructuredSelection)this.interceptorsTableViewer.getSelection();
        if (!selection.isEmpty()) {
            this.selectedInterceptor = (InterceptorEnum)((Object)selection.getFirstElement());
        }
        super.okPressed();
    }

    public InterceptorEnum getInterceptor() {
        return this.selectedInterceptor;
    }
}

