/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor.v151.dialogs;

import org.apache.directory.studio.apacheds.configuration.editor.v151.dialogs.AttributeValueObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class AttributeValueDialog
extends Dialog {
    private AttributeValueObject attributeValueObject;
    private boolean dirty = false;
    private Text attributeText;
    private Text valueText;

    public AttributeValueDialog(AttributeValueObject attributeValueObject) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        this.attributeValueObject = attributeValueObject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Attribute Value Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label attributeLabel = new Label(composite, 0);
        attributeLabel.setText("Attribute:");
        this.attributeText = new Text(composite, 2048);
        this.attributeText.setLayoutData((Object)new GridData(4, 0, true, false));
        Label valueLabel = new Label(composite, 0);
        valueLabel.setText("Value:");
        this.valueText = new Text(composite, 2048);
        this.valueText.setLayoutData((Object)new GridData(4, 0, true, false));
        this.initFromInput();
        this.addListeners();
        return composite;
    }

    private void initFromInput() {
        String attribute = this.attributeValueObject.getAttribute();
        this.attributeText.setText(attribute == null ? "" : attribute);
        String value = this.attributeValueObject.getValue();
        this.valueText.setText(value == null ? "" : value.toString());
    }

    private void addListeners() {
        this.attributeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeValueDialog.this.dirty = true;
            }
        });
        this.valueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AttributeValueDialog.this.dirty = true;
            }
        });
    }

    protected void okPressed() {
        this.attributeValueObject.setId(this.attributeText.getText());
        this.attributeValueObject.setValue(this.valueText.getText());
        super.okPressed();
    }

    public AttributeValueObject getAttributeValueObject() {
        return this.attributeValueObject;
    }

    public boolean isDirty() {
        return this.dirty;
    }
}

