/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.apacheds.configuration.editor;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPlugin;
import org.apache.directory.studio.apacheds.configuration.ApacheDSConfigurationPluginConstants;
import org.apache.directory.studio.apacheds.configuration.editor.ErrorPage;
import org.apache.directory.studio.apacheds.configuration.editor.Messages;
import org.apache.directory.studio.apacheds.configuration.editor.NonExistingServerConfigurationInput;
import org.apache.directory.studio.apacheds.configuration.editor.v150.InterceptorsPage;
import org.apache.directory.studio.apacheds.configuration.editor.v151.ExtendedOperationsPage;
import org.apache.directory.studio.apacheds.configuration.editor.v153.AuthenticationPage;
import org.apache.directory.studio.apacheds.configuration.editor.v154.PartitionsPage;
import org.apache.directory.studio.apacheds.configuration.editor.v157.GeneralPage;
import org.apache.directory.studio.apacheds.configuration.model.ServerConfiguration;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIO;
import org.apache.directory.studio.apacheds.configuration.model.ServerXmlIOException;
import org.apache.directory.studio.apacheds.configuration.model.v150.ServerXmlIOV150;
import org.apache.directory.studio.apacheds.configuration.model.v151.ServerXmlIOV151;
import org.apache.directory.studio.apacheds.configuration.model.v152.ServerXmlIOV152;
import org.apache.directory.studio.apacheds.configuration.model.v153.ServerXmlIOV153;
import org.apache.directory.studio.apacheds.configuration.model.v154.ServerXmlIOV154;
import org.apache.directory.studio.apacheds.configuration.model.v155.ServerXmlIOV155;
import org.apache.directory.studio.apacheds.configuration.model.v156.ServerXmlIOV156;
import org.apache.directory.studio.apacheds.configuration.model.v157.ServerXmlIOV157;
import org.apache.directory.studio.common.ui.CommonUIUtils;
import org.apache.directory.studio.common.ui.filesystem.PathEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class ServerConfigurationEditor
extends FormEditor {
    public static final String ID = ApacheDSConfigurationPluginConstants.EDITOR_SERVER_CONFIGURATION_EDITOR;
    private ServerConfiguration serverConfiguration;
    private ServerXmlIO serverXmlIO;
    private boolean dirty = false;
    private String errorMessage;
    private FormPage generalPage;
    private FormPage authenticationPage;
    private FormPage partitionsPage;
    private FormPage interceptorsPage;
    private FormPage extendedOperationsPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setPartName(input.getName());
        try {
            this.readServerConfiguration(input);
        }
        catch (Exception e) {
            this.errorMessage = e.getMessage();
        }
    }

    private void readServerConfiguration(IEditorInput input) throws CoreException, FileNotFoundException, ServerXmlIOException {
        ServerXmlIO[] serverXmlIOs;
        if (input instanceof NonExistingServerConfigurationInput) {
            this.serverConfiguration = ((NonExistingServerConfigurationInput)input).getServerConfiguration();
            this.dirty = true;
            switch (this.serverConfiguration.getVersion()) {
                case VERSION_1_5_7: {
                    this.serverXmlIO = new ServerXmlIOV157();
                    break;
                }
                case VERSION_1_5_6: {
                    this.serverXmlIO = new ServerXmlIOV156();
                    break;
                }
                case VERSION_1_5_5: {
                    this.serverXmlIO = new ServerXmlIOV155();
                    break;
                }
                case VERSION_1_5_4: {
                    this.serverXmlIO = new ServerXmlIOV154();
                    break;
                }
                case VERSION_1_5_3: {
                    this.serverXmlIO = new ServerXmlIOV153();
                    break;
                }
                case VERSION_1_5_2: {
                    this.serverXmlIO = new ServerXmlIOV152();
                    break;
                }
                case VERSION_1_5_1: {
                    this.serverXmlIO = new ServerXmlIOV151();
                    break;
                }
                case VERSION_1_5_0: {
                    this.serverXmlIO = new ServerXmlIOV150();
                }
            }
            return;
        }
        for (ServerXmlIO validationServerXmlIO : serverXmlIOs = ApacheDSConfigurationPlugin.getDefault().getServerXmlIOs()) {
            if (!validationServerXmlIO.isValid(this.getInputStream(input))) continue;
            this.serverXmlIO = validationServerXmlIO;
            this.serverConfiguration = this.serverXmlIO.parse(this.getInputStream(input));
            return;
        }
    }

    private InputStream getInputStream(IEditorInput input) throws CoreException, FileNotFoundException {
        String inputClassName = input.getClass().getName();
        if (input instanceof FileEditorInput) {
            return ((FileEditorInput)input).getFile().getContents();
        }
        if (input instanceof IPathEditorInput) {
            return new FileInputStream(new File(((IPathEditorInput)input).getPath().toOSString()));
        }
        if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
            return new FileInputStream(new File(input.getToolTipText()));
        }
        return null;
    }

    protected void addPages() {
        try {
            if (this.serverConfiguration == null) {
                ErrorPage errorPage = new ErrorPage(this);
                this.addPage((IFormPage)errorPage);
            } else {
                switch (this.serverConfiguration.getVersion()) {
                    case VERSION_1_5_7: {
                        this.generalPage = new GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new org.apache.directory.studio.apacheds.configuration.editor.v157.AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v157.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v157.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v157.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_6: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v156.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new org.apache.directory.studio.apacheds.configuration.editor.v156.AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v156.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v156.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v156.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_5: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v155.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new org.apache.directory.studio.apacheds.configuration.editor.v155.AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v155.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v155.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v155.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_4: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v154.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new org.apache.directory.studio.apacheds.configuration.editor.v154.AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v154.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v154.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_3: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v153.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v153.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v153.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v153.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_2: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v152.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.authenticationPage = new org.apache.directory.studio.apacheds.configuration.editor.v152.AuthenticationPage(this);
                        this.addPage((IFormPage)this.authenticationPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v152.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v152.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v152.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_1: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v151.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v151.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new org.apache.directory.studio.apacheds.configuration.editor.v151.InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                        break;
                    }
                    case VERSION_1_5_0: {
                        this.generalPage = new org.apache.directory.studio.apacheds.configuration.editor.v150.GeneralPage(this);
                        this.addPage((IFormPage)this.generalPage);
                        this.partitionsPage = new org.apache.directory.studio.apacheds.configuration.editor.v150.PartitionsPage(this);
                        this.addPage((IFormPage)this.partitionsPage);
                        this.interceptorsPage = new InterceptorsPage(this);
                        this.addPage((IFormPage)this.interceptorsPage);
                        this.extendedOperationsPage = new org.apache.directory.studio.apacheds.configuration.editor.v150.ExtendedOperationsPage(this);
                        this.addPage((IFormPage)this.extendedOperationsPage);
                    }
                }
            }
        }
        catch (PartInitException e) {
            ApacheDSConfigurationPlugin.getDefault().getLog().log((IStatus)new Status(4, ApacheDSConfigurationPluginConstants.PLUGIN_ID, 0, e.getMessage(), e.getCause()));
        }
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask(Messages.getString("ServerConfigurationEditor.SavingTheServerConfiguration"), -1);
        this.saveEditorPages(monitor);
        try {
            IEditorInput input = this.getEditorInput();
            String inputClassName = input.getClass().getName();
            boolean success = false;
            if (input instanceof FileEditorInput) {
                this.saveConfiguration((FileEditorInput)input, monitor);
                success = true;
            } else if (input instanceof IPathEditorInput) {
                this.saveConfiguration(((IPathEditorInput)input).getPath().toOSString());
                success = true;
            } else if (inputClassName.equals("org.eclipse.ui.internal.editors.text.JavaFileEditorInput") || inputClassName.equals("org.eclipse.ui.ide.FileStoreEditorInput")) {
                this.saveConfiguration(input.getToolTipText());
                success = true;
            } else if (input instanceof NonExistingServerConfigurationInput) {
                success = this.doSaveAs(monitor);
            }
            this.setDirty(!success);
            monitor.done();
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ServerConfigurationEditor.Error"), (String)(Messages.getString("ServerConfigurationEditor.AnErrorOccurredWhenWritingTheFileToDisk") + "\n" + e.getMessage()));
            this.setDirty(true);
            monitor.done();
            return;
        }
    }

    private void saveEditorPages(IProgressMonitor monitor) {
        if (this.serverConfiguration != null) {
            switch (this.serverConfiguration.getVersion()) {
                case VERSION_1_5_7: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_6: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_5: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_4: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_3: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_2: {
                    this.generalPage.doSave(monitor);
                    this.authenticationPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_1: {
                    this.generalPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                    break;
                }
                case VERSION_1_5_0: {
                    this.generalPage.doSave(monitor);
                    this.partitionsPage.doSave(monitor);
                    this.interceptorsPage.doSave(monitor);
                    this.extendedOperationsPage.doSave(monitor);
                }
            }
        }
    }

    private void saveConfiguration(String path) throws IOException {
        BufferedWriter outFile = new BufferedWriter(new FileWriter(path));
        String xml = this.serverXmlIO.toXml(this.serverConfiguration);
        outFile.write(xml);
        outFile.close();
    }

    private void saveConfiguration(FileEditorInput fei, IProgressMonitor monitor) throws CoreException, IOException {
        String xml = this.serverXmlIO.toXml(this.serverConfiguration);
        fei.getFile().setContents((InputStream)new ByteArrayInputStream(xml.getBytes()), true, true, monitor);
    }

    public void doSaveAs() {
        try {
            this.getSite().getWorkbenchWindow().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask(Messages.getString("ServerConfigurationEditor.SavingTheServerConfiguration"), -1);
                        ServerConfigurationEditor.this.saveEditorPages(monitor);
                        boolean success = ServerConfigurationEditor.this.doSaveAs(monitor);
                        ServerConfigurationEditor.this.setDirty(!success);
                        monitor.done();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ServerConfigurationEditor.Error"), (String)(Messages.getString("ServerConfigurationEditor.AnErrorOccurredWhenWritingTheFileToDisk") + "\n" + e.getMessage()));
                        ServerConfigurationEditor.this.setDirty(true);
                        monitor.done();
                        return;
                    }
                }
            });
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.getString("ServerConfigurationEditor.Error"), (String)(Messages.getString("ServerConfigurationEditor.AnErrorOccurredWhenWritingTheFileToDisk") + "\n" + e.getMessage()));
            return;
        }
    }

    private boolean doSaveAs(IProgressMonitor monitor) throws Exception {
        boolean isIDE = CommonUIUtils.isIDEEnvironment();
        if (isIDE) {
            SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
            if (!(this.getEditorInput() instanceof NonExistingServerConfigurationInput)) {
                dialog.setOriginalFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(this.getEditorInput().getToolTipText())));
            }
            if (dialog.open() != 0) {
                return false;
            }
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dialog.getResult());
            if (!file.exists()) {
                file.create((InputStream)new ByteArrayInputStream("".getBytes()), true, null);
            }
            FileEditorInput fei = new FileEditorInput(file);
            this.saveEditorPages(monitor);
            this.saveConfiguration(fei, monitor);
            this.setInput((IEditorInput)fei);
        } else {
            Shell shell = this.getSite().getShell();
            boolean canOverwrite = false;
            String path = null;
            while (!canOverwrite) {
                FileDialog dialog = new FileDialog(shell, 8192);
                path = dialog.open();
                if (path == null) {
                    return false;
                }
                File externalFile = new File(path);
                if (externalFile.exists()) {
                    String question = NLS.bind((String)Messages.getString("ServerConfigurationEditor.TheFileAlreadyExistsReplace"), (Object)path);
                    MessageDialog overwriteDialog = new MessageDialog(shell, Messages.getString("ServerConfigurationEditor.Question"), null, question, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                    int overwrite = overwriteDialog.open();
                    switch (overwrite) {
                        case 0: {
                            canOverwrite = true;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    continue;
                }
                canOverwrite = true;
            }
            this.saveEditorPages(monitor);
            this.saveConfiguration(path);
            PathEditorInput newInput = new PathEditorInput((IPath)new Path(path));
            this.setInput((IEditorInput)newInput);
        }
        this.setPartName(this.getEditorInput().getName());
        return true;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.editorDirtyStateChanged();
    }

    public ServerConfiguration getServerConfiguration() {
        return this.serverConfiguration;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

