/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.widgets;

import org.apache.commons.lang.StringUtils;
import org.apache.directory.api.ldap.model.constants.SaslQoP;
import org.apache.directory.api.ldap.model.constants.SaslSecurityStrength;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.studio.common.ui.HistoryUtils;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.PasswordsKeyStoreManager;
import org.apache.directory.studio.connection.core.jobs.CheckBindRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.AbstractConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.PasswordsKeyStoreManagerUtils;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.connection.ui.widgets.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;

public class AuthenticationParameterPage
extends AbstractConnectionParameterPage {
    private static final String X_AUTH_METHOD = "X-AUTH-METHOD";
    private static final String X_AUTH_METHOD_ANONYMOUS = "Anonymous";
    private static final String X_AUTH_METHOD_SIMPLE = "Simple";
    private static final String X_AUTH_METHOD_DIGEST_MD5 = "DIGEST-MD5";
    private static final String X_AUTH_METHOD_CRAM_MD5 = "CRAM-MD5";
    private static final String X_AUTH_METHOD_GSSAPI = "GSSAPI";
    private static final String X_BIND_USER = "X-BIND-USER";
    private static final String X_BIND_PASSWORD = "X-BIND-PASSWORD";
    private static final String X_SASL_REALM = "X-SASL-REALM";
    private static final String X_SASL_QOP = "X-SASL-QOP";
    private static final String X_SASL_QOP_AUTH_INT = "AUTH-INT";
    private static final String X_SASL_QOP_AUTH_INT_PRIV = "AUTH-INT-PRIV";
    private static final String X_SASL_SEC_STRENGTH = "X-SASL-SEC-STRENGTH";
    private static final String X_SASL_SEC_STRENGTH_MEDIUM = "MEDIUM";
    private static final String X_SASL_SEC_STRENGTH_LOW = "LOW";
    private static final String X_SASL_NO_MUTUAL_AUTH = "X-SASL-NO-MUTUAL-AUTH";
    private static final String X_KRB5_CREDENTIALS_CONF = "X-KRB5-CREDENTIALS-CONF";
    private static final String X_KRB5_CREDENTIALS_CONF_OBTAIN_TGT = "OBTAIN-TGT";
    private static final String X_KRB5_CONFIG = "X-KRB5-CONFIG";
    private static final String X_KRB5_CONFIG_FILE = "FILE";
    private static final String X_KRB5_CONFIG_FILE_FILE = "X-KRB5-CONFIG-FILE";
    private static final String X_KRB5_CONFIG_MANUAL = "MANUAL";
    private static final String X_KRB5_CONFIG_MANUAL_REALM = "X-KRB5-REALM";
    private static final String X_KRB5_CONFIG_MANUAL_KDC_HOST = "X-KRB5-KDC-HOST";
    private static final String X_KRB5_CONFIG_MANUAL_KDC_PORT = "X-KRB5-KDC-PORT";
    private Combo authenticationMethodCombo;
    private Combo bindPrincipalCombo;
    private Text bindPasswordText;
    private Button saveBindPasswordButton;
    private Button checkPrincipalPasswordAuthButton;
    private ExpandableComposite saslExpandableComposite;
    private Composite saslComposite;
    private Combo saslRealmText;
    private Combo saslQopCombo;
    private Combo saslSecurityStrengthCombo;
    private Button saslMutualAuthenticationButton;
    private ExpandableComposite krb5ExpandableComposite;
    private Composite krb5Composite;
    private Button krb5CredentialConfigurationUseNativeButton;
    private Button krb5CredentialConfigurationObtainTgtButton;
    private Button krb5ConfigDefaultButton;
    private Button krb5ConfigFileButton;
    private Text krb5ConfigFileText;
    private Button krb5ConfigManualButton;
    private Text krb5ConfigManualRealmText;
    private Text krb5ConfigManualHostText;
    private Text krb5ConfigManualPortText;

    private ConnectionParameter.AuthenticationMethod getAuthenticationMethod() {
        switch (this.authenticationMethodCombo.getSelectionIndex()) {
            case 1: {
                return ConnectionParameter.AuthenticationMethod.SIMPLE;
            }
            case 2: {
                return ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5;
            }
            case 3: {
                return ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5;
            }
            case 4: {
                return ConnectionParameter.AuthenticationMethod.SASL_GSSAPI;
            }
        }
        return ConnectionParameter.AuthenticationMethod.NONE;
    }

    private String getBindPrincipal() {
        return this.bindPrincipalCombo.getText();
    }

    private String getBindPassword() {
        return this.isSaveBindPassword() ? this.bindPasswordText.getText() : null;
    }

    private String getSaslRealm() {
        return this.saslRealmText.getText();
    }

    private SaslQoP getSaslQop() {
        switch (this.saslQopCombo.getSelectionIndex()) {
            case 1: {
                return SaslQoP.AUTH_INT;
            }
            case 2: {
                return SaslQoP.AUTH_CONF;
            }
        }
        return SaslQoP.AUTH;
    }

    private SaslSecurityStrength getSaslSecurityStrength() {
        switch (this.saslSecurityStrengthCombo.getSelectionIndex()) {
            case 1: {
                return SaslSecurityStrength.MEDIUM;
            }
            case 2: {
                return SaslSecurityStrength.LOW;
            }
        }
        return SaslSecurityStrength.HIGH;
    }

    private ConnectionParameter.Krb5CredentialConfiguration getKrb5CredentialProvider() {
        if (this.krb5CredentialConfigurationUseNativeButton.getSelection()) {
            return ConnectionParameter.Krb5CredentialConfiguration.USE_NATIVE;
        }
        return ConnectionParameter.Krb5CredentialConfiguration.OBTAIN_TGT;
    }

    private ConnectionParameter.Krb5Configuration getKrb5Configuration() {
        if (this.krb5ConfigDefaultButton.getSelection()) {
            return ConnectionParameter.Krb5Configuration.DEFAULT;
        }
        if (this.krb5ConfigFileButton.getSelection()) {
            return ConnectionParameter.Krb5Configuration.FILE;
        }
        return ConnectionParameter.Krb5Configuration.MANUAL;
    }

    private int getKdcPort() {
        return !"".equals(this.krb5ConfigManualPortText.getText()) ? Integer.parseInt(this.krb5ConfigManualPortText.getText()) : 0;
    }

    public boolean isSaveBindPassword() {
        return this.saveBindPasswordButton.getSelection();
    }

    private Connection getTestConnection() {
        ConnectionParameter cp = this.connectionParameterPageModifyListener.getTestConnectionParameters();
        Connection conn = new Connection(cp);
        return conn;
    }

    @Override
    protected void createComposite(Composite parent) {
        Composite composite1 = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group1 = BaseWidgetUtils.createGroup((Composite)composite1, (String)Messages.getString("AuthenticationParameterPage.AuthenticationMethod"), (int)1);
        Composite groupComposite = BaseWidgetUtils.createColumnContainer((Composite)group1, (int)1, (int)1);
        String[] authMethods = new String[]{Messages.getString("AuthenticationParameterPage.AnonymousAuthentication"), Messages.getString("AuthenticationParameterPage.SimpleAuthentication"), Messages.getString("AuthenticationParameterPage.DigestMD5"), Messages.getString("AuthenticationParameterPage.CramMD5"), Messages.getString("AuthenticationParameterPage.GSSAPI")};
        this.authenticationMethodCombo = BaseWidgetUtils.createReadonlyCombo((Composite)groupComposite, (String[])authMethods, (int)1, (int)2);
        Composite composite2 = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Group group2 = BaseWidgetUtils.createGroup((Composite)composite2, (String)Messages.getString("AuthenticationParameterPage.AuthenticationParameter"), (int)1);
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)group2, (int)3, (int)1);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("AuthenticationParameterPage.BindDNOrUser"), (int)1);
        String[] dnHistory = HistoryUtils.load((IDialogSettings)ConnectionUIPlugin.getDefault().getDialogSettings(), (String)"principalHistory");
        this.bindPrincipalCombo = BaseWidgetUtils.createCombo((Composite)composite, (String[])dnHistory, (int)-1, (int)2);
        BaseWidgetUtils.createLabel((Composite)composite, (String)Messages.getString("AuthenticationParameterPage.BindPassword"), (int)1);
        this.bindPasswordText = BaseWidgetUtils.createPasswordText((Composite)composite, (String)"", (int)2);
        BaseWidgetUtils.createSpacer((Composite)composite, (int)1);
        this.saveBindPasswordButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("AuthenticationParameterPage.SavePassword"), (int)1);
        this.saveBindPasswordButton.setSelection(true);
        this.checkPrincipalPasswordAuthButton = new Button(composite, 8);
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        this.checkPrincipalPasswordAuthButton.setLayoutData((Object)gd);
        this.checkPrincipalPasswordAuthButton.setText(Messages.getString("AuthenticationParameterPage.CheckAuthentication"));
        this.checkPrincipalPasswordAuthButton.setEnabled(false);
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setLayout((Layout)new GridLayout());
        sc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite c = BaseWidgetUtils.createColumnContainer((Composite)sc, (int)1, (int)1);
        sc.setContent((Control)c);
        this.saslExpandableComposite = this.createExpandableSection(c, Messages.getString("AuthenticationParameterPage.SaslOptions"), 1);
        this.saslComposite = BaseWidgetUtils.createColumnContainer((Composite)this.saslExpandableComposite, (int)2, (int)1);
        this.saslExpandableComposite.setClient((Control)this.saslComposite);
        this.createSaslControls();
        this.krb5ExpandableComposite = this.createExpandableSection(c, Messages.getString("AuthenticationParameterPage.Krb5Options"), 1);
        this.krb5Composite = BaseWidgetUtils.createColumnContainer((Composite)this.krb5ExpandableComposite, (int)1, (int)1);
        this.krb5ExpandableComposite.setClient((Control)this.krb5Composite);
        this.createKrb5Controls();
        c.setSize(c.computeSize(-1, -1));
    }

    protected ExpandableComposite createExpandableSection(Composite parent, String label, int nColumns) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 18);
        excomposite.setText(label);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, nColumns, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                ExpandableComposite excomposite = (ExpandableComposite)e.getSource();
                excomposite.getParent().setSize(excomposite.getParent().computeSize(-1, -1));
            }
        });
        return excomposite;
    }

    private void createSaslControls() {
        BaseWidgetUtils.createLabel((Composite)this.saslComposite, (String)Messages.getString("AuthenticationParameterPage.SaslRealm"), (int)1);
        String[] saslHistory = HistoryUtils.load((IDialogSettings)ConnectionUIPlugin.getDefault().getDialogSettings(), (String)"saslrealmHistory");
        this.saslRealmText = BaseWidgetUtils.createCombo((Composite)this.saslComposite, (String[])saslHistory, (int)-1, (int)1);
        BaseWidgetUtils.createLabel((Composite)this.saslComposite, (String)Messages.getString("AuthenticationParameterPage.SaslQop"), (int)1);
        String[] qops = new String[]{Messages.getString("AuthenticationParameterPage.SaslQopAuth"), Messages.getString("AuthenticationParameterPage.SaslQopAuthInt"), Messages.getString("AuthenticationParameterPage.SaslQopAuthIntPriv")};
        this.saslQopCombo = BaseWidgetUtils.createReadonlyCombo((Composite)this.saslComposite, (String[])qops, (int)0, (int)1);
        BaseWidgetUtils.createLabel((Composite)this.saslComposite, (String)Messages.getString("AuthenticationParameterPage.SaslSecurityStrength"), (int)1);
        String[] securityStrengths = new String[]{Messages.getString("AuthenticationParameterPage.SaslSecurityStrengthHigh"), Messages.getString("AuthenticationParameterPage.SaslSecurityStrengthMedium"), Messages.getString("AuthenticationParameterPage.SaslSecurityStrengthLow")};
        this.saslSecurityStrengthCombo = BaseWidgetUtils.createReadonlyCombo((Composite)this.saslComposite, (String[])securityStrengths, (int)0, (int)1);
        this.saslMutualAuthenticationButton = BaseWidgetUtils.createCheckbox((Composite)this.saslComposite, (String)Messages.getString("AuthenticationParameterPage.SaslMutualAuthentication"), (int)2);
    }

    private void createKrb5Controls() {
        Group credentialProviderGroup = BaseWidgetUtils.createGroup((Composite)this.krb5Composite, (String)Messages.getString("AuthenticationParameterPage.Krb5CredentialConf"), (int)1);
        Composite credentialProviderComposite = BaseWidgetUtils.createColumnContainer((Composite)credentialProviderGroup, (int)1, (int)1);
        this.krb5CredentialConfigurationUseNativeButton = BaseWidgetUtils.createRadiobutton((Composite)credentialProviderComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5CredentialConfUseNative"), (int)1);
        this.krb5CredentialConfigurationUseNativeButton.setToolTipText(Messages.getString("AuthenticationParameterPage.Krb5CredentialConfUseNativeTooltip"));
        this.krb5CredentialConfigurationUseNativeButton.setSelection(true);
        this.krb5CredentialConfigurationObtainTgtButton = BaseWidgetUtils.createRadiobutton((Composite)credentialProviderComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5CredentialConfObtainTgt"), (int)1);
        this.krb5CredentialConfigurationObtainTgtButton.setToolTipText(Messages.getString("AuthenticationParameterPage.Krb5CredentialConfObtainTgtTooltip"));
        Group configGroup = BaseWidgetUtils.createGroup((Composite)this.krb5Composite, (String)Messages.getString("AuthenticationParameterPage.Krb5Config"), (int)1);
        Composite configComposite = BaseWidgetUtils.createColumnContainer((Composite)configGroup, (int)3, (int)1);
        this.krb5ConfigDefaultButton = BaseWidgetUtils.createRadiobutton((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5ConfigDefault"), (int)3);
        this.krb5ConfigDefaultButton.setSelection(true);
        this.krb5ConfigFileButton = BaseWidgetUtils.createRadiobutton((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5ConfigFile"), (int)1);
        this.krb5ConfigFileText = BaseWidgetUtils.createText((Composite)configComposite, (String)"", (int)2);
        this.krb5ConfigManualButton = BaseWidgetUtils.createRadiobutton((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5ConfigManual"), (int)1);
        BaseWidgetUtils.createLabel((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5Realm"), (int)1);
        this.krb5ConfigManualRealmText = BaseWidgetUtils.createText((Composite)configComposite, (String)"", (int)1);
        BaseWidgetUtils.createSpacer((Composite)configComposite, (int)1);
        BaseWidgetUtils.createLabel((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5KdcHost"), (int)1);
        this.krb5ConfigManualHostText = BaseWidgetUtils.createText((Composite)configComposite, (String)"", (int)1);
        BaseWidgetUtils.createSpacer((Composite)configComposite, (int)1);
        BaseWidgetUtils.createLabel((Composite)configComposite, (String)Messages.getString("AuthenticationParameterPage.Krb5KdcPort"), (int)1);
        this.krb5ConfigManualPortText = BaseWidgetUtils.createText((Composite)configComposite, (String)"88", (int)1);
        this.krb5ConfigManualPortText.setTextLimit(5);
    }

    @Override
    protected void validate() {
        if (this.saslComposite != null) {
            for (Control c : this.saslComposite.getChildren()) {
                c.setEnabled(this.isSaslEnabled());
            }
            this.saslRealmText.setEnabled(this.isSaslRealmTextEnabled());
        }
        Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
        boolean useKrb5SystemProperties = preferences.getBoolean("useKrb5SystemProperties");
        if (this.krb5Composite != null) {
            this.krb5CredentialConfigurationUseNativeButton.setEnabled(this.isGssapiEnabled() && !useKrb5SystemProperties);
            this.krb5CredentialConfigurationObtainTgtButton.setEnabled(this.isGssapiEnabled() && !useKrb5SystemProperties);
            this.krb5ConfigDefaultButton.setEnabled(this.isGssapiEnabled() && !useKrb5SystemProperties);
            this.krb5ConfigFileButton.setEnabled(this.isGssapiEnabled() && !useKrb5SystemProperties);
            this.krb5ConfigManualButton.setEnabled(this.isGssapiEnabled() && !useKrb5SystemProperties);
            this.krb5ConfigFileText.setEnabled(this.isGssapiEnabled() && this.krb5ConfigFileButton.getSelection() && !useKrb5SystemProperties);
            this.krb5ConfigManualRealmText.setEnabled(this.isGssapiEnabled() && this.krb5ConfigManualButton.getSelection() && !useKrb5SystemProperties);
            this.krb5ConfigManualHostText.setEnabled(this.isGssapiEnabled() && this.krb5ConfigManualButton.getSelection() && !useKrb5SystemProperties);
            this.krb5ConfigManualPortText.setEnabled(this.isGssapiEnabled() && this.krb5ConfigManualButton.getSelection() && !useKrb5SystemProperties);
        }
        this.bindPrincipalCombo.setEnabled(this.isPrincipalPasswordEnabled());
        this.bindPasswordText.setEnabled(this.isPrincipalPasswordEnabled() && this.isSaveBindPassword());
        this.saveBindPasswordButton.setEnabled(this.isPrincipalPasswordEnabled());
        this.checkPrincipalPasswordAuthButton.setEnabled(this.isPrincipalPasswordEnabled() && this.isSaveBindPassword() && !this.bindPrincipalCombo.getText().equals("") && !this.bindPasswordText.getText().equals("") || this.isGssapiEnabled());
        this.message = null;
        this.infoMessage = null;
        this.errorMessage = null;
        if (this.isPrincipalPasswordEnabled()) {
            if (this.isSaveBindPassword() && "".equals(this.bindPasswordText.getText())) {
                this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterBindPassword");
            }
            if ("".equals(this.bindPrincipalCombo.getText()) && !this.isGssapiEnabled()) {
                this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterBindDNOrUser");
            }
        }
        if (this.isSaslRealmTextEnabled() && "".equals(this.saslRealmText.getText())) {
            this.infoMessage = Messages.getString("AuthenticationParameterPage.PleaseEnterSaslRealm");
        }
        if (this.isGssapiEnabled() && this.krb5ConfigFileButton.getSelection() && "".equals(this.krb5ConfigFileText.getText())) {
            this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterKrb5ConfigFile");
        }
        if (this.isGssapiEnabled() && this.krb5ConfigManualButton.getSelection()) {
            if ("".equals(this.krb5ConfigManualPortText.getText())) {
                this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterKrb5Port");
            }
            if ("".equals(this.krb5ConfigManualHostText.getText())) {
                this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterKrb5Host");
            }
            if ("".equals(this.krb5ConfigManualRealmText.getText())) {
                this.message = Messages.getString("AuthenticationParameterPage.PleaseEnterKrb5Realm");
            }
        }
    }

    private boolean isPrincipalPasswordEnabled() {
        return this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SIMPLE || this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5 || this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5 || this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI && this.krb5CredentialConfigurationObtainTgtButton.getSelection();
    }

    private boolean isSaslRealmTextEnabled() {
        return this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5;
    }

    private boolean isSaslEnabled() {
        return this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5 || this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5 || this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI;
    }

    private boolean isGssapiEnabled() {
        return this.getAuthenticationMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI;
    }

    @Override
    protected void loadParameters(ConnectionParameter parameter) {
        this.connectionParameter = parameter;
        int index = parameter.getAuthMethod() == ConnectionParameter.AuthenticationMethod.SIMPLE ? 1 : (parameter.getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5 ? 2 : (parameter.getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5 ? 3 : (parameter.getAuthMethod() == ConnectionParameter.AuthenticationMethod.SASL_GSSAPI ? 4 : 0)));
        this.authenticationMethodCombo.select(index);
        this.bindPrincipalCombo.setText(parameter.getBindPrincipal());
        String bindPassword = null;
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled()) {
            PasswordsKeyStoreManager passwordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager();
            if (passwordsKeyStoreManager.isLoaded()) {
                bindPassword = passwordsKeyStoreManager.getConnectionPassword(parameter.getId());
            }
        } else {
            bindPassword = parameter.getBindPassword();
        }
        this.bindPasswordText.setText(bindPassword != null ? bindPassword : "");
        this.saveBindPasswordButton.setSelection(bindPassword != null);
        this.saslRealmText.setText(parameter.getSaslRealm() != null ? parameter.getSaslRealm() : "");
        int qopIndex = parameter.getSaslQop() == SaslQoP.AUTH_INT ? 1 : (parameter.getSaslQop() == SaslQoP.AUTH_CONF ? 2 : 0);
        this.saslQopCombo.select(qopIndex);
        int securityStrengthIndex = parameter.getSaslSecurityStrength() == SaslSecurityStrength.MEDIUM ? 1 : (parameter.getSaslSecurityStrength() == SaslSecurityStrength.LOW ? 2 : 0);
        this.saslSecurityStrengthCombo.select(securityStrengthIndex);
        this.saslMutualAuthenticationButton.setSelection(parameter.isSaslMutualAuthentication());
        this.krb5CredentialConfigurationUseNativeButton.setSelection(parameter.getKrb5CredentialConfiguration() == ConnectionParameter.Krb5CredentialConfiguration.USE_NATIVE);
        this.krb5CredentialConfigurationObtainTgtButton.setSelection(parameter.getKrb5CredentialConfiguration() == ConnectionParameter.Krb5CredentialConfiguration.OBTAIN_TGT);
        this.krb5ConfigDefaultButton.setSelection(parameter.getKrb5Configuration() == ConnectionParameter.Krb5Configuration.DEFAULT);
        this.krb5ConfigFileButton.setSelection(parameter.getKrb5Configuration() == ConnectionParameter.Krb5Configuration.FILE);
        this.krb5ConfigManualButton.setSelection(parameter.getKrb5Configuration() == ConnectionParameter.Krb5Configuration.MANUAL);
        this.krb5ConfigFileText.setText(parameter.getKrb5ConfigurationFile() != null ? parameter.getKrb5ConfigurationFile() : "");
        this.krb5ConfigManualRealmText.setText(parameter.getKrb5Realm() != null ? parameter.getKrb5Realm() : "");
        this.krb5ConfigManualHostText.setText(parameter.getKrb5KdcHost() != null ? parameter.getKrb5KdcHost() : "");
        this.krb5ConfigManualPortText.setText(parameter.getKrb5KdcPort() != 0 ? "" + parameter.getKrb5KdcPort() : "");
    }

    @Override
    protected void initListeners() {
        this.authenticationMethodCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.bindPrincipalCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.bindPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.saveBindPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (!AuthenticationParameterPage.this.saveBindPasswordButton.getSelection()) {
                    AuthenticationParameterPage.this.bindPasswordText.setText("");
                }
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.checkPrincipalPasswordAuthButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Connection connection = AuthenticationParameterPage.this.getTestConnection();
                CheckBindRunnable runnable = new CheckBindRunnable(connection);
                IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, AuthenticationParameterPage.this.runnableContext, true);
                if (status.isOK()) {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("AuthenticationParameterPage.CheckAuthentication"), (String)Messages.getString("AuthenticationParameterPage.AuthenticationSuccessfull"));
                }
            }
        });
        this.saslRealmText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent even) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.saslQopCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.saslSecurityStrengthCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.saslMutualAuthenticationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5CredentialConfigurationUseNativeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5CredentialConfigurationObtainTgtButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigManualButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigManualRealmText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigManualHostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
        this.krb5ConfigManualPortText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                if (!event.text.matches("[0-9]*")) {
                    event.doit = false;
                }
            }
        });
        this.krb5ConfigManualPortText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AuthenticationParameterPage.this.connectionPageModified();
            }
        });
    }

    @Override
    public void saveParameters(ConnectionParameter parameter) {
        parameter.setAuthMethod(this.getAuthenticationMethod());
        parameter.setBindPrincipal(this.getBindPrincipal());
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled()) {
            PasswordsKeyStoreManager passwordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager();
            if (passwordsKeyStoreManager.isLoaded()) {
                passwordsKeyStoreManager.storeConnectionPassword(parameter.getId(), this.getBindPassword());
            }
        } else {
            parameter.setBindPassword(this.getBindPassword());
        }
        parameter.setSaslRealm(this.getSaslRealm());
        parameter.setSaslQop(this.getSaslQop());
        parameter.setSaslSecurityStrength(this.getSaslSecurityStrength());
        parameter.setSaslMutualAuthentication(this.saslMutualAuthenticationButton.getSelection());
        parameter.setKrb5CredentialConfiguration(this.getKrb5CredentialProvider());
        parameter.setKrb5Configuration(this.getKrb5Configuration());
        parameter.setKrb5ConfigurationFile(this.krb5ConfigFileText.getText());
        parameter.setKrb5Realm(this.krb5ConfigManualRealmText.getText());
        parameter.setKrb5KdcHost(this.krb5ConfigManualHostText.getText());
        parameter.setKrb5KdcPort(this.getKdcPort());
    }

    @Override
    public void saveDialogSettings() {
        IDialogSettings dialogSettings = ConnectionUIPlugin.getDefault().getDialogSettings();
        HistoryUtils.save((IDialogSettings)dialogSettings, (String)"principalHistory", (String)this.bindPrincipalCombo.getText());
        if (this.getAuthenticationMethod().equals((Object)ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5)) {
            HistoryUtils.save((IDialogSettings)dialogSettings, (String)"saslrealmHistory", (String)this.saslRealmText.getText());
        }
    }

    @Override
    public void setFocus() {
        this.bindPrincipalCombo.setFocus();
    }

    @Override
    public boolean areParametersModifed() {
        return this.isReconnectionRequired();
    }

    @Override
    public boolean isReconnectionRequired() {
        return this.connectionParameter == null || this.connectionParameter.getAuthMethod() != this.getAuthenticationMethod() || !StringUtils.equals((String)this.connectionParameter.getBindPrincipal(), (String)this.getBindPrincipal()) || !StringUtils.equals((String)this.connectionParameter.getBindPassword(), (String)this.getBindPassword()) || !StringUtils.equals((String)this.connectionParameter.getSaslRealm(), (String)this.getSaslRealm()) || this.connectionParameter.getSaslQop() != this.getSaslQop() || this.connectionParameter.getSaslSecurityStrength() != this.getSaslSecurityStrength() || this.connectionParameter.isSaslMutualAuthentication() != this.saslMutualAuthenticationButton.getSelection() || this.connectionParameter.getKrb5CredentialConfiguration() != this.getKrb5CredentialProvider() || this.connectionParameter.getKrb5Configuration() != this.getKrb5Configuration() || !StringUtils.equals((String)this.connectionParameter.getKrb5ConfigurationFile(), (String)this.krb5ConfigFileText.getText()) || !StringUtils.equals((String)this.connectionParameter.getKrb5Realm(), (String)this.krb5ConfigManualRealmText.getText()) || !StringUtils.equals((String)this.connectionParameter.getKrb5KdcHost(), (String)this.krb5ConfigManualHostText.getText()) || this.connectionParameter.getKrb5KdcPort() != this.getKdcPort();
    }

    @Override
    public void mergeParametersToLdapURL(ConnectionParameter parameter, LdapUrl ldapUrl) {
        switch (parameter.getAuthMethod()) {
            case SASL_CRAM_MD5: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_AUTH_METHOD, X_AUTH_METHOD_CRAM_MD5));
                break;
            }
            case SASL_DIGEST_MD5: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_AUTH_METHOD, X_AUTH_METHOD_DIGEST_MD5));
                break;
            }
            case SASL_GSSAPI: {
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_AUTH_METHOD, X_AUTH_METHOD_GSSAPI));
                break;
            }
            case SIMPLE: {
                if (!StringUtils.isEmpty((String)parameter.getBindPrincipal())) break;
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_AUTH_METHOD, X_AUTH_METHOD_SIMPLE));
                break;
            }
            case NONE: {
                if (!StringUtils.isNotEmpty((String)parameter.getBindPrincipal())) break;
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_AUTH_METHOD, X_AUTH_METHOD_ANONYMOUS));
            }
        }
        if (StringUtils.isNotEmpty((String)parameter.getBindPrincipal())) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_BIND_USER, parameter.getBindPrincipal()));
        }
        if (StringUtils.isNotEmpty((String)parameter.getBindPassword())) {
            ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_BIND_PASSWORD, parameter.getBindPassword()));
        }
        switch (parameter.getAuthMethod()) {
            case SASL_CRAM_MD5: 
            case SASL_DIGEST_MD5: 
            case SASL_GSSAPI: {
                if (StringUtils.isNotEmpty((String)parameter.getSaslRealm())) {
                    ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_REALM, parameter.getSaslRealm()));
                }
                switch (parameter.getSaslQop()) {
                    case AUTH: {
                        break;
                    }
                    case AUTH_INT: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_QOP, X_SASL_QOP_AUTH_INT));
                        break;
                    }
                    case AUTH_CONF: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_QOP, X_SASL_QOP_AUTH_INT_PRIV));
                    }
                }
                switch (parameter.getSaslSecurityStrength()) {
                    case HIGH: {
                        break;
                    }
                    case MEDIUM: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_SEC_STRENGTH, X_SASL_SEC_STRENGTH_MEDIUM));
                        break;
                    }
                    case LOW: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_SEC_STRENGTH, X_SASL_SEC_STRENGTH_LOW));
                    }
                }
                if (parameter.isSaslMutualAuthentication()) break;
                ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_SASL_NO_MUTUAL_AUTH, null));
            }
        }
        block20 : switch (parameter.getAuthMethod()) {
            case SASL_GSSAPI: {
                switch (parameter.getKrb5CredentialConfiguration()) {
                    case USE_NATIVE: {
                        break;
                    }
                    case OBTAIN_TGT: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CREDENTIALS_CONF, X_KRB5_CREDENTIALS_CONF_OBTAIN_TGT));
                    }
                }
                switch (parameter.getKrb5Configuration()) {
                    case DEFAULT: {
                        break block20;
                    }
                    case FILE: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG, X_KRB5_CONFIG_FILE));
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG_FILE_FILE, parameter.getKrb5ConfigurationFile()));
                        break block20;
                    }
                    case MANUAL: {
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG, X_KRB5_CONFIG_MANUAL));
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG_MANUAL_REALM, parameter.getKrb5Realm()));
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG_MANUAL_KDC_HOST, parameter.getKrb5KdcHost()));
                        ldapUrl.getExtensions().add(new LdapUrl.Extension(false, X_KRB5_CONFIG_MANUAL_KDC_PORT, "" + parameter.getKrb5KdcPort()));
                    }
                }
            }
        }
    }

    @Override
    public void mergeLdapUrlToParameters(LdapUrl ldapUrl, ConnectionParameter parameter) {
        String saslQop;
        String principal = ldapUrl.getExtensionValue(X_BIND_USER);
        if (principal == null) {
            principal = "";
        }
        parameter.setBindPrincipal(principal);
        String password = ldapUrl.getExtensionValue(X_BIND_PASSWORD);
        parameter.setBindPassword(password);
        String authMethod = ldapUrl.getExtensionValue(X_AUTH_METHOD);
        if (StringUtils.isNotEmpty((String)authMethod) && X_AUTH_METHOD_ANONYMOUS.equalsIgnoreCase(authMethod)) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.NONE);
        } else if (StringUtils.isNotEmpty((String)authMethod) && X_AUTH_METHOD_SIMPLE.equalsIgnoreCase(authMethod)) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
        } else if (StringUtils.isNotEmpty((String)authMethod) && X_AUTH_METHOD_DIGEST_MD5.equalsIgnoreCase(authMethod)) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SASL_DIGEST_MD5);
        } else if (StringUtils.isNotEmpty((String)authMethod) && X_AUTH_METHOD_CRAM_MD5.equalsIgnoreCase(authMethod)) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SASL_CRAM_MD5);
        } else if (StringUtils.isNotEmpty((String)parameter.getBindPrincipal())) {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
        } else {
            parameter.setAuthMethod(ConnectionParameter.AuthenticationMethod.NONE);
        }
        String saslRealm = ldapUrl.getExtensionValue(X_SASL_REALM);
        if (StringUtils.isNotEmpty((String)saslRealm)) {
            parameter.setSaslRealm(saslRealm);
        }
        if (StringUtils.isNotEmpty((String)(saslQop = ldapUrl.getExtensionValue(X_SASL_QOP))) && X_SASL_QOP_AUTH_INT.equalsIgnoreCase(saslQop)) {
            parameter.setSaslQop(SaslQoP.AUTH_INT);
        } else if (StringUtils.isNotEmpty((String)saslQop) && X_SASL_QOP_AUTH_INT_PRIV.equalsIgnoreCase(saslQop)) {
            parameter.setSaslQop(SaslQoP.AUTH_CONF);
        } else {
            parameter.setSaslQop(SaslQoP.AUTH);
        }
        String saslSecStrength = ldapUrl.getExtensionValue(X_SASL_SEC_STRENGTH);
        if (StringUtils.isNotEmpty((String)saslSecStrength) && X_SASL_SEC_STRENGTH_MEDIUM.equalsIgnoreCase(saslSecStrength)) {
            parameter.setSaslSecurityStrength(SaslSecurityStrength.MEDIUM);
        } else if (StringUtils.isNotEmpty((String)saslSecStrength) && X_SASL_SEC_STRENGTH_LOW.equalsIgnoreCase(saslSecStrength)) {
            parameter.setSaslSecurityStrength(SaslSecurityStrength.LOW);
        } else {
            parameter.setSaslSecurityStrength(SaslSecurityStrength.HIGH);
        }
        LdapUrl.Extension saslNoMutualAuth = ldapUrl.getExtension(X_SASL_NO_MUTUAL_AUTH);
        parameter.setSaslMutualAuthentication(saslNoMutualAuth == null);
        String krb5CredentialsConf = ldapUrl.getExtensionValue(X_KRB5_CREDENTIALS_CONF);
        if (StringUtils.isNotEmpty((String)krb5CredentialsConf) && X_KRB5_CREDENTIALS_CONF_OBTAIN_TGT.equalsIgnoreCase(krb5CredentialsConf)) {
            parameter.setKrb5CredentialConfiguration(ConnectionParameter.Krb5CredentialConfiguration.OBTAIN_TGT);
        } else {
            parameter.setKrb5CredentialConfiguration(ConnectionParameter.Krb5CredentialConfiguration.USE_NATIVE);
        }
        String krb5Config = ldapUrl.getExtensionValue(X_KRB5_CONFIG);
        if (StringUtils.isNotEmpty((String)krb5Config) && X_KRB5_CONFIG_FILE.equalsIgnoreCase(krb5Config)) {
            parameter.setKrb5Configuration(ConnectionParameter.Krb5Configuration.FILE);
        } else if (StringUtils.isNotEmpty((String)krb5Config) && X_KRB5_CONFIG_MANUAL.equalsIgnoreCase(krb5Config)) {
            parameter.setKrb5Configuration(ConnectionParameter.Krb5Configuration.MANUAL);
        } else {
            parameter.setKrb5Configuration(ConnectionParameter.Krb5Configuration.DEFAULT);
        }
        parameter.setKrb5ConfigurationFile(ldapUrl.getExtensionValue(X_KRB5_CONFIG_FILE_FILE));
        parameter.setKrb5Realm(ldapUrl.getExtensionValue(X_KRB5_CONFIG_MANUAL_REALM));
        parameter.setKrb5KdcHost(ldapUrl.getExtensionValue(X_KRB5_CONFIG_MANUAL_KDC_HOST));
        String kdcPort = ldapUrl.getExtensionValue(X_KRB5_CONFIG_MANUAL_KDC_PORT);
        try {
            parameter.setKrb5KdcPort(new Integer(kdcPort).intValue());
        }
        catch (NumberFormatException e) {
            parameter.setKrb5KdcPort(88);
        }
    }
}

