/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui.preferences;

import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.preferences.Messages;
import org.apache.directory.studio.connection.ui.widgets.CertificateListComposite;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class CertificateValidationPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button verifyCertificatesButton;
    private TabFolder tabFolder;
    private CertificateListComposite permanentCLComposite;
    private CertificateListComposite sessionCLComposite;

    public CertificateValidationPreferencePage() {
        super(Messages.getString("CertificateValidationPreferencePage.CertificateValidation"));
        super.setPreferenceStore(ConnectionUIPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = BaseWidgetUtils.createColumnContainer((Composite)parent, (int)1, (int)1);
        Preferences preferences = ConnectionCorePlugin.getDefault().getPluginPreferences();
        boolean validateCertificates = preferences.getBoolean("validateCertificates");
        this.verifyCertificatesButton = BaseWidgetUtils.createCheckbox((Composite)composite, (String)Messages.getString("CertificateValidationPreferencePage.ValidateCertificates"), (int)1);
        this.verifyCertificatesButton.setSelection(validateCertificates);
        this.verifyCertificatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CertificateValidationPreferencePage.this.tabFolder.setEnabled(CertificateValidationPreferencePage.this.verifyCertificatesButton.getSelection());
            }
        });
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.permanentCLComposite = new CertificateListComposite((Composite)this.tabFolder, 0);
        this.permanentCLComposite.setInput(ConnectionCorePlugin.getDefault().getPermanentTrustStoreManager());
        TabItem permanentTab = new TabItem(this.tabFolder, 0, 0);
        permanentTab.setText(Messages.getString("CertificateValidationPreferencePage.PermanentTrusted"));
        permanentTab.setControl((Control)this.permanentCLComposite);
        this.sessionCLComposite = new CertificateListComposite((Composite)this.tabFolder, 0);
        this.sessionCLComposite.setInput(ConnectionCorePlugin.getDefault().getSessionTrustStoreManager());
        TabItem sessionTab = new TabItem(this.tabFolder, 0, 1);
        sessionTab.setText(Messages.getString("CertificateValidationPreferencePage.TemporaryTrusted"));
        sessionTab.setControl((Control)this.sessionCLComposite);
        this.tabFolder.setEnabled(this.verifyCertificatesButton.getSelection());
        return composite;
    }

    protected void performDefaults() {
        this.verifyCertificatesButton.setSelection(ConnectionCorePlugin.getDefault().getPluginPreferences().getDefaultBoolean("validateCertificates"));
        ConnectionCorePlugin.getDefault().savePluginPreferences();
        super.performDefaults();
    }

    public boolean performOk() {
        ConnectionCorePlugin.getDefault().getPluginPreferences().setValue("validateCertificates", this.verifyCertificatesButton.getSelection());
        ConnectionCorePlugin.getDefault().savePluginPreferences();
        return true;
    }
}

