/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import org.apache.directory.studio.connection.core.ConnectionCorePlugin;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.Credentials;
import org.apache.directory.studio.connection.core.IAuthHandler;
import org.apache.directory.studio.connection.core.ICredentials;
import org.apache.directory.studio.connection.core.PasswordsKeyStoreManager;
import org.apache.directory.studio.connection.ui.Messages;
import org.apache.directory.studio.connection.ui.PasswordsKeyStoreManagerUtils;
import org.apache.directory.studio.connection.ui.dialogs.PasswordDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public class UIAuthHandler
implements IAuthHandler {
    public ICredentials getCredentials(ConnectionParameter connectionParameter) {
        if (connectionParameter.getBindPrincipal() == null || "".equals(connectionParameter.getBindPrincipal())) {
            return new Credentials("", "", connectionParameter);
        }
        if (PasswordsKeyStoreManagerUtils.isPasswordsKeystoreEnabled()) {
            PasswordsKeyStoreManager passwordsKeyStoreManager = ConnectionCorePlugin.getDefault().getPasswordsKeyStoreManager();
            if (!passwordsKeyStoreManager.isLoaded() && !PasswordsKeyStoreManagerUtils.askUserToLoadKeystore()) {
                return null;
            }
            String password = passwordsKeyStoreManager.getConnectionPassword(connectionParameter.getId());
            if (password != null && !"".equals(password)) {
                return new Credentials(connectionParameter.getBindPrincipal(), password, connectionParameter);
            }
            return this.askConnectionPassword(connectionParameter);
        }
        if (connectionParameter.getBindPassword() != null && !"".equals(connectionParameter.getBindPassword())) {
            return new Credentials(connectionParameter.getBindPrincipal(), connectionParameter.getBindPassword(), connectionParameter);
        }
        return this.askConnectionPassword(connectionParameter);
    }

    private Credentials askConnectionPassword(final ConnectionParameter connectionParameter) {
        final String[] password = new String[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                PasswordDialog dialog = new PasswordDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), NLS.bind((String)Messages.getString("UIAuthHandler.EnterPasswordFor"), (Object[])new String[]{connectionParameter.getName()}), NLS.bind((String)Messages.getString("UIAuthHandler.PleaseEnterPasswordOfUser"), (Object)connectionParameter.getBindPrincipal()), "");
                if (dialog.open() == 0) {
                    password[0] = dialog.getPassword();
                }
            }
        });
        if (password[0] != null) {
            return new Credentials(connectionParameter.getBindPrincipal(), password[0], connectionParameter);
        }
        return null;
    }
}

