/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.NewObjectClassContentWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewObjectClassGeneralPageWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewObjectClassMandatoryAttributesPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewObjectClassOptionalAttributesPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewObjectClassWizard
extends Wizard
implements INewWizard {
    public static final String ID = PluginConstants.NEW_WIZARD_NEW_OBJECT_CLASS_WIZARD;
    private Schema selectedSchema;
    private NewObjectClassGeneralPageWizardPage generalPage;
    private NewObjectClassContentWizardPage contentPage;
    private NewObjectClassMandatoryAttributesPage mandatoryAttributesPage;
    private NewObjectClassOptionalAttributesPage optionalAttributesPage;

    public void addPages() {
        this.generalPage = new NewObjectClassGeneralPageWizardPage();
        this.generalPage.setSelectedSchema(this.selectedSchema);
        this.contentPage = new NewObjectClassContentWizardPage();
        this.mandatoryAttributesPage = new NewObjectClassMandatoryAttributesPage();
        this.optionalAttributesPage = new NewObjectClassOptionalAttributesPage();
        this.addPage((IWizardPage)this.generalPage);
        this.addPage((IWizardPage)this.contentPage);
        this.addPage((IWizardPage)this.mandatoryAttributesPage);
        this.addPage((IWizardPage)this.optionalAttributesPage);
    }

    public boolean performFinish() {
        MutableObjectClass newOC = new MutableObjectClass(this.generalPage.getOidValue());
        newOC.setSchemaName(this.generalPage.getSchemaValue());
        newOC.setNames(this.generalPage.getAliasesValue());
        newOC.setDescription(this.generalPage.getDescriptionValue());
        newOC.setSuperiorOids(this.contentPage.getSuperiorsNameValue());
        newOC.setType(this.contentPage.getClassTypeValue());
        newOC.setObsolete(this.contentPage.getObsoleteValue());
        newOC.setMustAttributeTypeOids(this.mandatoryAttributesPage.getMandatoryAttributeTypesNames());
        newOC.setMayAttributeTypeOids(this.optionalAttributesPage.getOptionalAttributeTypesNames());
        Activator.getDefault().getSchemaHandler().addObjectClass(newOC);
        PluginUtils.saveDialogSettingsHistory(PluginConstants.DIALOG_SETTINGS_OID_HISTORY, newOC.getOid());
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSelectedSchema(Schema schema) {
        this.selectedSchema = schema;
    }
}

