/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.wizards;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.wizards.NewAttributeTypeContentWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewAttributeTypeGeneralWizardPage;
import org.apache.directory.studio.schemaeditor.view.wizards.NewAttributeTypeMatchingRulesWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewAttributeTypeWizard
extends Wizard
implements INewWizard {
    public static final String ID = PluginConstants.NEW_WIZARD_NEW_ATTRIBUTE_TYPE_WIZARD;
    private Schema selectedSchema;
    private NewAttributeTypeGeneralWizardPage generalPage;
    private NewAttributeTypeContentWizardPage contentPage;
    private NewAttributeTypeMatchingRulesWizardPage matchingRulesPage;

    public void addPages() {
        this.generalPage = new NewAttributeTypeGeneralWizardPage();
        this.generalPage.setSelectedSchema(this.selectedSchema);
        this.contentPage = new NewAttributeTypeContentWizardPage();
        this.matchingRulesPage = new NewAttributeTypeMatchingRulesWizardPage();
        this.addPage((IWizardPage)this.generalPage);
        this.addPage((IWizardPage)this.contentPage);
        this.addPage((IWizardPage)this.matchingRulesPage);
    }

    public boolean performFinish() {
        MutableAttributeType newAT = new MutableAttributeType(this.generalPage.getOidValue());
        newAT.setSchemaName(this.generalPage.getSchemaValue());
        newAT.setNames(this.generalPage.getAliasesValue());
        newAT.setDescription(this.generalPage.getDescriptionValue());
        newAT.setSuperiorOid(this.contentPage.getSuperiorValue());
        newAT.setUsage(this.contentPage.getUsageValue());
        newAT.setSyntaxOid(this.contentPage.getSyntax());
        newAT.setSyntaxLength((long)this.contentPage.getSyntaxLengthValue());
        newAT.setObsolete(this.contentPage.getObsoleteValue());
        newAT.setSingleValued(this.contentPage.getSingleValueValue());
        newAT.setCollective(this.contentPage.getCollectiveValue());
        newAT.setUserModifiable(!this.contentPage.getNoUserModificationValue());
        newAT.setEqualityOid(this.matchingRulesPage.getEqualityMatchingRuleValue());
        newAT.setOrderingOid(this.matchingRulesPage.getOrderingMatchingRuleValue());
        newAT.setSubstringOid(this.matchingRulesPage.getSubstringMatchingRuleValue());
        Activator.getDefault().getSchemaHandler().addAttributeType((AttributeType)newAT);
        PluginUtils.saveDialogSettingsHistory(PluginConstants.DIALOG_SETTINGS_OID_HISTORY, newAT.getOid());
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setSelectedSchema(Schema schema) {
        this.selectedSchema = schema;
    }
}

