/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.widget;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.model.difference.AttributeTypeDifference;
import org.apache.directory.studio.schemaeditor.model.difference.ObjectClassDifference;
import org.apache.directory.studio.schemaeditor.model.difference.SchemaDifference;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.widget.Folder;
import org.apache.directory.studio.schemaeditor.view.widget.Messages;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DifferencesWidgetSchemaLabelProvider
extends LabelProvider {
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public String getText(Object element) {
        List names;
        String label = "";
        int labelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_LABEL);
        boolean abbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE);
        int abbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_ABBREVIATE_MAX_LENGTH);
        boolean secondaryLabelDisplay = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_DISPLAY);
        int secondaryLabelValue = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL);
        boolean secondaryLabelAbbreviate = this.store.getBoolean(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE);
        int secondaryLabelAbbreviateMaxLength = this.store.getInt(PluginConstants.PREFS_SCHEMA_VIEW_SECONDARY_LABEL_ABBREVIATE_MAX_LENGTH);
        if (element instanceof SchemaDifference) {
            SchemaDifference sd = (SchemaDifference)element;
            switch (sd.getType()) {
                case ADDED: {
                    return ((Schema)((Object)sd.getDestination())).getSchemaName();
                }
                case MODIFIED: {
                    return ((Schema)((Object)sd.getDestination())).getSchemaName();
                }
                case REMOVED: {
                    return ((Schema)((Object)sd.getSource())).getSchemaName();
                }
                case IDENTICAL: {
                    return ((Schema)((Object)sd.getDestination())).getSchemaName();
                }
            }
        } else if (element instanceof AttributeTypeDifference) {
            AttributeTypeDifference atd = (AttributeTypeDifference)element;
            AttributeType at = null;
            switch (atd.getType()) {
                case ADDED: {
                    at = (AttributeType)atd.getDestination();
                    break;
                }
                case MODIFIED: {
                    at = (AttributeType)atd.getDestination();
                    break;
                }
                case REMOVED: {
                    at = (AttributeType)atd.getSource();
                    break;
                }
                case IDENTICAL: {
                    at = (AttributeType)atd.getDestination();
                }
            }
            label = labelValue == 0 ? ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 1 ? ((names = at.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 2 ? at.getOid() : ((names = at.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof ObjectClassDifference) {
            ObjectClassDifference ocd = (ObjectClassDifference)element;
            ObjectClass oc = null;
            switch (ocd.getType()) {
                case ADDED: {
                    oc = (ObjectClass)ocd.getDestination();
                    break;
                }
                case MODIFIED: {
                    oc = (ObjectClass)ocd.getDestination();
                    break;
                }
                case REMOVED: {
                    oc = (ObjectClass)ocd.getSource();
                    break;
                }
                case IDENTICAL: {
                    oc = (ObjectClass)ocd.getDestination();
                }
            }
            label = labelValue == 0 ? ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 1 ? ((names = oc.getNames()) != null && names.size() > 0 ? ViewUtils.concateAliases(names) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None")) : (labelValue == 2 ? oc.getOid() : ((names = oc.getNames()) != null && names.size() > 0 ? (String)names.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None"))));
            if (abbreviate && abbreviateMaxLength < label.length()) {
                label = label.substring(0, abbreviateMaxLength) + "...";
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            return folder.getName() + " (" + folder.getChildren().size() + ")";
        }
        if (secondaryLabelDisplay) {
            String secondaryLabel = "";
            if (element instanceof AttributeTypeDifference) {
                AttributeTypeDifference atd = (AttributeTypeDifference)element;
                AttributeType at = null;
                switch (atd.getType()) {
                    case ADDED: {
                        at = (AttributeType)atd.getDestination();
                        break;
                    }
                    case MODIFIED: {
                        at = (AttributeType)atd.getDestination();
                        break;
                    }
                    case REMOVED: {
                        at = (AttributeType)atd.getSource();
                        break;
                    }
                    case IDENTICAL: {
                        at = (AttributeType)atd.getDestination();
                    }
                }
                if (secondaryLabelValue == 0) {
                    List names2 = at.getNames();
                    secondaryLabel = names2 != null && names2.size() > 0 ? (String)names2.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names3 = at.getNames();
                    secondaryLabel = names3 != null && names3.size() > 0 ? ViewUtils.concateAliases(names3) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = at.getOid();
                }
            } else if (element instanceof ObjectClassDifference) {
                ObjectClassDifference ocd = (ObjectClassDifference)element;
                ObjectClass oc = null;
                switch (ocd.getType()) {
                    case ADDED: {
                        oc = (ObjectClass)ocd.getDestination();
                        break;
                    }
                    case MODIFIED: {
                        oc = (ObjectClass)ocd.getDestination();
                        break;
                    }
                    case REMOVED: {
                        oc = (ObjectClass)ocd.getSource();
                        break;
                    }
                    case IDENTICAL: {
                        oc = (ObjectClass)ocd.getDestination();
                    }
                }
                if (secondaryLabelValue == 0) {
                    List names4 = oc.getNames();
                    secondaryLabel = names4 != null && names4.size() > 0 ? (String)names4.get(0) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 1) {
                    List names5 = oc.getNames();
                    secondaryLabel = names5 != null && names5.size() > 0 ? ViewUtils.concateAliases(names5) : Messages.getString("DifferencesWidgetSchemaLabelProvider.None");
                } else if (secondaryLabelValue == 2) {
                    secondaryLabel = oc.getOid();
                }
            }
            if (secondaryLabelAbbreviate && secondaryLabelAbbreviateMaxLength < secondaryLabel.length()) {
                secondaryLabel = secondaryLabel.substring(0, secondaryLabelAbbreviateMaxLength) + "...";
            }
            label = label + "  [" + secondaryLabel + "]";
        }
        return label;
    }

    public Image getImage(Object element) {
        if (element instanceof SchemaDifference) {
            SchemaDifference sd = (SchemaDifference)element;
            switch (sd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_schema_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/schema.gif");
                }
            }
        } else if (element instanceof AttributeTypeDifference) {
            AttributeTypeDifference atd = (AttributeTypeDifference)element;
            switch (atd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_attribute_type_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/attribute_type.gif");
                }
            }
        } else if (element instanceof ObjectClassDifference) {
            ObjectClassDifference ocd = (ObjectClassDifference)element;
            switch (ocd.getType()) {
                case ADDED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_add.gif");
                }
                case MODIFIED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_modify.gif");
                }
                case REMOVED: {
                    return Activator.getDefault().getImage("resources/icons/difference_object_class_remove.gif");
                }
                case IDENTICAL: {
                    return Activator.getDefault().getImage("resources/icons/object_class.gif");
                }
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            switch (folder.getType()) {
                case ATTRIBUTE_TYPE: {
                    return Activator.getDefault().getImage("resources/icons/folder_at.gif");
                }
                case OBJECT_CLASS: {
                    return Activator.getDefault().getImage("resources/icons/folder_oc.gif");
                }
                case NONE: {
                    return Activator.getDefault().getImage("resources/icons/folder.gif");
                }
            }
        }
        return null;
    }
}

