/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.views;

import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.SchemaObject;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.apache.directory.studio.schemaeditor.model.schemachecker.NoAliasWarning;
import org.apache.directory.studio.schemaeditor.model.schemachecker.SchemaWarning;
import org.apache.directory.studio.schemaeditor.view.views.Messages;
import org.apache.directory.studio.schemaeditor.view.wrappers.Folder;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaErrorWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWarningWrapper;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;

public class ProblemsViewLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof SchemaErrorWrapper) {
                return Activator.getDefault().getImage("resources/icons/problems_error.gif");
            }
            if (element instanceof SchemaWarningWrapper) {
                return Activator.getDefault().getImage("resources/icons/problems_warning.gif");
            }
            if (element instanceof Folder) {
                return Activator.getDefault().getImage("resources/icons/problems_group.gif");
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof SchemaErrorWrapper) {
            SchemaErrorWrapper errorWrapper = (SchemaErrorWrapper)element;
            if (columnIndex == 0) {
                return this.getMessage(errorWrapper.getLdapSchemaException());
            }
            if (columnIndex == 1) {
                return this.getDisplayName(errorWrapper.getLdapSchemaException().getSourceObject());
            }
        } else if (element instanceof SchemaWarningWrapper) {
            SchemaWarningWrapper warningWrapper = (SchemaWarningWrapper)element;
            if (columnIndex == 0) {
                return this.getMessage(warningWrapper.getSchemaWarning());
            }
            if (columnIndex == 1) {
                String name = warningWrapper.getSchemaWarning().getSource().getName();
                if (name != null && !name.equals("")) {
                    return name;
                }
                return warningWrapper.getSchemaWarning().getSource().getOid();
            }
        } else if (element instanceof Folder) {
            Folder folder = (Folder)element;
            if (columnIndex == 0) {
                return folder.getName() + " (" + folder.getChildren().size() + ")";
            }
            return "";
        }
        return element.toString();
    }

    private String getMessage(LdapSchemaException exception) {
        if (exception != null) {
            switch (exception.getCode()) {
                case NAME_ALREADY_REGISTERED: {
                    return this.getMessageNameAlreadyRegistered(exception);
                }
                case OID_ALREADY_REGISTERED: {
                    return this.getMessageOidAlreadyRegistered(exception);
                }
                case NONEXISTENT_SCHEMA: {
                    return this.getMessageNonExistentSchema(exception);
                }
                case AT_NONEXISTENT_SUPERIOR: {
                    return this.getMessageATNonExistentSuperior(exception);
                }
                case AT_CANNOT_SUBTYPE_COLLECTIVE_AT: {
                    return this.getMessageATCannotSubtypeCollectiveAT(exception);
                }
                case AT_CYCLE_TYPE_HIERARCHY: {
                    return this.getMessageATCycleTypeHierarchy(exception);
                }
                case AT_NONEXISTENT_SYNTAX: {
                    return this.getMessageATNonExistentSyntax(exception);
                }
                case AT_SYNTAX_OR_SUPERIOR_REQUIRED: {
                    return this.getMessageATSyntaxOrSuperiorRequired(exception);
                }
                case AT_NONEXISTENT_EQUALITY_MATCHING_RULE: {
                    return this.getMessageATNonExistentEqualityMatchingRule(exception);
                }
                case AT_NONEXISTENT_ORDERING_MATCHING_RULE: {
                    return this.getMessageATNonExistentOrderingMatchingRule(exception);
                }
                case AT_NONEXISTENT_SUBSTRING_MATCHING_RULE: {
                    return this.getMessageATNonExistentSubstringMatchingRule(exception);
                }
                case AT_MUST_HAVE_SAME_USAGE_THAN_SUPERIOR: {
                    return this.getMessageATMustHaveSameUsageThanSuperior(exception);
                }
                case AT_USER_APPLICATIONS_USAGE_MUST_BE_USER_MODIFIABLE: {
                    return this.getMessageATUserApplicationsUsageMustBeUserModifiable(exception);
                }
                case AT_COLLECTIVE_MUST_HAVE_USER_APPLICATIONS_USAGE: {
                    return this.getMessageATCollectiveMustHaveUserApplicationsUsage(exception);
                }
                case AT_COLLECTIVE_CANNOT_BE_SINGLE_VALUED: {
                    return this.getMessageATCollectiveCannotBeSingleValued(exception);
                }
                case OC_ABSTRACT_MUST_INHERIT_FROM_ABSTRACT_OC: {
                    return this.getMessageOCAbstractMustInheritFromAbstractOC(exception);
                }
                case OC_AUXILIARY_CANNOT_INHERIT_FROM_STRUCTURAL_OC: {
                    return this.getMessageOCAuxiliaryCannotInheritFromStructuralOC(exception);
                }
                case OC_STRUCTURAL_CANNOT_INHERIT_FROM_AUXILIARY_OC: {
                    return this.getMessageOCStructuralCannotInheritFromAuxiliaryOC(exception);
                }
                case OC_NONEXISTENT_SUPERIOR: {
                    return this.getMessageOCNonExistentSuperior(exception);
                }
                case OC_CYCLE_CLASS_HIERARCHY: {
                    return this.getMessageOCCycleClassHierarchy(exception);
                }
                case OC_COLLECTIVE_NOT_ALLOWED_IN_MUST: {
                    return this.getMessageOCCollectiveNotAllowedInMust(exception);
                }
                case OC_COLLECTIVE_NOT_ALLOWED_IN_MAY: {
                    return this.getMessageOCCollectiveNotAllowedInMay(exception);
                }
                case OC_DUPLICATE_AT_IN_MUST: {
                    return this.getMessageOCDuplicateATInMust(exception);
                }
                case OC_DUPLICATE_AT_IN_MAY: {
                    return this.getMessageOCDuplicateATInMay(exception);
                }
                case OC_NONEXISTENT_MUST_AT: {
                    return this.getMessageOCNonExistentMustAT(exception);
                }
                case OC_NONEXISTENT_MAY_AT: {
                    return this.getMessageOCNonExistentMayAT(exception);
                }
                case OC_DUPLICATE_AT_IN_MAY_AND_MUST: {
                    return this.getMessageOCDuplicateATInMayAndMust(exception);
                }
                case MR_NONEXISTENT_SYNTAX: {
                    return this.getMessageMRNonExistentSyntax(exception);
                }
            }
        }
        return "";
    }

    private String getMessage(SchemaWarning warning) {
        if (warning instanceof NoAliasWarning) {
            NoAliasWarning noAliasWarning = (NoAliasWarning)warning;
            SchemaObject source = noAliasWarning.getSource();
            if (source instanceof AttributeType) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NoAliasWarningAttributeType"), (Object[])new String[]{source.getOid()});
            }
            if (source instanceof ObjectClass) {
                return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NoAliasWarningObjectClass"), (Object[])new String[]{source.getOid()});
            }
        }
        return "";
    }

    private String getMessageNameAlreadyRegistered(LdapSchemaException exception) {
        SchemaObject duplicate = exception.getOtherObject();
        String message = null;
        if (duplicate instanceof AttributeType) {
            message = Messages.getString("ProblemsViewLabelProvider.NameAlreadyRegisteredAT");
        } else if (duplicate instanceof ObjectClass) {
            message = Messages.getString("ProblemsViewLabelProvider.NameAlreadyRegisteredOC");
        }
        return NLS.bind((String)message, (Object[])new String[]{exception.getRelatedId(), duplicate.getOid()});
    }

    private String getMessageOidAlreadyRegistered(LdapSchemaException exception) {
        SchemaObject duplicate = exception.getOtherObject();
        String message = null;
        if (duplicate instanceof AttributeType) {
            message = Messages.getString("ProblemsViewLabelProvider.OidAlreadyRegisteredAT");
        } else if (duplicate instanceof ObjectClass) {
            message = Messages.getString("ProblemsViewLabelProvider.OidAlreadyRegisteredOC");
        }
        return NLS.bind((String)message, (Object[])new String[]{exception.getRelatedId(), duplicate.getName()});
    }

    private String getMessageNonExistentSchema(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistentSchema"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATNonExistentSuperior(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ATNonExistentSuperior"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATCannotSubtypeCollectiveAT(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATCannotSubtypeCollectiveAT");
    }

    private String getMessageATCycleTypeHierarchy(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATCycleTypeHierarchy");
    }

    private String getMessageATNonExistentSyntax(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistentSyntax"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATSyntaxOrSuperiorRequired(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ATSyntaxOrSuperiorRequired"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATNonExistentEqualityMatchingRule(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ATNonExistentEqualityMatchingRule"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATNonExistentOrderingMatchingRule(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ATNonExistentOrderingMatchingRule"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATNonExistentSubstringMatchingRule(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.ATNonExistentSubstringMatchingRule"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageATMustHaveSameUsageThanSuperior(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATMustHaveSameUsageThanSuperior");
    }

    private String getMessageATUserApplicationsUsageMustBeUserModifiable(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATUserApplicationsUsageMustBeUserModifiable");
    }

    private String getMessageATCollectiveMustHaveUserApplicationsUsage(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATCollectiveMustHaveUserApplicationsUsage");
    }

    private String getMessageATCollectiveCannotBeSingleValued(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.ATCollectiveCannotBeSingleValued");
    }

    private String getMessageOCAbstractMustInheritFromAbstractOC(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.OCAbstractMustInheritFromAbstractOC");
    }

    private String getMessageOCAuxiliaryCannotInheritFromStructuralOC(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.OCAuxiliaryCannotInheritFromStructuralOC");
    }

    private String getMessageOCStructuralCannotInheritFromAuxiliaryOC(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.OCStructuralCannotInheritFromAuxiliaryOC");
    }

    private String getMessageOCNonExistentSuperior(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCNonExistentSuperior"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCCycleClassHierarchy(LdapSchemaException exception) {
        return Messages.getString("ProblemsViewLabelProvider.OCCycleClassHierarchy");
    }

    private String getMessageOCCollectiveNotAllowedInMust(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCCollectiveNotAllowedInMust"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCCollectiveNotAllowedInMay(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCCollectiveNotAllowedInMay"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCDuplicateATInMust(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCDuplicateATInMust"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCDuplicateATInMay(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCDuplicateATInMay"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCNonExistentMustAT(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCNonExistentMustAT"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCNonExistentMayAT(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCNonExistentMayAT"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageOCDuplicateATInMayAndMust(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.OCDuplicateATInMayAndMust"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getMessageMRNonExistentSyntax(LdapSchemaException exception) {
        return NLS.bind((String)Messages.getString("ProblemsViewLabelProvider.NonExistentSyntax"), (Object[])new String[]{exception.getRelatedId()});
    }

    private String getDisplayName(SchemaObject so) {
        if (so != null) {
            SchemaObject schemaObject = this.getSchemaObject(so);
            if (schemaObject != null) {
                String name = schemaObject.getName();
                if (name != null && !name.equals("")) {
                    return name;
                }
                return so.getOid();
            }
            return so.getOid();
        }
        return "";
    }

    private SchemaObject getSchemaObject(SchemaObject so) {
        SchemaHandler schemaHandler = Activator.getDefault().getSchemaHandler();
        AttributeType schemaObject = null;
        if (so instanceof AttributeType) {
            schemaObject = schemaHandler.getAttributeType(so.getOid());
        } else if (so instanceof LdapSyntax) {
            schemaObject = schemaHandler.getSyntax(so.getOid());
        } else if (so instanceof MatchingRule) {
            schemaObject = schemaHandler.getMatchingRule(so.getOid());
        } else if (so instanceof ObjectClass) {
            schemaObject = schemaHandler.getObjectClass(so.getOid());
        }
        return schemaObject;
    }
}

