/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.editors.attributetype;

import java.util.List;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MutableAttributeType;
import org.apache.directory.api.ldap.model.schema.MutableObjectClass;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerAdapter;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandlerListener;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.ViewUtils;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEUsedByMandatoryTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEUsedByOptionalTableContentProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.ATEUsedByTablesLabelProvider;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AbstractAttributeTypeEditorPage;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.AttributeTypeEditor;
import org.apache.directory.studio.schemaeditor.view.editors.attributetype.Messages;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditor;
import org.apache.directory.studio.schemaeditor.view.editors.objectclass.ObjectClassEditorInput;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class AttributeTypeEditorUsedByPage
extends AbstractAttributeTypeEditorPage {
    public static final String ID = AttributeTypeEditor.ID + "usedByPage";
    private SchemaHandlerListener schemaHandlerListener = new SchemaHandlerAdapter(){

        @Override
        public void attributeTypeAdded(AttributeType at) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void attributeTypeModified(AttributeType at) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void attributeTypeRemoved(AttributeType at) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void objectClassAdded(ObjectClass oc) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void objectClassModified(ObjectClass oc) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void objectClassRemoved(ObjectClass oc) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void schemaAdded(Schema schema) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }

        @Override
        public void schemaRemoved(Schema schema) {
            AttributeTypeEditorUsedByPage.this.refreshTableViewers();
        }
    };
    private Table mandatoryAttributeTable;
    private TableViewer mandatoryAttributeTableViewer;
    private Table optionalAttibuteTable;
    private TableViewer optionalAttibuteTableViewer;
    private MouseAdapter mandatoryAttributeTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorUsedByPage.this.mandatoryAttributeTableViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof ObjectClass) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new ObjectClassEditorInput((ObjectClass)((MutableObjectClass)selectedItem)), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(AttributeTypeEditorUsedByPage.class).debug((Object)"error when opening the editor");
                }
            }
        }
    };
    private MouseAdapter optionalAttibuteTableListener = new MouseAdapter(){

        public void mouseDoubleClick(MouseEvent e) {
            Object selectedItem = ((StructuredSelection)AttributeTypeEditorUsedByPage.this.optionalAttibuteTableViewer.getSelection()).getFirstElement();
            if (selectedItem instanceof ObjectClass) {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    page.openEditor((IEditorInput)new ObjectClassEditorInput((ObjectClass)((MutableObjectClass)selectedItem)), ObjectClassEditor.ID);
                }
                catch (PartInitException exception) {
                    Logger.getLogger(AttributeTypeEditorUsedByPage.class).debug((Object)"error when opening the editor");
                }
            }
        }
    };

    public AttributeTypeEditorUsedByPage(AttributeTypeEditor editor) {
        super(editor, ID, Messages.getString("AttributeTypeEditorUsedByPage.UsedBy"));
        Activator.getDefault().getSchemaHandler().addListener(this.schemaHandlerListener);
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        GridLayout layout = new GridLayout(2, true);
        form.getBody().setLayout((Layout)layout);
        this.createAsMandatoryAttributeSection(form.getBody(), toolkit);
        this.createAsOptionalAttributeSection(form.getBody(), toolkit);
        this.fillInUiFields();
        this.addListeners();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form, PluginConstants.PLUGIN_ID + "." + "attribute_type_editor");
        this.initialized = true;
    }

    private void createAsMandatoryAttributeSection(Composite parent, FormToolkit toolkit) {
        MutableAttributeType modifiedAttributeType = this.getModifiedAttributeType();
        Section mandatoryAttributeSection = toolkit.createSection(parent, 448);
        List names = modifiedAttributeType.getNames();
        if (names != null && names.size() > 0) {
            mandatoryAttributeSection.setDescription(NLS.bind((String)Messages.getString("AttributeTypeEditorUsedByPage.AttributeTypeMandatory"), (Object[])new String[]{ViewUtils.concateAliases(names)}));
        } else {
            mandatoryAttributeSection.setDescription(NLS.bind((String)Messages.getString("AttributeTypeEditorUsedByPage.AttributeTypeMandatory"), (Object[])new String[]{modifiedAttributeType.getOid()}));
        }
        mandatoryAttributeSection.setText(Messages.getString("AttributeTypeEditorUsedByPage.AsMandatoryAttribute"));
        Composite mandatoryAttributeSectionClient = toolkit.createComposite((Composite)mandatoryAttributeSection);
        mandatoryAttributeSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(mandatoryAttributeSectionClient);
        mandatoryAttributeSection.setClient((Control)mandatoryAttributeSectionClient);
        mandatoryAttributeSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mandatoryAttributeTable = toolkit.createTable(mandatoryAttributeSectionClient, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 1;
        this.mandatoryAttributeTable.setLayoutData((Object)gridData);
        this.mandatoryAttributeTableViewer = new TableViewer(this.mandatoryAttributeTable);
        this.mandatoryAttributeTableViewer.setContentProvider((IContentProvider)new ATEUsedByMandatoryTableContentProvider());
        this.mandatoryAttributeTableViewer.setLabelProvider((IBaseLabelProvider)new ATEUsedByTablesLabelProvider());
    }

    private void createAsOptionalAttributeSection(Composite parent, FormToolkit toolkit) {
        MutableAttributeType modifiedAttributeType = this.getModifiedAttributeType();
        Section optionalAttributeSection = toolkit.createSection(parent, 448);
        List names = modifiedAttributeType.getNames();
        if (names != null && names.size() > 0) {
            optionalAttributeSection.setDescription(NLS.bind((String)Messages.getString("AttributeTypeEditorUsedByPage.AttributeTypeOptional"), (Object[])new String[]{ViewUtils.concateAliases(names)}));
        } else {
            optionalAttributeSection.setDescription(NLS.bind((String)Messages.getString("AttributeTypeEditorUsedByPage.AttributeTypeOptional"), (Object[])new String[]{modifiedAttributeType.getOid()}));
        }
        optionalAttributeSection.setText(Messages.getString("AttributeTypeEditorUsedByPage.AsOptionalAttribute"));
        Composite optionalAttributeSectionClient = toolkit.createComposite((Composite)optionalAttributeSection);
        optionalAttributeSectionClient.setLayout((Layout)new GridLayout());
        toolkit.paintBordersFor(optionalAttributeSectionClient);
        optionalAttributeSection.setClient((Control)optionalAttributeSectionClient);
        optionalAttributeSection.setLayoutData((Object)new GridData(4, 4, true, true));
        this.optionalAttibuteTable = toolkit.createTable(optionalAttributeSectionClient, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 1;
        this.optionalAttibuteTable.setLayoutData((Object)gridData);
        this.optionalAttibuteTableViewer = new TableViewer(this.optionalAttibuteTable);
        this.optionalAttibuteTableViewer.setContentProvider((IContentProvider)new ATEUsedByOptionalTableContentProvider());
        this.optionalAttibuteTableViewer.setLabelProvider((IBaseLabelProvider)new ATEUsedByTablesLabelProvider());
    }

    @Override
    protected void fillInUiFields() {
        MutableAttributeType modifiedAttributeType = this.getModifiedAttributeType();
        this.mandatoryAttributeTableViewer.setInput((Object)modifiedAttributeType);
        this.optionalAttibuteTableViewer.setInput((Object)modifiedAttributeType);
    }

    @Override
    protected void addListeners() {
        this.addMouseListener(this.mandatoryAttributeTable, (MouseListener)this.mandatoryAttributeTableListener);
        this.addMouseListener(this.optionalAttibuteTable, (MouseListener)this.optionalAttibuteTableListener);
    }

    @Override
    protected void removeListeners() {
        this.removeMouseListener(this.mandatoryAttributeTable, (MouseListener)this.mandatoryAttributeTableListener);
        this.removeMouseListener(this.optionalAttibuteTable, (MouseListener)this.optionalAttibuteTableListener);
    }

    public void refreshTableViewers() {
        if (this.mandatoryAttributeTableViewer != null) {
            this.mandatoryAttributeTableViewer.refresh();
        }
        if (this.optionalAttibuteTableViewer != null) {
            this.optionalAttibuteTableViewer.refresh();
        }
    }

    @Override
    public void dispose() {
        Activator.getDefault().getSchemaHandler().removeListener(this.schemaHandlerListener);
        super.dispose();
    }
}

