/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.view.dialogs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.controller.SchemaHandler;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class AttributeTypeSelectionDialogContentProvider
implements IStructuredContentProvider {
    private SchemaHandler schemaHandler;
    private List<AttributeType> hiddenAttributeTypes;

    public AttributeTypeSelectionDialogContentProvider(List<AttributeType> hiddenAttributeTypes) {
        this.hiddenAttributeTypes = hiddenAttributeTypes;
        this.schemaHandler = Activator.getDefault().getSchemaHandler();
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof String) {
            ArrayList<AttributeType> results = new ArrayList<AttributeType>();
            String searchText = (String)inputElement;
            searchText = searchText + "*";
            String searchRegexp = searchText.replaceAll("\\*", "[\\\\S]*");
            searchRegexp = searchRegexp.replaceAll("\\?", "[\\\\S]");
            Pattern pattern = Pattern.compile(searchRegexp, 2);
            List<AttributeType> atList = this.schemaHandler.getAttributeTypes();
            Collections.sort(atList, new Comparator<AttributeType>(){

                @Override
                public int compare(AttributeType at1, AttributeType at2) {
                    List at1Names = at1.getNames();
                    List at2Names = at2.getNames();
                    if (!(at1Names != null && at1Names.size() != 0 || at2Names != null && at2Names.size() != 0)) {
                        return 0;
                    }
                    if ((at1Names == null || at1Names.size() == 0) && at2Names != null && at2Names.size() > 0) {
                        return "".compareToIgnoreCase((String)at2Names.get(0));
                    }
                    if (at1Names != null && at1Names.size() > 0 && (at2Names == null || at2Names.size() == 0)) {
                        return ((String)at1Names.get(0)).compareToIgnoreCase("");
                    }
                    return ((String)at1Names.get(0)).compareToIgnoreCase((String)at2Names.get(0));
                }
            });
            for (AttributeType at : atList) {
                Matcher m;
                for (String name : at.getNames()) {
                    Matcher m2 = pattern.matcher(name);
                    if (!m2.matches()) continue;
                    if (this.hiddenAttributeTypes.contains(at) || results.contains(at)) break;
                    results.add(at);
                    break;
                }
                if (!(m = pattern.matcher(at.getOid())).matches() || this.hiddenAttributeTypes.contains(at) || results.contains(at)) continue;
                results.add(at);
            }
            return results.toArray();
        }
        return new Object[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

