/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.password;

import org.apache.directory.api.ldap.model.constants.LdapSecurityConstants;
import org.apache.directory.studio.common.ui.widgets.BaseWidgetUtils;
import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.connection.core.ConnectionParameter;
import org.apache.directory.studio.connection.core.jobs.CheckBindRunnable;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.connection.ui.RunnableContextRunner;
import org.apache.directory.studio.ldapbrowser.core.BrowserCoreMessages;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.Password;
import org.apache.directory.studio.ldapbrowser.core.utils.Utils;
import org.apache.directory.studio.valueeditors.ValueEditorsActivator;
import org.apache.directory.studio.valueeditors.password.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends Dialog {
    private static final String NO_HASH_METHOD = "NO-HASH-METHOD";
    private static final Object[] HASH_METHODS = new Object[]{LdapSecurityConstants.HASH_METHOD_SHA, LdapSecurityConstants.HASH_METHOD_SHA256, LdapSecurityConstants.HASH_METHOD_SHA384, LdapSecurityConstants.HASH_METHOD_SHA512, LdapSecurityConstants.HASH_METHOD_SSHA, LdapSecurityConstants.HASH_METHOD_SSHA256, LdapSecurityConstants.HASH_METHOD_SSHA384, LdapSecurityConstants.HASH_METHOD_SSHA512, LdapSecurityConstants.HASH_METHOD_MD5, LdapSecurityConstants.HASH_METHOD_SMD5, LdapSecurityConstants.HASH_METHOD_CRYPT, "NO-HASH-METHOD"};
    private static final int CURRENT_TAB = 0;
    private static final int NEW_TAB = 1;
    private static final String SELECTED_TAB_DIALOGSETTINGS_KEY = PasswordDialog.class.getName() + ".tab";
    private static final String SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY = PasswordDialog.class.getName() + ".hashMethod";
    private DisplayMode displayMode;
    private IEntry entry;
    private Password currentPassword;
    private Password newPassword;
    private byte[] returnPassword;
    private Button okButton;
    private TabFolder tabFolder;
    private TabItem currentPasswordTab;
    private Composite currentPasswordComposite;
    private Text currentPasswordText;
    private Text currentPasswordHashMethodText;
    private Text currentPasswordValueHexText;
    private Text currentPasswordSaltHexText;
    private Button showCurrentPasswordDetailsButton;
    private Text testPasswordText;
    private Text testBindDnText;
    private Button showTestPasswordDetailsButton;
    private Button verifyPasswordButton;
    private Button bindPasswordButton;
    private TabItem newPasswordTab;
    private Composite newPasswordComposite;
    private Text newPasswordText;
    private ComboViewer newPasswordHashMethodComboViewer;
    private Text newPasswordPreviewText;
    private Text newPasswordPreviewValueHexText;
    private Text newPasswordPreviewSaltHexText;
    private Button newSaltButton;
    private Button showNewPasswordDetailsButton;

    public PasswordDialog(Shell parentShell, byte[] currentPassword, IEntry entry) {
        super(parentShell);
        super.setShellStyle(super.getShellStyle() | 0x10);
        try {
            this.currentPassword = currentPassword != null ? new Password(currentPassword) : null;
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        this.entry = entry;
        this.returnPassword = null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(Messages.getString("PasswordDialog.PasswordEditor"));
        shell.setImage(ValueEditorsActivator.getDefault().getImage("resources/icons/passwordeditor.gif"));
    }

    protected void okPressed() {
        this.returnPassword = (byte[])(this.newPassword != null ? this.newPassword.toBytes() : null);
        LdapSecurityConstants selectedHashMethod = this.getSelectedNewPasswordHashMethod();
        if (selectedHashMethod == null) {
            ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY, NO_HASH_METHOD);
        } else {
            ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY, selectedHashMethod.getName());
        }
        super.okPressed();
    }

    public boolean close() {
        ValueEditorsActivator.getDefault().getDialogSettings().put(SELECTED_TAB_DIALOGSETTINGS_KEY, this.tabFolder.getSelectionIndex());
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        try {
            int tabIndex = ValueEditorsActivator.getDefault().getDialogSettings().getInt(SELECTED_TAB_DIALOGSETTINGS_KEY);
            if (this.currentPassword == null || this.currentPassword.toBytes().length == 0) {
                tabIndex = 1;
            }
            this.tabFolder.setSelection(tabIndex);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String hashMethodName = ValueEditorsActivator.getDefault().getDialogSettings().get(SELECTED_HASH_METHOD_DIALOGSETTINGS_KEY);
            LdapSecurityConstants hashMethod = LdapSecurityConstants.getAlgorithm((String)hashMethodName);
            if (hashMethod == null || NO_HASH_METHOD.equals(hashMethodName)) {
                this.newPasswordHashMethodComboViewer.setSelection((ISelection)new StructuredSelection((Object)NO_HASH_METHOD));
            } else {
                this.newPasswordHashMethodComboViewer.setSelection((ISelection)new StructuredSelection((Object)hashMethod));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.updateTabFolder();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = this.convertHorizontalDLUsToPixels(300) * 3 / 2;
        gd.heightHint = this.convertVerticalDLUsToPixels(300) * 2 / 3;
        composite.setLayoutData((Object)gd);
        this.tabFolder = new TabFolder(composite, 128);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PasswordDialog.this.updateTabFolder();
            }
        });
        if (this.currentPassword != null && this.currentPassword.toBytes().length > 0) {
            this.displayMode = DisplayMode.CURRENT_AND_NEW_PASSWORD;
            this.createCurrentPasswordTab();
        } else {
            this.displayMode = DisplayMode.NEW_PASSWORD_ONLY;
        }
        this.createNewPasswordTab();
        this.addListeners();
        PasswordDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createCurrentPasswordTab() {
        this.currentPasswordComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout currentLayout = new GridLayout(2, false);
        currentLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        currentLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        currentLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        currentLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.currentPasswordComposite.setLayout((Layout)currentLayout);
        this.currentPasswordComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        BaseWidgetUtils.createLabel((Composite)this.currentPasswordComposite, (String)(Messages.getString("PasswordDialog.CurrentPassword") + ":"), (int)1);
        this.currentPasswordText = BaseWidgetUtils.createReadonlyText((Composite)this.currentPasswordComposite, (String)"", (int)1);
        new Label(this.currentPasswordComposite, 0);
        Composite currentPasswordDetailsComposite = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordComposite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)currentPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.HashMethod"), (int)1);
        this.currentPasswordHashMethodText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailsComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)currentPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.PasswordHex"), (int)1);
        this.currentPasswordValueHexText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailsComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)currentPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.SaltHex"), (int)1);
        this.currentPasswordSaltHexText = BaseWidgetUtils.createLabeledText((Composite)currentPasswordDetailsComposite, (String)"", (int)1);
        this.showCurrentPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)currentPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.ShowCurrentPasswordDetails"), (int)2);
        BaseWidgetUtils.createLabel((Composite)this.currentPasswordComposite, (String)Messages.getString("PasswordDialog.VerifyPassword"), (int)1);
        this.testPasswordText = BaseWidgetUtils.createText((Composite)this.currentPasswordComposite, (String)"", (int)1);
        new Label(this.currentPasswordComposite, 0);
        Composite testPasswordDetailsComposite = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordComposite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)testPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.BindDn"), (int)1);
        this.testBindDnText = BaseWidgetUtils.createLabeledText((Composite)testPasswordDetailsComposite, (String)"", (int)1);
        this.showTestPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)testPasswordDetailsComposite, (String)Messages.getString("PasswordDialog.ShowTestPasswordDetails"), (int)2);
        new Label(this.currentPasswordComposite, 0);
        Composite verifyPasswordButtonsComposite = BaseWidgetUtils.createColumnContainer((Composite)this.currentPasswordComposite, (int)2, (int)1);
        this.verifyPasswordButton = BaseWidgetUtils.createButton((Composite)verifyPasswordButtonsComposite, (String)Messages.getString("PasswordDialog.Verify"), (int)1);
        this.verifyPasswordButton.setEnabled(false);
        this.bindPasswordButton = BaseWidgetUtils.createButton((Composite)verifyPasswordButtonsComposite, (String)Messages.getString("PasswordDialog.Bind"), (int)1);
        this.bindPasswordButton.setEnabled(false);
        this.currentPasswordTab = new TabItem(this.tabFolder, 0);
        this.currentPasswordTab.setText(Messages.getString("PasswordDialog.CurrentPassword"));
        this.currentPasswordTab.setControl((Control)this.currentPasswordComposite);
    }

    private void createNewPasswordTab() {
        this.newPasswordComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayout newLayout = new GridLayout(2, false);
        newLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        newLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        newLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        newLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        this.newPasswordComposite.setLayout((Layout)newLayout);
        BaseWidgetUtils.createLabel((Composite)this.newPasswordComposite, (String)Messages.getString("PasswordDialog.EnterNewPassword"), (int)1);
        this.newPasswordText = BaseWidgetUtils.createText((Composite)this.newPasswordComposite, (String)"", (int)1);
        BaseWidgetUtils.createLabel((Composite)this.newPasswordComposite, (String)Messages.getString("PasswordDialog.SelectHashMethod"), (int)1);
        this.newPasswordHashMethodComboViewer = new ComboViewer(this.newPasswordComposite);
        this.newPasswordHashMethodComboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.newPasswordHashMethodComboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                String hashMethod = PasswordDialog.this.getHashMethodName(element);
                if (!"".equals(hashMethod)) {
                    return hashMethod;
                }
                return super.getText(element);
            }
        });
        this.newPasswordHashMethodComboViewer.setInput((Object)HASH_METHODS);
        this.newPasswordHashMethodComboViewer.getControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        BaseWidgetUtils.createLabel((Composite)this.newPasswordComposite, (String)Messages.getString("PasswordDialog.PasswordPreview"), (int)1);
        this.newPasswordPreviewText = BaseWidgetUtils.createReadonlyText((Composite)this.newPasswordComposite, (String)"", (int)1);
        this.newSaltButton = BaseWidgetUtils.createButton((Composite)this.newPasswordComposite, (String)Messages.getString("PasswordDialog.NewSalt"), (int)1);
        this.newSaltButton.setLayoutData((Object)new GridData());
        this.newSaltButton.setEnabled(false);
        Composite newPasswordPreviewDetailsComposite = BaseWidgetUtils.createColumnContainer((Composite)this.newPasswordComposite, (int)2, (int)1);
        BaseWidgetUtils.createLabel((Composite)newPasswordPreviewDetailsComposite, (String)Messages.getString("PasswordDialog.PasswordHex"), (int)1);
        this.newPasswordPreviewValueHexText = BaseWidgetUtils.createLabeledText((Composite)newPasswordPreviewDetailsComposite, (String)":", (int)1);
        BaseWidgetUtils.createLabel((Composite)newPasswordPreviewDetailsComposite, (String)Messages.getString("PasswordDialog.SaltHex"), (int)1);
        this.newPasswordPreviewSaltHexText = BaseWidgetUtils.createLabeledText((Composite)newPasswordPreviewDetailsComposite, (String)"", (int)1);
        this.showNewPasswordDetailsButton = BaseWidgetUtils.createCheckbox((Composite)newPasswordPreviewDetailsComposite, (String)Messages.getString("PasswordDialog.ShowNewPasswordDetails"), (int)2);
        this.newPasswordTab = new TabItem(this.tabFolder, 0);
        this.newPasswordTab.setText(Messages.getString("PasswordDialog.NewPassword"));
        this.newPasswordTab.setControl((Control)this.newPasswordComposite);
    }

    private void addListeners() {
        if (this.displayMode == DisplayMode.CURRENT_AND_NEW_PASSWORD) {
            this.showCurrentPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            this.testPasswordText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            this.showTestPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    PasswordDialog.this.updateCurrentPasswordGroup();
                }
            });
            this.verifyPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PasswordDialog.this.verifyCurrentPassword();
                }
            });
            this.bindPasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    PasswordDialog.this.bindCurrentPassword();
                }
            });
        }
        this.newPasswordText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        this.newPasswordHashMethodComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        this.newSaltButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
        this.showNewPasswordDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                PasswordDialog.this.updateNewPasswordGroup();
            }
        });
    }

    private void updateCurrentPasswordGroup() {
        if (this.currentPassword != null) {
            this.currentPasswordHashMethodText.setText(this.getCurrentPasswordHashMethodName());
            this.currentPasswordValueHexText.setText(Utils.getNonNullString((Object)this.currentPassword.getHashedPasswordAsHexString()));
            this.currentPasswordSaltHexText.setText(Utils.getNonNullString((Object)this.currentPassword.getSaltAsHexString()));
            this.currentPasswordText.setText(this.currentPassword.toString());
        }
        if (this.showCurrentPasswordDetailsButton.getSelection()) {
            this.currentPasswordText.setEchoChar('\u0000');
            this.currentPasswordValueHexText.setEchoChar('\u0000');
            this.currentPasswordSaltHexText.setEchoChar('\u0000');
        } else {
            this.currentPasswordText.setEchoChar('\u2022');
            this.currentPasswordValueHexText.setEchoChar('\u2022');
            this.currentPasswordSaltHexText.setEchoChar(this.currentPasswordSaltHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
        }
        this.testPasswordText.setEnabled(this.currentPassword != null && this.currentPassword.getHashedPassword() != null && this.currentPassword.toBytes().length > 0);
        this.testBindDnText.setText(this.entry != null ? this.entry.getDn().getName() : Utils.getNonNullString(null));
        if (this.showTestPasswordDetailsButton.getSelection()) {
            this.testPasswordText.setEchoChar('\u0000');
        } else {
            this.testPasswordText.setEchoChar('\u2022');
        }
        this.verifyPasswordButton.setEnabled(this.testPasswordText.isEnabled() && !"".equals(this.testPasswordText.getText()));
        this.bindPasswordButton.setEnabled(this.testPasswordText.isEnabled() && !"".equals(this.testPasswordText.getText()) && this.entry != null && this.entry.getBrowserConnection().getConnection() != null);
        if (this.verifyPasswordButton.isEnabled()) {
            this.getShell().setDefaultButton(this.verifyPasswordButton);
        } else {
            this.getShell().setDefaultButton(this.okButton);
        }
        this.okButton.setEnabled(false);
    }

    private void verifyCurrentPassword() {
        String testPassword = this.testPasswordText.getText();
        if (this.currentPassword != null) {
            if (this.currentPassword.verify(testPassword)) {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("PasswordDialog.PasswordVerification"), this.getShell().getImage(), Messages.getString("PasswordDialog.PasswordVerifiedSuccessfully"), 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            } else {
                MessageDialog dialog = new MessageDialog(this.getShell(), Messages.getString("PasswordDialog.PasswordVerification"), this.getShell().getImage(), Messages.getString("PasswordDialog.PasswordVerificationFailed"), 1, new String[]{IDialogConstants.OK_LABEL}, 0);
                dialog.open();
            }
        }
    }

    private void bindCurrentPassword() {
        if (!"".equals(this.testPasswordText.getText()) && this.entry != null && this.entry.getBrowserConnection().getConnection() != null) {
            Connection connection = (Connection)this.entry.getBrowserConnection().getConnection().clone();
            connection.getConnectionParameter().setName(null);
            connection.getConnectionParameter().setBindPrincipal(this.entry.getDn().getName());
            connection.getConnectionParameter().setBindPassword(this.testPasswordText.getText());
            connection.getConnectionParameter().setAuthMethod(ConnectionParameter.AuthenticationMethod.SIMPLE);
            CheckBindRunnable runnable = new CheckBindRunnable(connection);
            IStatus status = RunnableContextRunner.execute((StudioConnectionRunnableWithProgress)runnable, null, (boolean)true);
            if (status.isOK()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("PasswordDialog.CheckAuthentication"), (String)Messages.getString("PasswordDialog.AuthenticationSuccessful"));
            }
        }
    }

    private void updateNewPasswordGroup() {
        this.newPassword = new Password(this.getSelectedNewPasswordHashMethod(), this.newPasswordText.getText());
        if (!"".equals(this.newPasswordText.getText()) || this.newPassword.getHashMethod() == null) {
            this.newPasswordPreviewValueHexText.setText(Utils.getNonNullString((Object)this.newPassword.getHashedPasswordAsHexString()));
            this.newPasswordPreviewSaltHexText.setText(Utils.getNonNullString((Object)this.newPassword.getSaltAsHexString()));
            this.newPasswordPreviewText.setText(this.newPassword.toString());
            this.newSaltButton.setEnabled(this.newPassword.getSalt() != null);
            this.okButton.setEnabled(true);
            this.getShell().setDefaultButton(this.okButton);
        } else {
            this.newPassword = null;
            this.newPasswordPreviewValueHexText.setText(Utils.getNonNullString(null));
            this.newPasswordPreviewSaltHexText.setText(Utils.getNonNullString(null));
            this.newPasswordPreviewText.setText(Utils.getNonNullString(null));
            this.newSaltButton.setEnabled(false);
            this.okButton.setEnabled(false);
        }
        if (this.showNewPasswordDetailsButton.getSelection()) {
            this.newPasswordText.setEchoChar('\u0000');
            this.newPasswordPreviewText.setEchoChar('\u0000');
            this.newPasswordPreviewValueHexText.setEchoChar('\u0000');
            this.newPasswordPreviewSaltHexText.setEchoChar('\u0000');
        } else {
            this.newPasswordText.setEchoChar('\u2022');
            this.newPasswordPreviewText.setEchoChar(this.newPasswordPreviewText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
            this.newPasswordPreviewValueHexText.setEchoChar(this.newPasswordPreviewValueHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
            this.newPasswordPreviewSaltHexText.setEchoChar(this.newPasswordPreviewSaltHexText.getText().equals(Utils.getNonNullString(null)) ? (char)'\u0000' : '\u2022');
        }
    }

    private void updateTabFolder() {
        if (this.testPasswordText != null && this.newPasswordText != null) {
            if (this.tabFolder.getSelectionIndex() == 0) {
                this.updateCurrentPasswordGroup();
                this.testPasswordText.setFocus();
            } else if (this.tabFolder.getSelectionIndex() == 1) {
                this.updateNewPasswordGroup();
                this.newPasswordText.setFocus();
            }
        }
    }

    private LdapSecurityConstants getSelectedNewPasswordHashMethod() {
        Object selectedObject;
        StructuredSelection selection = (StructuredSelection)this.newPasswordHashMethodComboViewer.getSelection();
        if (!selection.isEmpty() && (selectedObject = selection.getFirstElement()) instanceof LdapSecurityConstants) {
            return (LdapSecurityConstants)selectedObject;
        }
        return null;
    }

    private String getHashMethodName(Object o) {
        if (o instanceof LdapSecurityConstants) {
            LdapSecurityConstants hashMethod = (LdapSecurityConstants)o;
            return hashMethod.getName();
        }
        if (o instanceof String && NO_HASH_METHOD.equals(o)) {
            return BrowserCoreMessages.model__no_hash;
        }
        return null;
    }

    private String getCurrentPasswordHashMethodName() {
        LdapSecurityConstants hashMethod = this.currentPassword.getHashMethod();
        if (hashMethod != null) {
            return Utils.getNonNullString((Object)this.getHashMethodName(hashMethod));
        }
        return Utils.getNonNullString((Object)this.getHashMethodName(NO_HASH_METHOD));
    }

    public byte[] getNewPassword() {
        return this.returnPassword;
    }

    private static enum DisplayMode {
        CURRENT_AND_NEW_PASSWORD,
        NEW_PASSWORD_ONLY;

    }
}

