/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.yikers.com/";
	this.ID = "yikers.com";
	this.caption = "Yikers";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const URL_FLV = "http://media.yikers.com/flv/flash8/yikers_%1.flv";
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>", "</title>");
	// get video id
	var vidoId = copyBetween(url, ".com/video_", ".");
	// get the video url
	result.URL = strFormat(URL_FLV, vidoId);
	// clear and get the final url
	result.URL = cleanUrl(result.URL);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x27,0x50,0x4c,0x54,0x45,0x00,0x25,0x73,0x00,0x4a,0x73,0x62,
		0x62,0x62,0x6e,0x6e,0x6e,0x92,0x92,0x92,0xa0,0xa0,0xa4,0xb6,0xb6,0xb6,0xc0,0xc0,
		0xc0,0xce,0xce,0xce,0xda,0xda,0xda,0xe6,0xe6,0xe6,0xf2,0xf2,0xf2,0xff,0xff,0xff,
		0x6d,0x6c,0xb0,0x2c,0x00,0x00,0x00,0x57,0x49,0x44,0x41,0x54,0x78,0xda,0xad,0xcf,
		0x41,0x0a,0xc0,0x30,0x08,0x05,0xd1,0x49,0xd3,0xa4,0x46,0xbd,0xff,0x79,0x4b,0xbe,
		0xd0,0x45,0xd6,0x75,0xe1,0xe2,0x31,0x20,0x62,0xc7,0x60,0x1e,0x99,0x19,0xa6,0xed,
		0x1b,0xa2,0x03,0x8f,0x2f,0xa0,0x87,0x0a,0x03,0x6e,0x1f,0xe2,0x0d,0x4a,0xae,0xb8,
		0xa0,0xa5,0x09,0x94,0x2c,0x60,0x7a,0x81,0x65,0x83,0x5e,0x41,0x81,0x4f,0x50,0x50,
		0x50,0x89,0x82,0x0f,0x7c,0xe8,0xd0,0x01,0xe3,0x67,0x58,0x7a,0x75,0x09,0x5e,0x64,
		0x58,0x06,0x70,0xe4,0xb6,0x10,0x90,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,
		0x42,0x60,0x82);
}
