/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.4";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.wat.tv/";
	this.ID = "wat.tv";
	this.caption = "Wat.tv";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	const GET_URL_ICONTENT = "http://www.wat.tv/interface/contentv2/%1";
	const URL_FLV = "http://www.wat.tv/get/%1";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "'title" content="', '"');
	// get video id
	var vidId = copyBetween(html, 'id="media" value="', '"');
	// download video info
	var content = http.downloadWebpage(strFormat(GET_URL_ICONTENT, vidId));
	// get video url
	result.URL = strReplace(copyBetween(content, "http:\\/\\/www.wat.tv\\/get\\/", "\""), "\\/", "/");
	result.URL = strFormat(URL_FLV, result.URL);
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x03,0x00,0x00,0x00,0x28,0x2d,0x0f,
		0x53,0x00,0x00,0x00,0x2a,0x50,0x4c,0x54,0x45,0xff,0xff,0xfd,0xff,0xc4,0xf6,0xff,
		0x66,0xe2,0xff,0x86,0xea,0xff,0xec,0xfc,0xff,0x57,0xe2,0xff,0x00,0xcf,0xff,0xad,
		0xef,0xff,0xfd,0xff,0xff,0x2c,0xd5,0xff,0x98,0xec,0xff,0x42,0xdb,0xff,0x76,0xe6,
		0xff,0xd8,0xf6,0x42,0x91,0xbf,0xbc,0x00,0x00,0x00,0x69,0x49,0x44,0x41,0x54,0x78,
		0xda,0x9d,0x8d,0xdb,0x0e,0xc0,0x20,0x08,0x43,0x51,0x2e,0x82,0xba,0xff,0xff,0xdd,
		0x15,0xe2,0xb2,0x3d,0xaf,0x90,0xa6,0x1c,0x9b,0x48,0x3f,0xd4,0x3a,0xcb,0x93,0x85,
		0x7b,0x23,0x35,0x1b,0xc8,0xee,0xb0,0x61,0xa6,0x00,0x01,0x20,0xbd,0x4b,0x81,0x38,
		0x8d,0x69,0xc6,0x07,0xac,0x04,0xbe,0x0f,0x88,0x95,0x8d,0x4d,0x0e,0x57,0x27,0x86,
		0x67,0xcd,0x26,0x12,0x2a,0x33,0x23,0x49,0xd8,0x57,0x42,0xd4,0x8a,0x84,0x96,0x8f,
		0xfc,0xfd,0xda,0xb1,0x58,0x84,0x35,0x76,0xc3,0xe9,0x98,0xaf,0xde,0xf3,0x25,0x10,
		0xd5,0xd6,0xdb,0x0d,0x8b,0x51,0x03,0x7a,0x88,0x11,0x0f,0x52,0x00,0x00,0x00,0x00,
		0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
