/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService() {
	this.version = "1.0.2";
	this.minVersion = "2.0.0a";
	this.author = "crapmaster & Xesc & Technology 2014";
	this.website = "http://www.tube8.com/";
	this.ID = "tube8.com";
	this.caption = "Tube8";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url) {
	// video information
	var result = new VideoDefinition();

	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);

	// get video title
	result.title = copyBetween(html, 'var videotitle="', '";');

	// get the xml url
	var tmpUrl = copyBetween(html, '"video_url":"', '"');

	// get url
	result.URL=cleanUrl(tmpUrl);

	// return the video information
	return result;
}

function searchVideos(keyWord, pageIndex) {
	const URL_SEARCH            = "http://www.tube8.com/search.html?q=%1&page=%2";
	const HTML_SEARCH_START     = '<div class="thumb-wrapper float-left">';
	const HTML_SEARCH_FINISH    = '<h1><span>Our Friends</span></h1>';
	const HTML_SEARCH_SEPARATOR = "</div></div>";

	// replace all spaces for "+"
	keyWord = strReplace(keyWord, " ", "+");

	// init search results object
	var searchResults = new SearchResults();

	// init http object
	var http = new Http();
	var html = http.downloadWebpage(strFormat(URL_SEARCH, keyWord, pageIndex));


	var noResIx = strIndexOf(html, "No Results Found");
	if (noResIx == -1) {

		// get the search summary
		var summary = copyBetween(html, '<div class="title-bar"><h1><span style="float:left;">', '</span>');
		summary = cleanSummary(summary);
		searchResults.setSummary(summary);

		// get results html block
		var htmlResults = copyBetween(html, HTML_SEARCH_START, HTML_SEARCH_FINISH);

		// if we found some results then...
		if (htmlResults != "") {
			var blocks = splitString(htmlResults, HTML_SEARCH_SEPARATOR);
			for (n = 0; n < blocks.length-1; n++)
				parseResultItem(searchResults, blocks[n]);
		}
	}

	// return search results
	return searchResults;
}
function cleanSummary(summary) {
	// remove all "\n"
	summary = strReplace(summary, "\n", "");

	// remove unused tags
	summary = strReplace(summary, "</span>", '');
	summary = strReplace(summary, "<span>", '');
	summary = strReplace(summary, "<em>", '');
	summary = strReplace(summary, "</em>", '');

	// remove &quot;
	summary = strReplace(summary, "&quot;", "");

	// return cleanned summary
	return summary;
}

function parseResultItem(searchResults, html) {
	// vars
	var tmp, videoUrl, imageUrl, title, description, duration, rating;

	// get video url
	tmp = copyBetween(html, '<div id="video_', '<div class="video-cont-wrapper">');
	videoUrl = copyBetween(tmp, '<a href="', '">');


	// get title and image url
	tmp= copyBetween(tmp, '<img ', '/>');
	title = copyBetween(tmp, 'alt="', '"');
	imageUrl = copyBetween(tmp, ' src="', '"');

	// get video description
	description = "";

	// get video duration
	tmp = copyBetween(html, '<div class="video-right-text float-right"><strong>', '</strong></div>');
	duration = convertToSeconds(tmp);

	// get rating
	tmp = copyBetween(html, '<div class="float-left"', '</div>');
	rating = copyBetween(tmp, '>', '%')/10;

	// add to results list
	searchResults.addSearchResult(videoUrl, imageUrl, title, description, duration, rating);
}

function convertToSeconds(text) {
	// how many ":" exists?
	var count = getTokenCount(text, ":");

	// get mins and seconds
	var h = new Number(h = count == 3 ? getToken(tmp2, ":", 0) * 3600 : 0);
	var m = new Number(getToken(text, ":", count - 2) * 60);
	var s = new Number(getToken(text, ":", count - 1));

	// convert h:m:s to seconds
	return h + m + s;
}

function getVideoServiceIcon() {
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x20,0x08,0x06,0x00,0x00,0x00,0x73,0x7a,0x7a,
		0xf4,0x00,0x00,0x00,0x01,0x73,0x52,0x47,0x42,0x00,0xae,0xce,0x1c,0xe9,0x00,0x00,
		0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,0x13,0x01,0x00,
		0x9a,0x9c,0x18,0x00,0x00,0x00,0x07,0x74,0x49,0x4d,0x45,0x07,0xdb,0x0a,0x09,0x0d,
		0x09,0x20,0x61,0xe1,0x19,0xb5,0x00,0x00,0x09,0x6b,0x49,0x44,0x41,0x54,0x58,0xc3,
		0xc5,0x97,0xdb,0x73,0x1b,0x57,0x72,0x87,0xbf,0xb9,0xcf,0x60,0x66,0x70,0x07,0x71,
		0x21,0x71,0x21,0x29,0xc9,0x12,0x2d,0xc9,0x56,0x24,0xdb,0x71,0xaa,0x36,0xff,0x79,
		0xaa,0xb2,0x15,0x57,0x76,0xd7,0xbb,0x4e,0xad,0xe4,0xac,0x45,0x13,0x24,0x48,0x90,
		0x00,0x08,0x10,0xf7,0xcb,0x60,0x30,0x17,0x0c,0xf2,0x30,0x34,0xb5,0x5c,0x6f,0xaa,
		0xf2,0xb0,0x55,0xe9,0x97,0x79,0x39,0xe7,0xf4,0x77,0xba,0xfb,0xfc,0x7a,0x5a,0x88,
		0xfa,0x77,0x3b,0x00,0xf7,0xaa,0x8b,0xbb,0x76,0x90,0x12,0x3a,0x7a,0xb1,0x80,0x96,
		0xcf,0x83,0x21,0x03,0x10,0x09,0x21,0xbe,0xa0,0xa0,0xee,0x02,0xfe,0xd6,0xc4,0x9d,
		0xcc,0xdf,0xb3,0x30,0xf0,0x19,0x5e,0x5c,0x32,0xef,0xf4,0xd0,0x10,0x28,0x56,0x6b,
		0x24,0x72,0x39,0xc8,0xa7,0x10,0x24,0x95,0x9d,0xbb,0x40,0x4c,0xa4,0x04,0x39,0x90,
		0x35,0x14,0x4d,0xc6,0x5d,0x3b,0xcc,0xc6,0x23,0xd2,0xe4,0xd1,0x0c,0x03,0xc1,0x4a,
		0x3c,0x1c,0x26,0xa1,0x62,0x00,0x08,0x0a,0xff,0x57,0x53,0x24,0x15,0x00,0xdf,0xf7,
		0xd0,0x54,0x9d,0x84,0xae,0x3d,0x38,0x07,0x40,0xd5,0x01,0x90,0x01,0x56,0x37,0x7d,
		0x3e,0x9c,0x9d,0x72,0x7b,0x7d,0x4d,0x76,0xaf,0xc8,0x33,0x45,0xe0,0xd0,0x34,0x11,
		0xac,0x04,0xdb,0x68,0xcd,0xc2,0x5f,0xe3,0x6d,0xe3,0xdb,0x6b,0x92,0x82,0xe4,0x45,
		0x78,0x9e,0xfb,0xe0,0x4c,0x47,0x64,0xa7,0x69,0x98,0xb6,0x85,0x24,0xc6,0xe0,0xcb,
		0xbb,0x1b,0x5a,0x17,0xe7,0xf4,0x7e,0xbe,0x22,0x6d,0x25,0xd0,0x2d,0x9b,0xb2,0x69,
		0x41,0xb1,0xf0,0x08,0x54,0x06,0x70,0x02,0x8f,0xe1,0x62,0xc1,0x55,0xaf,0xcb,0x38,
		0xf0,0x30,0xf7,0xcb,0x14,0xa6,0x13,0x74,0x39,0xe2,0x66,0x78,0xcb,0xf5,0xcd,0x35,
		0xc3,0xc5,0x04,0x80,0xa4,0x6c,0x00,0xb0,0x5a,0x6c,0x70,0x16,0x53,0x7c,0x3f,0x40,
		0x55,0x15,0xf6,0x4b,0x7b,0x34,0xea,0x0d,0x0a,0x95,0x32,0x8a,0x2a,0x73,0x37,0x9e,
		0xd0,0x1f,0x0c,0x19,0x0c,0x07,0x6c,0xfd,0x14,0xf3,0xd5,0x82,0xac,0xeb,0xa2,0x6d,
		0xfd,0x4f,0x51,0xf8,0x05,0xc0,0xcc,0xd8,0x64,0x4a,0x7b,0xd8,0xc3,0x41,0x4c,0x3f,
		0x1e,0x73,0xdd,0xbe,0x64,0x37,0xd4,0x68,0x0d,0xfa,0x5c,0x76,0xdb,0x8c,0x47,0xc3,
		0x18,0x40,0x4f,0xa2,0x29,0x22,0xde,0xd2,0xa5,0x33,0x18,0x30,0x1b,0xc4,0x7b,0xca,
		0xc5,0x22,0xc7,0x2f,0x9e,0x53,0x3d,0xaa,0x91,0xb1,0x32,0x04,0xb3,0x29,0xbb,0x70,
		0x8b,0x99,0x4c,0x91,0xca,0x17,0xd0,0x4c,0x3b,0xf6,0xe8,0x86,0x60,0x7d,0x02,0x10,
		0xa2,0xa5,0xb3,0x0b,0xbc,0x90,0x6e,0xb7,0x4d,0xe7,0xec,0x9c,0xc1,0x74,0xc8,0x76,
		0xed,0xe1,0x09,0x3b,0xa6,0xc1,0x86,0xb1,0xe3,0xe0,0x46,0x3e,0x00,0x86,0xae,0xa0,
		0xee,0x14,0x6c,0x55,0x23,0x08,0x02,0xc6,0x83,0x01,0x9d,0x6e,0x97,0xf6,0xe5,0x35,
		0x8e,0xef,0x91,0x2b,0x15,0xa9,0xe4,0xb2,0xec,0xd7,0x0f,0xa9,0x15,0xf2,0xe4,0xec,
		0x24,0xc5,0x4c,0x81,0xfd,0x52,0x91,0x74,0x69,0x8f,0x84,0xac,0x22,0x26,0x4d,0xd4,
		0x6c,0x8e,0xdd,0xd6,0x47,0x94,0x35,0x41,0xc6,0x90,0x51,0xad,0x04,0xf5,0xc4,0x33,
		0x00,0x36,0xef,0xd7,0xfc,0xd8,0xe9,0xd2,0xe9,0xdf,0xb2,0x70,0xd7,0x28,0x59,0x9b,
		0x42,0xa9,0x40,0x2e,0x5f,0xc0,0x4c,0x98,0xa8,0xfe,0xf6,0xbe,0xb8,0xe2,0x9a,0x98,
		0x2f,0x56,0x00,0xdc,0x5e,0xb6,0xb9,0x68,0x5d,0x01,0x50,0x39,0xac,0xf2,0xf5,0xcb,
		0x97,0x7c,0xfb,0xee,0x2b,0x8e,0x6b,0x47,0x14,0xea,0x35,0xac,0x4c,0x96,0xc0,0x0b,
		0x81,0xe0,0xe1,0x95,0x00,0xc8,0xbf,0xe4,0x43,0x34,0x34,0x46,0xd3,0x09,0x3f,0x9e,
		0x9f,0xf1,0x97,0x8f,0x3f,0x31,0xf7,0x7d,0xec,0x6c,0x86,0x4a,0xa9,0x40,0xad,0xd6,
		0x60,0x2f,0x93,0x47,0x4b,0xe8,0x78,0xeb,0x0d,0x81,0xeb,0xe3,0x8f,0xee,0xf0,0x16,
		0x0e,0x6b,0xd7,0x21,0x08,0x03,0x14,0x5d,0x03,0x77,0xc3,0x7c,0xb5,0xc4,0x6f,0xb5,
		0x90,0x37,0xb1,0x83,0x9c,0x9d,0xa4,0x74,0x74,0x8c,0x6d,0x25,0x50,0x0c,0x9f,0x30,
		0x10,0x7f,0x5d,0x84,0x00,0xed,0xd6,0xcf,0xfc,0xf6,0x77,0xdf,0xf1,0xdd,0x7f,0x7c,
		0xc7,0x64,0xb9,0xa0,0x7e,0x58,0xa3,0xda,0xa8,0x53,0x2e,0x56,0x51,0x75,0x83,0x99,
		0xeb,0x60,0x46,0xa0,0x88,0x10,0x04,0x01,0xce,0x72,0x45,0x6f,0x36,0x61,0x34,0x5f,
		0x02,0x90,0x2f,0x97,0x30,0x42,0x0f,0x63,0x66,0x33,0x9f,0x4f,0x38,0xef,0x75,0xd8,
		0xfc,0x67,0x88,0x2c,0x2b,0x24,0xd2,0x69,0xcc,0x3d,0x13,0xdb,0x4a,0xa3,0xe8,0xd6,
		0x63,0x80,0xb5,0xb3,0x66,0xbe,0x9c,0xf3,0xa7,0x3f,0xff,0xc8,0xef,0x7f,0xff,0x3d,
		0x3f,0xb5,0x5a,0xe4,0x32,0x29,0x92,0xf9,0x02,0xc9,0xa4,0xcd,0x78,0xb1,0xe0,0xb4,
		0x79,0xca,0x7c,0xb1,0x22,0x95,0xb4,0xa8,0xee,0x95,0x48,0x27,0x12,0x04,0x92,0x88,
		0xa2,0xa9,0xe8,0x8a,0x82,0x9c,0xd0,0x09,0x83,0x08,0x13,0xf0,0xad,0x2d,0xce,0x46,
		0x63,0x39,0x99,0xd3,0xf2,0x3a,0xd8,0xef,0x3f,0x50,0xdc,0x3f,0x20,0x5f,0xdd,0xe7,
		0xf8,0xc9,0x73,0x72,0xf9,0x5c,0x9c,0x02,0x4d,0x8b,0x01,0x5c,0xd7,0xa5,0xdb,0xeb,
		0xf3,0x5f,0x7f,0xfc,0x13,0x83,0xe1,0x00,0x3b,0x65,0xb3,0x5f,0xaf,0x93,0x4e,0xa5,
		0x59,0x2c,0x96,0x5c,0x74,0x3a,0x34,0x9b,0x4d,0x26,0xf3,0x19,0xd9,0x54,0x9a,0x51,
		0xbd,0x41,0xa3,0x5c,0xc1,0x48,0x9a,0xe4,0xf7,0x0a,0x48,0x8a,0x86,0xa8,0xe9,0xf4,
		0x07,0x7d,0x46,0x1b,0x27,0x3e,0xd4,0xb2,0xd0,0xb7,0x11,0x81,0xe3,0xd2,0x1b,0x8d,
		0x79,0xff,0xe1,0x03,0x95,0x5a,0x1d,0x2d,0x95,0x21,0x91,0xcb,0x62,0x08,0xc2,0xa7,
		0x08,0xf8,0xa1,0x4f,0xfb,0xea,0x82,0x66,0xeb,0x92,0xad,0xa8,0xf0,0xfc,0xcd,0x97,
		0x34,0xca,0x15,0x24,0x43,0xe3,0xa2,0x75,0x49,0xb3,0x7d,0x85,0xb3,0x74,0xb0,0x13,
		0x26,0x41,0x10,0xd0,0x6c,0x5f,0xd1,0x1f,0x8d,0x38,0x3e,0xa8,0xf1,0xec,0xf9,0x13,
		0x9e,0x94,0xca,0x24,0x73,0x39,0x94,0x8f,0x3f,0xb1,0x11,0x76,0xf8,0xf3,0x19,0xc6,
		0x36,0x22,0x32,0x0c,0x82,0xc0,0x67,0x3e,0x9f,0xd0,0xba,0x69,0x73,0x7a,0xde,0xe4,
		0xc9,0xcb,0x13,0x9e,0xf1,0xe2,0x51,0xf6,0x45,0xd7,0xf1,0xe8,0x0f,0x86,0xcc,0x66,
		0x13,0x0e,0x2a,0x15,0xfe,0xe5,0x9b,0x6f,0xf9,0xa7,0xaf,0xde,0xa1,0x2a,0x32,0xfd,
		0xd1,0x88,0xe1,0x60,0x88,0xaa,0xab,0xd4,0xea,0x75,0x0a,0xc5,0x22,0x41,0x10,0xd0,
		0xef,0x0f,0x18,0x2c,0x67,0x88,0x09,0x8b,0xa3,0x27,0x4f,0x79,0xf9,0xf2,0x84,0x4a,
		0x63,0x9f,0x74,0x36,0x8b,0x26,0x2a,0xec,0x54,0x05,0x51,0x8d,0x65,0xdb,0xf7,0x42,
		0xa6,0xe3,0x19,0xd7,0xfd,0x1e,0xc3,0xd1,0x08,0x6f,0x1b,0x3e,0xae,0x81,0xc9,0x7c,
		0xca,0x72,0x11,0x17,0x52,0xa5,0x52,0xe4,0xd9,0xd3,0xcf,0xc8,0x64,0x33,0xf4,0x07,
		0x43,0xb6,0xe1,0x96,0xe9,0x74,0x82,0xef,0x7b,0xa4,0xac,0xe4,0xc3,0x26,0xd3,0x36,
		0xb1,0x4c,0x93,0xbd,0x42,0x81,0x62,0xa5,0x82,0x61,0x5b,0xa4,0xce,0x0b,0xc0,0x47,
		0xbc,0x28,0xc0,0xf7,0x3d,0x44,0x45,0x46,0x51,0x54,0x02,0xdf,0x65,0x38,0x1b,0x73,
		0xdb,0xeb,0x71,0x37,0x1c,0xb2,0x5a,0x3b,0xa4,0x93,0xe9,0x4f,0x00,0xd3,0xc9,0x14,
		0x80,0x74,0x3a,0x4b,0x32,0x93,0x21,0x61,0x18,0x8f,0x08,0x23,0xdf,0xc3,0x01,0xd6,
		0x9e,0x8b,0x6d,0x5a,0x64,0xd3,0x19,0xac,0x54,0x92,0x7a,0xbd,0x41,0x21,0x9f,0xc7,
		0xb4,0x4c,0x36,0xbe,0xf7,0xb0,0x7e,0xbd,0xf1,0x88,0x82,0x30,0x06,0x90,0xc4,0xf8,
		0xd5,0xfb,0x5b,0x9c,0xa5,0xc3,0xda,0x5d,0x13,0x84,0x8f,0x3b,0xaa,0xbc,0xb8,0xd7,
		0xf8,0x74,0x26,0x43,0xc6,0xce,0xc6,0xa2,0x72,0xdb,0xe7,0xf4,0xbc,0xc9,0x70,0x34,
		0xc2,0xd4,0x4d,0xaa,0xcf,0x8e,0x39,0xf9,0xfc,0x04,0x59,0x52,0x98,0x2f,0x16,0xa4,
		0x92,0x49,0xf2,0x85,0x02,0x86,0x6d,0x21,0x2b,0x71,0xa8,0x15,0x55,0x7b,0x0c,0x1e,
		0xc4,0xa1,0xde,0x86,0x8f,0x43,0xae,0xef,0x62,0x1d,0xf8,0xa5,0x10,0x45,0x55,0x33,
		0xd1,0xee,0x37,0x7b,0xbe,0x47,0x7f,0xd0,0xe5,0xfc,0xec,0x8c,0x9f,0x7e,0x3e,0x65,
		0x72,0xdb,0x27,0x93,0x4b,0xf3,0xfa,0xf5,0x17,0x7c,0xf3,0xf6,0x1d,0xd5,0xca,0xfe,
		0xbd,0xfa,0x2d,0x58,0xbb,0xeb,0x47,0x07,0x07,0xf7,0x51,0xd0,0x88,0x1d,0x68,0xe1,
		0x8e,0x60,0x1b,0xc5,0xed,0x5c,0x96,0x49,0x88,0x12,0x66,0x24,0xa1,0xee,0x1e,0xb7,
		0x6d,0x39,0x9b,0x8e,0xf3,0x31,0x9b,0x4e,0xe9,0x9a,0x7d,0xec,0xa4,0xcd,0xe8,0xee,
		0x16,0xf7,0x5e,0x60,0x04,0x55,0xc7,0x90,0x15,0xa2,0x4d,0xc0,0xe8,0xee,0x8e,0xf6,
		0xd5,0x25,0xce,0xd2,0xc1,0x34,0x0d,0x5e,0xbe,0x7a,0x45,0xb9,0x5c,0xc6,0xf7,0x3c,
		0xd6,0x2b,0x07,0xdf,0x71,0x11,0xb6,0x01,0x56,0x78,0x0f,0xb1,0x85,0x40,0x96,0xd1,
		0x22,0x09,0x63,0xb7,0x43,0x5a,0x6f,0xf0,0xa7,0x0b,0xb8,0xd7,0x02,0x00,0xb9,0x5c,
		0x2a,0x63,0x9b,0x0a,0xb3,0xd9,0x84,0xf5,0x6a,0x89,0x2a,0x49,0x00,0x1c,0x54,0x2a,
		0xf1,0x02,0x49,0x64,0x35,0x9d,0xd0,0x3c,0xfb,0xc8,0xe5,0xd9,0x39,0xdd,0x9b,0x0e,
		0x00,0x8e,0xe3,0xb2,0x9a,0x2f,0x58,0x4f,0x66,0x0c,0xbb,0x5d,0x46,0x37,0x5d,0x9c,
		0xc9,0x94,0x70,0xe5,0x13,0xb0,0x45,0x0d,0xee,0xff,0x1f,0x22,0x89,0x94,0xa9,0x61,
		0xc9,0x09,0x58,0x07,0x2c,0x6e,0xc7,0x14,0x0f,0x2a,0x9f,0x00,0x52,0x29,0x9b,0x4c,
		0x7e,0x0f,0x55,0x56,0x18,0x0c,0x47,0x24,0xda,0xd7,0x14,0x0f,0xf6,0xa9,0xd6,0x6b,
		0x14,0x72,0x19,0xd6,0x9b,0x0d,0x8e,0xe3,0xb2,0x9c,0x4c,0x19,0x0c,0x47,0xa4,0xd3,
		0x19,0x0e,0x8b,0x45,0x5e,0x1c,0x36,0x48,0xea,0x0a,0x9d,0xeb,0x1b,0x2e,0x9b,0x67,
		0xf4,0x6e,0xae,0x99,0xdf,0x0d,0x09,0x97,0x73,0x84,0xfb,0x96,0x23,0x3a,0x0e,0x1a,
		0x50,0x4e,0x95,0xa9,0x65,0x0b,0x64,0x24,0x15,0xff,0x6e,0x88,0x73,0xd5,0x65,0xb5,
		0xdc,0xc4,0x00,0x86,0x61,0x50,0x2a,0xee,0x53,0xaf,0xd7,0x18,0x0c,0x47,0x74,0x7a,
		0x3d,0x00,0x9e,0x1e,0x1d,0x52,0xae,0x55,0x99,0xce,0x97,0x4c,0xef,0xee,0xb8,0xf3,
		0x36,0x14,0x0b,0x79,0x0a,0xc5,0x3d,0x3e,0xfb,0xec,0x84,0x46,0xa3,0xca,0x7a,0xe1,
		0x70,0x75,0x75,0xca,0xe9,0xfb,0x1f,0xb8,0xed,0x74,0xd8,0x2e,0x97,0x48,0x5e,0x84,
		0x13,0x7c,0xaa,0x8f,0x52,0x2a,0xcb,0x8b,0xc3,0x67,0x7c,0x79,0xf2,0x92,0x46,0xa3,
		0x8a,0x86,0x42,0x78,0x39,0x64,0x3a,0x8e,0xff,0x23,0x64,0x5d,0x94,0x38,0x3a,0x6e,
		0xf0,0xe6,0xcb,0xd7,0x34,0x2f,0x2e,0xf8,0xcb,0xc5,0x05,0x93,0xc9,0xdd,0x03,0x44,
		0x26,0x65,0x93,0x10,0x44,0x52,0x49,0x0b,0x51,0x4f,0xb0,0x97,0xcf,0x92,0xc9,0x65,
		0x18,0x4f,0x66,0xf4,0xae,0xdb,0xbc,0xff,0xf0,0x81,0xeb,0x66,0x93,0xf9,0x6c,0x4e,
		0xb4,0xba,0x2f,0xc4,0x5d,0x84,0x27,0x88,0xe8,0x92,0x4c,0xa3,0x52,0xe7,0xed,0x9b,
		0xb7,0x7c,0xfd,0xed,0xb7,0x94,0x0f,0xaa,0x28,0x5e,0x04,0x4b,0x87,0xf0,0xbe,0xc6,
		0x64,0x41,0x15,0x28,0x15,0x72,0xbc,0x7e,0xfd,0x05,0xff,0xfd,0xf1,0x94,0xce,0x6d,
		0x8f,0x4e,0xb7,0x8b,0x1f,0xfe,0xc0,0x7a,0xb5,0xe4,0xd9,0xc1,0x01,0xb9,0x5c,0x1e,
		0xcb,0xb0,0xb0,0xcd,0x14,0x3b,0xe0,0xe6,0xec,0x92,0xe6,0xd5,0x05,0xad,0x66,0x8b,
		0x76,0xbb,0xcd,0x72,0x34,0x8e,0x9f,0x98,0x24,0xa3,0x6f,0x77,0x84,0x40,0x1a,0x89,
		0x7a,0xf1,0x80,0x37,0xaf,0x4e,0x78,0xf7,0xf5,0x3b,0x4e,0xde,0xbe,0x45,0xdd,0xb3,
		0x11,0x06,0x1b,0xa2,0x6e,0x0f,0x4d,0x55,0x3f,0x09,0xb2,0x20,0xa9,0x1c,0x3f,0x79,
		0xce,0x6f,0x7e,0xf3,0xaf,0xcc,0xe7,0x0b,0xa2,0x6d,0x48,0xaf,0x3f,0xe0,0xc7,0xe9,
		0x82,0x71,0xaf,0x47,0x31,0x93,0x23,0x63,0x5a,0x24,0x4c,0x93,0x4d,0x14,0x30,0x1e,
		0x4d,0x68,0x75,0xae,0x19,0xf5,0xef,0x58,0x2c,0x17,0x38,0xbf,0x28,0x64,0xe8,0xb3,
		0x03,0x0c,0x41,0x61,0xbf,0x50,0xe4,0xf3,0x17,0x27,0x7c,0xf1,0xf6,0x0d,0x4f,0x5f,
		0xbd,0x40,0xaf,0xe7,0xe3,0x45,0x96,0x8c,0xa4,0x28,0xbf,0xfe,0x1f,0xc8,0xe5,0x73,
		0x7c,0xfd,0xcf,0xef,0x50,0x0c,0x95,0x54,0x2a,0xc9,0x0f,0xdf,0x7f,0xcf,0x75,0xb3,
		0x45,0xfb,0xe2,0x92,0xbb,0x6d,0xeb,0x93,0x56,0x88,0x3b,0xdc,0x20,0x00,0x77,0xc3,
		0xe6,0x5e,0xd7,0x4d,0x40,0xbd,0x0f,0x79,0x56,0x36,0x28,0xe4,0x72,0x3c,0x3d,0x3a,
		0xe6,0xe5,0xe7,0x27,0x94,0x2b,0xf5,0xb8,0x27,0x8c,0x17,0xb1,0xf0,0xcc,0x36,0x08,
		0x41,0x80,0xac,0x48,0x8f,0x01,0x00,0x2a,0xa5,0x3d,0x64,0xf1,0x2b,0x92,0x29,0x93,
		0xc3,0x83,0x03,0x3e,0xfc,0xe1,0x8f,0x9c,0x7f,0x3c,0xa5,0xd3,0x6a,0xd3,0x9f,0x4f,
		0xf0,0x77,0xd1,0xc3,0x5a,0x55,0x10,0x1f,0xbe,0x99,0x4c,0x86,0x42,0x36,0x4d,0x31,
		0x95,0xa5,0x94,0xce,0x91,0xcf,0x17,0xa8,0x96,0xca,0x94,0xf6,0xf7,0xd9,0x44,0x2e,
		0xcd,0xb3,0x53,0xe4,0xcb,0x2b,0x74,0x5d,0x21,0x27,0x18,0x14,0x15,0x1d,0xdd,0x32,
		0x1e,0x03,0xec,0xb6,0x3e,0x08,0xb0,0xb7,0x97,0x22,0x9f,0xfe,0x86,0xc3,0xd2,0x01,
		0x4f,0x6b,0x0d,0xfe,0xf0,0x6f,0xff,0xce,0x9f,0x35,0x83,0xee,0xf5,0x0d,0xeb,0x20,
		0xc4,0xb0,0x2c,0x14,0x5d,0x7a,0x00,0xd1,0x74,0x83,0x72,0xa5,0xcc,0x51,0xa3,0x41,
		0xed,0xa0,0x4a,0x29,0x99,0x23,0x67,0x67,0x90,0xcd,0x38,0xcc,0x2b,0xdf,0xa3,0x3f,
		0xec,0x13,0xf9,0x21,0xb6,0x6e,0x20,0xe7,0xf6,0xc9,0x57,0x4d,0xf4,0x7c,0xf2,0xd7,
		0x11,0x00,0x90,0xc4,0x04,0x92,0x0e,0xb5,0xfa,0x21,0xcc,0x1c,0x96,0xbd,0x01,0xe1,
		0x6c,0x45,0x29,0x9d,0xc3,0xca,0xa6,0x29,0xd6,0x2a,0x18,0xa2,0x82,0x1b,0xc5,0x42,
		0x93,0x4c,0xa5,0xc9,0x97,0x8a,0x94,0xab,0x15,0x0a,0xd9,0x02,0x49,0x3d,0x89,0x9a,
		0x88,0x9d,0x6f,0x3c,0x97,0x95,0xb3,0x26,0xb9,0x9c,0x11,0x06,0x01,0x09,0x41,0x27,
		0x59,0xc8,0x22,0x66,0xb3,0x58,0x9e,0xf5,0x18,0x40,0x90,0x54,0xc4,0xed,0x63,0x18,
		0x3b,0x99,0xa4,0x56,0x2a,0x13,0xbd,0x7a,0x01,0xbc,0xa0,0xf1,0xe4,0x29,0x8d,0x27,
		0x47,0xec,0x74,0x85,0x95,0xb3,0x46,0x93,0x15,0xec,0x64,0x12,0x2b,0x9b,0x41,0x31,
		0x94,0x87,0x71,0xeb,0x6f,0x2d,0x12,0x42,0x22,0x3f,0x42,0xde,0x45,0xa0,0xea,0x08,
		0x92,0x8a,0x3f,0x19,0xdf,0xcf,0x05,0xa1,0xb7,0xfb,0xeb,0x49,0xe5,0xaf,0x6d,0xe7,
		0x2e,0x98,0xfe,0x7c,0xc1,0x6c,0x30,0x44,0x53,0x35,0x2a,0xf5,0x1a,0xc2,0xd1,0x21,
		0xff,0x08,0x7b,0x98,0x0b,0x22,0x21,0x44,0x42,0xc5,0x75,0xe3,0xb6,0xac,0x6a,0x3a,
		0xe2,0x4e,0x26,0x12,0x42,0xd6,0xcb,0x79,0x9c,0x67,0x55,0x43,0x50,0x55,0xd6,0x1b,
		0x8f,0x84,0xbb,0xf8,0xfb,0x37,0xf5,0x37,0xec,0xd0,0x10,0x54,0x81,0x9d,0xbf,0x43,
		0x20,0x16,0xa5,0x48,0x93,0x1f,0x26,0xe8,0x48,0x08,0x11,0x77,0x32,0xff,0xdb,0x85,
		0xff,0x5f,0xec,0x7f,0x00,0xd3,0x4d,0x34,0x3e,0x07,0x28,0x7c,0x23,0x00,0x00,0x00,
		0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
