/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "crapmaster & Xesc & Technology 2014";
	this.website = "http://www.totallycrap.com";
	this.ID = "totallycrap.com";
	this.caption = "Totally Crap";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();

	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);

	// get video title
	result.title = copyBetween(html, '<div class="hdr"><h2>', '</h2></div>');

	// get the config object url
	var configUrl = copyBetween(html, "so.addVariable('config','", "');");

	// Load the Config Object URL
	var config= http.downloadWebpage(configUrl);

	// get video url
	var videoUrl = copyBetween(config, '<file>', '</file>');

	result.URL=cleanUrl(videoUrl);

	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x00,0x01,0x73,0x52,0x47,0x42,0x00,0xae,0xce,0x1c,0xe9,0x00,0x00,
		0x00,0x06,0x62,0x4b,0x47,0x44,0x00,0xff,0x00,0xff,0x00,0xff,0xa0,0xbd,0xa7,0x93,
		0x00,0x00,0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,0x13,
		0x01,0x00,0x9a,0x9c,0x18,0x00,0x00,0x00,0x07,0x74,0x49,0x4d,0x45,0x07,0xdb,0x07,
		0x0a,0x13,0x31,0x30,0x97,0x54,0x50,0x0f,0x00,0x00,0x02,0xab,0x49,0x44,0x41,0x54,
		0x38,0xcb,0x75,0x93,0x5d,0x48,0x53,0x61,0x18,0xc7,0x9f,0xf3,0xb5,0xe3,0x39,0x3a,
		0x6d,0x3a,0x77,0xa6,0x9b,0x8b,0x30,0xc9,0x76,0xd1,0x07,0xf3,0x2b,0x53,0xf0,0x4e,
		0xeb,0xa2,0x28,0xeb,0x4a,0xd4,0x8a,0x92,0x2e,0xc3,0x30,0xc8,0xa8,0xc8,0x8b,0x40,
		0x30,0xcb,0xd0,0x8c,0x8a,0x20,0x48,0xea,0xa2,0x40,0x21,0x95,0x42,0xa8,0xf0,0x42,
		0x27,0xda,0x32,0x87,0x61,0x46,0x6a,0x5b,0x9d,0xb3,0xe9,0x96,0xed,0xe3,0x9c,0x79,
		0x76,0xce,0xde,0xae,0x92,0x6d,0xba,0x3f,0xbc,0x17,0x2f,0xcf,0xff,0xfd,0xf1,0x7f,
		0x78,0x9e,0x17,0x43,0x08,0x41,0xbc,0x62,0xaa,0x0a,0xee,0xb7,0xef,0x8e,0x7e,0xe9,
		0xec,0xbc,0xa9,0x88,0x12,0x9b,0x61,0x29,0x58,0xde,0x61,0xb5,0xce,0xed,0xb9,0x70,
		0xbe,0x5f,0x6b,0xb1,0xb8,0x20,0x49,0x58,0x32,0x60,0x79,0x70,0xe8,0xe4,0x74,0xfb,
		0xb5,0xae,0x98,0xa2,0xd0,0xf1,0x5c,0x73,0x5d,0xed,0x70,0xc5,0xdd,0xee,0x8b,0x38,
		0x41,0x24,0xf8,0xf1,0xf8,0x8b,0x28,0x08,0x9c,0xb3,0xa7,0xe7,0x4a,0xd2,0x63,0x00,
		0x00,0x7c,0xd5,0x3e,0x55,0x29,0x79,0x3c,0xc6,0xe4,0x04,0x9b,0x00,0x39,0x18,0x64,
		0x3d,0x13,0x13,0x87,0xa3,0x81,0xa0,0x16,0xb6,0x51,0x34,0x1c,0x4e,0xff,0x35,0x36,
		0x76,0x64,0x7d,0x61,0xa1,0x78,0x4b,0x0b,0x21,0xb7,0x3b,0x7f,0xae,0xeb,0x4e,0xbb,
		0xef,0x93,0xa3,0x04,0xa7,0x35,0x72,0x68,0xe5,0x67,0x61,0x32,0x40,0x6f,0xb3,0x4d,
		0x86,0x5d,0xae,0x02,0x8c,0xc0,0x51,0x61,0x43,0xc3,0xb3,0xa2,0xe6,0xa6,0xc7,0x24,
		0x4d,0x47,0x71,0x51,0x10,0xb8,0xe9,0xeb,0x37,0xba,0x5c,0x23,0xa3,0x27,0x44,0xaf,
		0x37,0x9f,0x35,0xe6,0x09,0xdb,0x25,0xc0,0x35,0x54,0x34,0xe2,0xf7,0x1b,0x44,0x5e,
		0x30,0xcf,0xf7,0xf6,0xb6,0x3a,0x6e,0x75,0xdc,0x96,0x83,0x41,0x96,0xa8,0xd7,0x66,
		0x5e,0x75,0xbd,0x19,0x39,0x06,0x18,0x60,0x80,0x10,0x9e,0xc6,0x19,0x78,0x91,0x17,
		0xf2,0x31,0x00,0x04,0x00,0x18,0x91,0x46,0x4b,0x18,0x60,0xa0,0xc9,0xd6,0xf9,0xc4,
		0xdf,0xbc,0x09,0x03,0x40,0x31,0x45,0x25,0xff,0x7e,0x5b,0xdc,0xab,0x4a,0x12,0x43,
		0x74,0x0f,0x0c,0xcc,0x2b,0xe1,0x50,0xa6,0xc8,0x0b,0x46,0x35,0x12,0x49,0xd7,0x59,
		0xad,0x73,0x04,0x49,0xa9,0x8a,0x18,0xca,0x40,0x8a,0x4a,0x31,0xfa,0x5c,0x0f,0x60,
		0x18,0xe0,0x14,0x25,0x6f,0xf8,0xfd,0x7a,0x1c,0xc7,0x55,0xed,0x4e,0xcb,0x72,0x71,
		0x4b,0x4b,0x5f,0x51,0x53,0xe3,0xd3,0xcd,0x31,0x7a,0xed,0x53,0xe5,0xbe,0xd9,0x59,
		0x1b,0xc4,0x62,0x98,0xb4,0xba,0x6a,0x88,0x78,0xbc,0x9c,0xb4,0xe6,0x35,0x18,0xab,
		0xaa,0x3f,0x92,0x2c,0x1b,0x96,0x03,0x01,0x2d,0xa0,0x18,0x41,0x32,0xac,0x54,0x74,
		0xf6,0xcc,0x43,0x92,0xa6,0x55,0x00,0x00,0x40,0x08,0x6d,0x1e,0x55,0x51,0xc0,0xe7,
		0x74,0x5a,0x15,0x59,0x26,0xe4,0x50,0x88,0xe1,0xc7,0xc7,0xab,0xa2,0x91,0x08,0xa1,
		0x2a,0x0a,0x2c,0x3e,0x1f,0x68,0x5a,0x5f,0xfc,0xbe,0x3b,0xde,0x8f,0x10,0x02,0x32,
		0x61,0x0b,0x65,0x59,0xe3,0x1a,0x19,0x3d,0xce,0xbf,0xff,0x20,0x22,0x45,0xa1,0xd6,
		0x66,0x66,0x4a,0xb2,0xed,0xf6,0x43,0x74,0x4e,0x8e,0xff,0x6b,0x5f,0xff,0xa5,0xca,
		0x07,0xbd,0xe7,0x00,0x12,0x07,0x94,0x00,0x20,0x19,0x46,0xce,0xd9,0xbf,0xcf,0xe1,
		0xbc,0x77,0xbf,0x0d,0x00,0xa0,0xfa,0xc9,0xa3,0x86,0xc9,0xd6,0xcb,0xfd,0xc1,0xa5,
		0xa5,0x42,0x2a,0x53,0x1b,0x60,0x38,0x4e,0x48,0xb9,0x48,0xff,0x95,0x5b,0x5a,0x3a,
		0xb1,0xeb,0x54,0xfd,0x4b,0x5c,0x43,0x6d,0x68,0xb2,0xb2,0xfe,0xe8,0x0f,0x1e,0x98,
		0x66,0x39,0x4e,0xb0,0x75,0x74,0xb4,0xa5,0x9b,0x4c,0x5b,0xfe,0x02,0x24,0xf7,0x84,
		0x10,0x82,0xc0,0xca,0x8a,0x79,0xb0,0xb4,0xfc,0xf3,0xfb,0xc6,0xe6,0x17,0x43,0x15,
		0x95,0x8e,0x1f,0xaf,0x5e,0x9f,0xde,0xce,0x87,0x10,0xda,0x9a,0x00,0x00,0x40,0x6b,
		0xb1,0xb8,0x73,0xcb,0xca,0x26,0x25,0x41,0x30,0x69,0x74,0x3a,0x7f,0x5e,0x4d,0xcd,
		0x18,0xa4,0x10,0x99,0xaa,0x60,0xae,0xab,0x1d,0x36,0xd7,0xd5,0x0e,0x2b,0x92,0xc8,
		0x10,0x69,0xb4,0x98,0xca,0xf7,0x0f,0x25,0x24,0x5f,0x4a,0xd5,0x82,0x43,0x48,0x00,
		0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}