/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.1";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2014";
	this.website = "http://www.shredordie.com/";
	this.ID = "shredordie.com";
	this.caption = "Shred or Die";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// init result
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// get video title
	result.title = copyBetween(html, "<title>", "</title>");
	result.title = strReplace(result.title, "- Shred or Die", "");
	// get video url
	result.URL = copyBetween(html, "file=", "&");
	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x02,0xa0,0x49,0x44,0x41,0x54,0x78,0xda,0x85,0x93,0xef,0x4b,0x53,
		0x51,0x1c,0xc6,0xcf,0x3f,0x52,0xfe,0x40,0x0b,0xe6,0x36,0x9d,0xbe,0x09,0x13,0x4d,
		0xa7,0x85,0xd9,0x94,0x92,0xa5,0x5b,0x5a,0xa4,0xd3,0xb2,0x7c,0xa5,0x2f,0x2a,0x62,
		0xa8,0x51,0xa9,0x94,0xba,0x98,0xa5,0x16,0x62,0x14,0x06,0x06,0xf5,0x52,0xe8,0x55,
		0x81,0x21,0xee,0xde,0xf9,0x63,0x73,0x77,0x9b,0x6b,0xa4,0xee,0x7a,0x27,0x69,0xa4,
		0x2b,0xfb,0x21,0x09,0x4f,0xe7,0x7e,0xe9,0x82,0x42,0xd8,0x03,0x87,0x73,0xb8,0xf7,
		0x9c,0xe7,0x7c,0xce,0xf7,0x3c,0x87,0x6d,0xaf,0x2b,0x50,0x9e,0xbb,0x11,0x1f,0x7d,
		0x84,0xe8,0x95,0x16,0x2c,0x9c,0xbf,0x8c,0x70,0x8d,0x03,0x8b,0xd7,0xdb,0xb1,0xe1,
		0x7d,0x87,0xe0,0xe9,0x73,0x98,0x3b,0x62,0xc6,0xb4,0x31,0x17,0x8b,0x3d,0x37,0xb1,
		0x50,0xdb,0x88,0x1f,0xb1,0x08,0x56,0x86,0xef,0xe3,0x9b,0x24,0x80,0x2d,0xf5,0x39,
		0x21,0x1c,0xcc,0x50,0x1b,0x4d,0xd4,0xc6,0xa1,0x9a,0x06,0x84,0xec,0x0e,0x1a,0x8b,
		0x29,0x06,0xea,0xb5,0xf6,0x69,0xfc,0x05,0xbc,0x87,0xb2,0x21,0x3f,0xe9,0x06,0x93,
		0x07,0xee,0xc2,0xa3,0xfe,0x48,0x36,0x70,0x83,0x62,0x28,0xee,0x21,0x6c,0xcd,0x4b,
		0xd8,0xad,0xc4,0xfb,0x29,0xc8,0x5d,0x7d,0x98,0x4a,0xd2,0x41,0x48,0xd2,0x63,0x26,
		0x2b,0x0f,0x33,0xa6,0x3c,0x04,0x2b,0xec,0x60,0xa1,0xb3,0x17,0xd4,0x8f,0xdc,0x44,
		0x87,0xf8,0xc0,0x30,0xf6,0xd3,0xda,0xd8,0x28,0xc4,0x54,0xa2,0xc1,0x6c,0x4e,0x01,
		0x96,0x9c,0x77,0xb8,0x81,0xad,0x0e,0x62,0x9a,0x89,0x4c,0x34,0xfd,0xde,0x4c,0x40,
		0xbe,0xe7,0xe2,0xbb,0xf6,0x22,0x3e,0xf8,0x10,0xbf,0x94,0x15,0x68,0x12,0x75,0x59,
		0x9c,0x36,0x83,0x1b,0x19,0x11,0xae,0xae,0x03,0x0b,0x56,0xd6,0xc2,0x73,0x40,0xc7,
		0xb1,0x8e,0x42,0xd3,0xea,0xe0,0x30,0xbc,0xa6,0x6c,0x78,0x52,0xf5,0xd4,0x4b,0xd5,
		0x95,0xd0,0x14,0x71,0x34,0x41,0x4c,0xcf,0x24,0x0a,0x79,0xa8,0x13,0x2c,0xda,0xd6,
		0x4c,0xf8,0xbc,0x06,0x7b,0x08,0x56,0x47,0x46,0x10,0x6d,0x6e,0x85,0x54,0x69,0xe3,
		0x84,0x06,0xfc,0x94,0xa3,0x50,0xfa,0xfb,0x31,0x7b,0xac,0x10,0xc2,0xdf,0x63,0x28,
		0xcf,0x5c,0x60,0xcb,0xee,0x0e,0xd0,0x99,0xb2,0xf3,0x11,0x1f,0xfa,0x77,0x0d,0x76,
		0xb8,0xe1,0xfa,0xab,0xd7,0x90,0xac,0x36,0xcc,0x15,0x98,0x55,0x62,0x6a,0x91,0x1b,
		0x97,0xc0,0xa4,0x32,0x2b,0x19,0xcc,0x17,0x59,0x20,0xa4,0xe8,0x29,0x0b,0x5f,0xc6,
		0xdf,0x60,0x27,0x91,0xc0,0x5e,0x11,0x19,0x37,0xb1,0xc3,0x93,0xac,0xa7,0x35,0x91,
		0x6b,0x0d,0x60,0xb1,0xfe,0x5b,0xbc,0x20,0x99,0x08,0xdb,0xea,0xe9,0xba,0x12,0x13,
		0x93,0x1c,0x51,0x8f,0xe9,0x9c,0x1c,0x42,0x0d,0xdb,0x1d,0x54,0x4c,0x4d,0x2b,0xbd,
		0x6e,0x88,0x87,0x4d,0x64,0x10,0xe3,0xf4,0x6c,0xc3,0xfb,0x16,0x62,0xee,0x71,0x48,
		0xe5,0x36,0x68,0x52,0x17,0x78,0x8d,0x26,0x35,0x40,0x54,0x1f,0x95,0x52,0x93,0xdc,
		0xf3,0x00,0x42,0xba,0x11,0x44,0x6d,0x2e,0x07,0x53,0x23,0x29,0xa6,0x91,0x23,0x9d,
		0xf5,0x7f,0x5a,0x6a,0xe3,0xc4,0xe9,0x06,0x32,0x9f,0x2f,0xae,0x00,0x0b,0x55,0x5d,
		0x54,0x17,0x53,0x0e,0x62,0x9d,0x3d,0xd8,0x4f,0x3b,0x5f,0x13,0xf0,0xe5,0x17,0x51,
		0x0e,0xe6,0x72,0x4b,0xa0,0xa6,0x98,0x29,0x4f,0x5d,0xe4,0xc6,0xf3,0xa0,0x3e,0x1c,
		0x4a,0xe3,0xf7,0x40,0x08,0xbb,0xb5,0xe5,0x97,0xb0,0x36,0xfa,0x12,0xfe,0x82,0x52,
		0xf8,0x0a,0xcb,0xe0,0x2b,0xb2,0xd0,0x86,0x9b,0xbe,0x49,0x6e,0x30,0xd2,0x0b,0x81,
		0x1b,0x7c,0xec,0x76,0x21,0x60,0xab,0x27,0x9a,0x19,0xfe,0xf2,0x02,0x27,0xce,0xd0,
		0xf9,0xb5,0x07,0xc4,0xaf,0x8d,0xfa,0x60,0x4d,0x23,0x42,0x4d,0xad,0xb4,0xa9,0xfc,
		0xb8,0x1b,0x6c,0xfb,0x73,0x1c,0xd1,0xdb,0x2d,0x88,0x8f,0x0d,0x42,0xe2,0x06,0x7e,
		0xb3,0x85,0x63,0x96,0xe2,0x83,0xf3,0x2a,0xfc,0x25,0x15,0x54,0xa8,0xc0,0x29,0x2b,
		0x24,0x4b,0x15,0x02,0x27,0xad,0x7c,0xde,0x00,0x96,0x3b,0xba,0xb0,0xec,0x6e,0xc7,
		0xe6,0xec,0x04,0xfe,0x00,0x34,0xd2,0xe4,0x9a,0xca,0xac,0xe1,0x11,0x00,0x00,0x00,
		0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}
