/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2014 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "crapmaster & Xesc & Technology 2014";
	this.website = "http://www.newsfilter.org";
	this.ID = "newsfilter.org";
	this.caption = "Newsfilter";
	this.adultContent = true;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// video information
	var result = new VideoDefinition();

	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);

	// get video title
	result.title = copyBetween(html, '<h1><span style="font-size:13px;text-align:center;">', '</span></h1>');

	// get the video  url
	var videoUrl = copyBetween(html, "so.addParam('flashvars','&file=", "&streamer=lighttpd&autostart=true');");

	result.URL=cleanUrl(videoUrl);

	// return the video information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x0b,0x08,0x02,0x00,0x00,0x00,0xf9,0x80,0x9a,
		0x6e,0x00,0x00,0x00,0x01,0x73,0x52,0x47,0x42,0x00,0xae,0xce,0x1c,0xe9,0x00,0x00,
		0x00,0x09,0x70,0x48,0x59,0x73,0x00,0x00,0x0b,0x13,0x00,0x00,0x0b,0x13,0x01,0x00,
		0x9a,0x9c,0x18,0x00,0x00,0x00,0x07,0x74,0x49,0x4d,0x45,0x07,0xdb,0x08,0x0c,0x07,
		0x0e,0x2d,0x10,0x98,0xd5,0x4b,0x00,0x00,0x01,0xb0,0x49,0x44,0x41,0x54,0x28,0xcf,
		0x7d,0xd1,0xbf,0x6e,0xda,0x40,0x00,0x80,0xf1,0xfb,0xe3,0x3b,0xab,0xa0,0xa4,0x80,
		0x2a,0x95,0x58,0x76,0x0c,0x05,0x2b,0x1d,0x22,0xca,0xe0,0x8a,0x92,0x0e,0x19,0x10,
		0x2b,0x53,0x86,0x0e,0xbc,0x04,0xcf,0x91,0x2c,0x2c,0xed,0xc4,0xd0,0x88,0x85,0x05,
		0xa9,0x52,0xb6,0x74,0x89,0xd4,0x92,0xad,0x28,0xb0,0xe1,0xca,0xa9,0x50,0x88,0x54,
		0xa0,0xb8,0x76,0x4d,0x9c,0x3b,0x9b,0x5c,0x86,0x28,0x03,0x95,0xda,0xdf,0x1b,0x7c,
		0xfa,0x60,0xd1,0xc8,0x31,0x22,0x87,0x9c,0x83,0xff,0x82,0x10,0x4a,0x92,0x14,0x45,
		0x11,0x12,0x77,0xa2,0x56,0xab,0x61,0x8c,0x3d,0xcf,0xf3,0xff,0xc1,0x75,0x5d,0x5d,
		0xd7,0x4b,0xa5,0x52,0x10,0x04,0x40,0x4b,0x25,0x0f,0x0f,0x8f,0x3a,0x9d,0x8e,0xa2,
		0x28,0x00,0x00,0x59,0x96,0xe9,0x3a,0x00,0x40,0xb9,0x5c,0xee,0xf5,0x7a,0xf5,0x7a,
		0x9d,0x52,0x8a,0x84,0x10,0xa7,0x9f,0x4f,0x4d,0xd3,0xec,0x76,0xbb,0x95,0x4a,0x85,
		0x31,0x06,0x11,0x92,0x62,0x31,0x24,0xcb,0x10,0x42,0x00,0x40,0xa3,0xd1,0x68,0xb7,
		0xdb,0xae,0xeb,0x0e,0x06,0x03,0x42,0x88,0xb4,0xb9,0xb1,0x11,0x45,0xd1,0x64,0x32,
		0x59,0xad,0x56,0xad,0x56,0xeb,0xe3,0xf1,0xf1,0xb7,0xf3,0xf3,0x9d,0xf9,0x3c,0xc2,
		0xf8,0xbb,0xa2,0xbc,0x3b,0x38,0x28,0x14,0x0a,0xb6,0x6d,0x33,0xc6,0x18,0x63,0xa9,
		0x54,0x0a,0xbf,0xd0,0xd4,0x85,0xbf,0x74,0x1c,0xa7,0x5a,0xad,0x8e,0xc7,0x63,0xcf,
		0x75,0x8b,0xde,0x1f,0xf3,0xeb,0x97,0xbd,0xbd,0xb7,0x9b,0xd9,0x0c,0x51,0x94,0xad,
		0x74,0xda,0xf7,0xfd,0x66,0xb3,0xb9,0x5c,0x2e,0xe3,0xf1,0x38,0x36,0x74,0x1d,0x3f,
		0x89,0xb1,0xdb,0x5b,0xc6,0x18,0xe3,0xfc,0x97,0x65,0x65,0x4c,0x33,0xd8,0xdf,0x77,
		0xf2,0xf9,0xfe,0xd9,0x19,0x4d,0x26,0x2f,0xaf,0xae,0xfa,0xfd,0xfe,0x68,0x34,0x7a,
		0xc8,0xc3,0x39,0x4d,0x15,0x84,0x72,0xc6,0x86,0xc3,0xa1,0xb3,0x58,0xbc,0x7e,0x55,
		0x4c,0x5c,0x5c,0x64,0x0c,0x63,0xf6,0xe1,0xbd,0xf2,0x34,0xf1,0x5b,0x55,0x3f,0x9d,
		0x9c,0x58,0x96,0x45,0x08,0x41,0x08,0x21,0x84,0xf0,0xf6,0xd6,0xf3,0x10,0x22,0x20,
		0x04,0x42,0x88,0x73,0xce,0x24,0xbc,0xa3,0x69,0xea,0xf8,0xc7,0xb3,0x44,0xf2,0x32,
		0x9f,0xeb,0xd9,0xf6,0x7c,0x36,0x03,0x00,0xdc,0x3d,0x82,0x6f,0x76,0x77,0x03,0x49,
		0x82,0x8f,0x83,0x08,0xa5,0x99,0x6c,0xf6,0x65,0x3a,0x3d,0x99,0x4e,0xa7,0x37,0x37,
		0x3f,0xaf,0xaf,0xc3,0x30,0x5c,0x3b,0x58,0x34,0x72,0x3e,0x40,0x70,0xfd,0x2b,0xa5,
		0x94,0x73,0x0e,0x21,0x14,0x42,0xfc,0xb5,0xfc,0x1e,0xd9,0xdd,0xdb,0x17,0x1e,0x83,
		0x79,0x9d,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,0x82);
}