/*
*
* This file is part of xVideoServiceThief,
* an open-source cross-platform Video service download
*
* Copyright (C) 2007 - 2009 Xesc & Technology
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with xVideoServiceThief. If not, see <http://www.gnu.org/licenses/>.
*
* Contact e-mail: Xesc <xeskuu.xvst@gmail.com>
* Program URL   : http://xviservicethief.sourceforge.net/
*
*/

function RegistVideoService()
{
	this.version = "1.0.0";
	this.minVersion = "2.0.0a";
	this.author = "Xesc & Technology 2009";
	this.website = "http://www.elrellano.com/";
	this.ID = "elrellano.com";
	this.caption = "elRellano";
	this.adultContent = false;
	this.musicSite = false;
}

function getVideoInformation(url)
{
	// check if is an audio or video file
	if (url.toString().indexOf("/audios_online/") != -1)		
		return getAudioDefinition(url);
	else // is a video file
		return getVideoDefinition(url);
}

function getVideoDefinition(url)
{
	const URL_XML = "http://www.elrellano.com/video_playlist.php?id=%1&sinespacios=%2";
	// video information
	var result = new VideoDefinition();
	// get id and sinespacios vars	
	var id = copyBetween(url, "/videos_online/", "/");
	var sinespacios = copyBetween(url, strFormat("/%1/", id), ".html");
	// download xml
	var http = new Http();
	var xml = http.downloadWebpage(strFormat(URL_XML, id, sinespacios));
	// get information block
	var track = copyBetween(xml, "<track>", "</track>");
	// get video information
	result.title = copyBetween(track, "<title>", "</title>");
	result.title = strReplace(result.title, "-", " ");
	result.URL = copyBetween(track, "<location>", "</location>");
	// return the video information
	return result;
}

function getAudioDefinition(url)
{
	const URL_MP3 = "http://www.elrellano.com";
	// video information
	var result = new VideoDefinition();
	// download webpage
	var http = new Http();
	var html = http.downloadWebpage(url);
	// configure audio
	result.isAudioFile = true;
	result.extension = ".mp3";
	// get audio information
	result.title = copyBetween(html, "<title>", "-");
	result.URL = URL_MP3 + copyBetween(html, "'file','", "'");
	// return the audio information
	return result;
}

function getVideoServiceIcon()
{
	return new Array(
		0x89,0x50,0x4e,0x47,0x0d,0x0a,0x1a,0x0a,0x00,0x00,0x00,0x0d,0x49,0x48,0x44,0x52,
		0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x10,0x08,0x06,0x00,0x00,0x00,0x1f,0xf3,0xff,
		0x61,0x00,0x00,0x03,0x48,0x49,0x44,0x41,0x54,0x38,0x11,0x75,0xc1,0x59,0x4c,0x13,
		0x76,0x00,0xc0,0xe1,0xff,0xc3,0x1e,0xb6,0x45,0xb3,0x07,0x12,0x8d,0x0f,0x08,0x02,
		0x63,0x62,0x9d,0x17,0x8c,0x59,0x8e,0x0a,0xca,0xd1,0x01,0x65,0x62,0x85,0x96,0x1e,
		0x54,0x60,0x1c,0x16,0x94,0x4b,0x4b,0x81,0x42,0x5a,0xa9,0x29,0x08,0xb2,0x70,0xa4,
		0x5a,0x44,0xe3,0x0a,0xb8,0x30,0x60,0xa8,0x74,0x08,0x73,0x8d,0x91,0x21,0xb2,0x90,
		0x91,0x65,0xf7,0x48,0xd6,0xc9,0x74,0xcb,0x08,0xd9,0x03,0x90,0xed,0x61,0x5b,0xf6,
		0x9b,0x3c,0x98,0x34,0xcb,0xf6,0x7d,0x42,0xf8,0xf1,0x78,0xbc,0x41,0x91,0x89,0x47,
		0x43,0xc5,0xff,0x00,0x36,0xcb,0x55,0xc5,0xa1,0x01,0x01,0x01,0x9b,0xc5,0x7f,0x69,
		0xb5,0x5b,0x7d,0x4e,0x47,0x3d,0x55,0x55,0x35,0x4e,0xf1,0x2f,0x40,0xf0,0xf0,0xf0,
		0xe8,0x4c,0x87,0xed,0x2c,0x16,0xf3,0xd9,0x99,0xdf,0x21,0x48,0xf8,0xfb,0x78,0x76,
		0xae,0xa4,0xa2,0x40,0xb5,0xfe,0xa7,0x6f,0x1c,0x93,0xd1,0x80,0x3e,0xbf,0xf8,0x8a,
		0xf0,0xa3,0xd6,0x17,0x1b,0x1c,0xf5,0xa7,0x59,0x9d,0x77,0x73,0xd5,0xf9,0x36,0xef,
		0x8f,0x4f,0x14,0x08,0x7f,0x75,0x96,0xa6,0x9b,0xcd,0x26,0x23,0x3c,0x99,0x60,0x75,
		0x7e,0x90,0x22,0x83,0x16,0xef,0xbd,0xfb,0xe7,0xc5,0x53,0x16,0xc7,0xc5,0xbd,0x8a,
		0x37,0x52,0x56,0x7c,0x5e,0x17,0xfc,0x3c,0x45,0x47,0x73,0x1d,0x21,0x3b,0x5f,0xcd,
		0x15,0xfe,0xf6,0x45,0x46,0xba,0xcf,0x9b,0xcb,0xf8,0xeb,0xeb,0x11,0xbe,0xb9,0xd3,
		0x8d,0xfe,0x98,0x9c,0x24,0xb9,0x62,0x6e,0xf1,0xd1,0x8a,0x2e,0x5b,0x9d,0xb7,0x2e,
		0x97,0x45,0xf3,0xdb,0x57,0xa3,0xb0,0xe2,0xa5,0xcb,0x5a,0x89,0x78,0x7e,0x4b,0xae,
		0xf0,0x17,0x21,0x91,0x5c,0xdb,0x1d,0xf1,0x0a,0x59,0xf2,0x04,0xce,0x99,0x2b,0xe8,
		0x6d,0x35,0xf1,0xde,0x25,0x3b,0x8f,0x16,0xbc,0xb4,0x37,0x55,0x72,0xce,0x5c,0xc6,
		0x89,0x1c,0x05,0xe5,0xfa,0x4c,0x74,0xc7,0xd3,0xd9,0x11,0xb6,0xeb,0xb8,0xd8,0x00,
		0x3c,0xd7,0xd9,0xd3,0x53,0x90,0x9c,0x94,0xb4,0x9e,0x9c,0x10,0x87,0xc5,0x54,0x49,
		0x57,0x4b,0x23,0x83,0x97,0x1c,0x2c,0x2f,0xdc,0x64,0xed,0x8b,0x71,0x3e,0x1c,0x76,
		0x71,0xba,0x24,0x9f,0x2a,0x63,0x21,0x06,0xcd,0x31,0x24,0xbb,0x22,0xd8,0xba,0x6d,
		0xdb,0x29,0x8f,0xc7,0x13,0x24,0x46,0x46,0x6e,0xef,0x54,0xab,0xd5,0x68,0x95,0xe9,
		0xe8,0xb2,0x15,0x94,0xea,0x95,0x5c,0xef,0xb2,0xf1,0x99,0x77,0x88,0xd5,0xef,0xee,
		0xb1,0xba,0x38,0xcd,0xa7,0x1f,0x0d,0xd1,0x7f,0xf9,0x02,0xa9,0x29,0xa9,0xc8,0x62,
		0xa5,0x98,0x4a,0xb5,0x84,0x87,0x04,0x72,0x67,0x72,0x0a,0x91,0x9d,0x6d,0xdc,0xd4,
		0x64,0x69,0xe8,0x4e,0x94,0xc5,0x51,0xa2,0xc9,0xe4,0x4c,0xa9,0x1e,0x47,0xfd,0x29,
		0x5c,0x1d,0xcd,0xac,0x7d,0xff,0x00,0x96,0x17,0xb8,0x35,0xd0,0x43,0x5f,0x7b,0x03,
		0x6d,0x8d,0x95,0x84,0xbd,0x1c,0x4e,0x48,0x50,0x20,0x0d,0xb5,0xd5,0xcc,0x3c,0xfc,
		0xa4,0x5a,0x00,0x5b,0x73,0x35,0xba,0x87,0x9a,0x37,0x93,0xc9,0xcd,0x3c,0x82,0x51,
		0x7f,0x94,0xa6,0xea,0x22,0xec,0x8d,0x26,0x54,0x59,0x19,0xec,0x97,0x84,0x73,0xa6,
		0xac,0x90,0x7c,0x5d,0x0e,0x66,0xa3,0x1e,0xa3,0x41,0xc9,0x0b,0x2f,0x6e,0x22,0x57,
		0xa3,0xc1,0xe5,0x6a,0x79,0x49,0x6c,0x18,0x1b,0x1b,0x51,0x15,0x9e,0xd0,0x72,0xf8,
		0xf5,0xbd,0x54,0x18,0xb2,0x50,0x2a,0xd2,0xb0,0xd6,0x14,0x73,0x48,0x7a,0x00,0x69,
		0xf4,0x6b,0x5c,0x76,0x98,0x28,0x35,0xa8,0xd8,0xb3,0x5b,0x42,0x5a,0x62,0x0c,0x19,
		0x87,0x63,0xb0,0xd9,0x9a,0x79,0x2a,0x54,0x6c,0x70,0x0f,0xba,0xb5,0xb2,0xf8,0x78,
		0x8a,0x54,0xe9,0x04,0x07,0xef,0xc0,0xe9,0xa8,0x65,0x65,0xee,0x5d,0xec,0xb5,0x27,
		0x69,0xae,0x2d,0x67,0xea,0x9d,0x0b,0x38,0xad,0x65,0x24,0x1d,0x8a,0x41,0x26,0x8d,
		0x42,0x91,0x92,0x40,0x4f,0x57,0x17,0x4b,0x4b,0xcb,0xa1,0x62,0x43,0x7f,0xff,0x8d,
		0xcc,0xce,0x8b,0x6d,0xeb,0xd1,0x07,0xf6,0xa0,0x90,0x27,0xa3,0x4c,0x3b,0x82,0xf9,
		0xa4,0x8e,0xcf,0x27,0xae,0xf0,0x78,0xb6,0x9f,0x1f,0x67,0x06,0xa8,0x2e,0x52,0x13,
		0x27,0x8d,0xa2,0xcd,0x52,0x8e,0x2c,0x56,0x8a,0xd3,0xe9,0xb4,0x09,0x7f,0x5a,0xad,
		0xf6,0xda,0xf6,0xc0,0xed,0x84,0x85,0x86,0x20,0x8d,0x8e,0xc2,0x5a,0x5f,0xc3,0xdd,
		0x61,0x17,0xb3,0xb7,0xfa,0xb0,0x37,0xd4,0x90,0x99,0x9e,0x8a,0xb3,0xd5,0x42,0xcd,
		0x5b,0x39,0x54,0xe4,0x29,0x50,0xaa,0xf3,0xf8,0x60,0xea,0x6e,0xb5,0x78,0x46,0x22,
		0x91,0xf4,0x2b,0x14,0x19,0xc4,0xc7,0x1c,0xa4,0xa2,0x24,0x1f,0x67,0x4b,0x1d,0x63,
		0xee,0x6e,0xfe,0xf8,0x65,0x81,0x35,0xdf,0x1c,0x93,0x37,0xba,0x59,0xfd,0x72,0x82,
		0x84,0x83,0xfb,0x98,0x1e,0xea,0xa4,0xb7,0xc5,0xc4,0xe8,0xd5,0x76,0xc4,0x33,0x3a,
		0x9d,0x6e,0x8b,0xdb,0x3d,0xf0,0xb8,0xb7,0xa7,0x83,0x02,0xbd,0x8a,0x79,0x4f,0x2f,
		0x7f,0x3f,0xb9,0x0f,0x3f,0xcd,0xc0,0xd2,0x34,0xf8,0x26,0x61,0xf1,0x36,0xb1,0xfb,
		0x23,0xf8,0xc1,0xeb,0x82,0x6f,0x47,0xf9,0xf5,0x41,0x1f,0xff,0x00,0xd1,0xd4,0xed,
		0x9a,0xea,0xd8,0xfa,0xbf,0x00,0x00,0x00,0x00,0x49,0x45,0x4e,0x44,0xae,0x42,0x60,
		0x82);
}
