/*
 * Copyright (c) 2010, 2011 Ryan Flannery <ryan.flannery@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef MPLAYER_H
#define MPLAYER_H

#include <sys/wait.h>
#include <sys/types.h>

#include <err.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <stdbool.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "player_utils.h"

#ifdef DEBUG
#  include "../debug.h"
#endif

void mplayer_start();
void mplayer_finish();
void mplayer_sigchld();

void mplayer_play(const char *file);
void mplayer_stop();
void mplayer_pause();
void mplayer_seek(int seconds);
void mplayer_volume_step(float percent);

float mplayer_get_position();
float mplayer_get_volume();
bool  mplayer_is_playing();
bool  mplayer_is_paused();

void  mplayer_set_callback_playnext(void (*f)(void));
void  mplayer_set_callback_notice(void (*f)(char *, ...));
void  mplayer_set_callback_error(void (*f)(char *, ...));
void  mplayer_set_callback_fatal(void (*f)(char *, ...));

void mplayer_monitor();

#endif
