#ifndef PROFILES_H
#define PROFILES_H

#include <QtGui/QDialog>
#include "objects.h"

namespace Ui {
    class profiles;
}

class profiles : public QDialog {
    Q_OBJECT
public:
    profiles(QWidget *parent = 0);
    ~profiles();

    QList<Profile> profileList;
    int selectToIdx;
    void initialize();
    void saveProfiles();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::profiles *m_ui;

    bool editing;
    bool newProfile;


    void adjustScreen();
    Profile getProfileDataFromScreen();
    void showError(QString text, QString info);
    void loadProfileListView();


private slots:
    void on_cmbFormat_currentIndexChanged(int index);
    void on_btnRename_clicked();
    void on_btnEdit_clicked();
    void on_btnDelete_clicked();
    void on_cmbSize_currentIndexChanged(int index);
    void on_cmbBitrate_currentIndexChanged(int index);
    void on_btnSave_clicked();
    void on_btnNew_clicked();
    void on_btnCancel_clicked();
    void on_btnClose_clicked();
};

#endif // PROFILES_H
