/////////////////////////////////////////////////////////////////////////////
// Name:        SettingsDlg.h
// Purpose:     Settings dialog
// Author:      Alex Thuering
// Created:     27.03.2004
// RCS-ID:      $Id: SettingsDlg.h,v 1.8 2015/01/06 21:37:41 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef SETTINGS_DLG_H
#define SETTINGS_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>

class SettingsDlg: public wxPropDlg {
public:
    SettingsDlg(wxWindow *parent);
	virtual ~SettingsDlg() {}

protected:
	void CreatePropPanel(wxSizer* sizer);
	bool SetValues();
  
private:
	wxArrayString m_buttons;
	wxArrayString m_transitions;
	wxTextCtrl* m_directoryEdit;
	wxButton* m_directorySelectButton;
	void OnChangeFileBrowserDir(wxCommandEvent& evt);
	void OnResetDontShowFlags(wxCommandEvent& evt);
	void AddSpacer(wxSizer* sizer, int size);
	void AddStretchSpacer(wxSizer* sizer, int prop);
	DECLARE_EVENT_TABLE()
};

#endif // TEXT_PROP_DLG_H
