/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.util.Contract;

public class KeyBindingDispatcher
implements KeyEventDispatcher {
    private InputMap inputMap;
    private ActionMap actionMap;

    @Override
    public boolean dispatchKeyEvent(KeyEvent e) {
        if (!e.isConsumed() && this.processKeyBinding(e)) {
            e.consume();
        }
        return false;
    }

    protected boolean processKeyBinding(KeyEvent e) {
        Action action = this.getAction(e);
        if (action != null && action.isEnabled()) {
            ActionEvent actionEvent = this.createActionEvent(e, action);
            action.actionPerformed(actionEvent);
            return true;
        }
        return false;
    }

    protected Action getAction(KeyEvent e) {
        KeyStroke stroke = KeyStroke.getKeyStrokeForEvent(e);
        Object actionKey = this.getInputMap().get(stroke);
        if (actionKey != null) {
            return this.getActionMap().get(actionKey);
        }
        return null;
    }

    protected ActionEvent createActionEvent(KeyEvent e, Action action) {
        Object command0 = action.getValue("ActionCommandKey");
        String command = null;
        if (command0 != null) {
            command = command0.toString();
        } else if (e.getKeyChar() != '\uffff') {
            command = String.valueOf(e.getKeyChar());
        }
        ActionEvent actionEvent = new ActionEvent(e.getSource(), 1001, command, e.getWhen(), e.getModifiers());
        return actionEvent;
    }

    public void bind(KeyStroke keyStroke, Action action, Object key) {
        Contract.asNotNull((Object)key, (String)"binding key must not be null");
        this.put(keyStroke, key);
        this.put(key, action);
    }

    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public InputMap getInputMap() {
        if (this.inputMap == null) {
            this.inputMap = new InputMap();
        }
        return this.inputMap;
    }

    public void bind(KeyStroke keyStroke, Action action) {
        this.bind(keyStroke, action, this.createAutoKey());
    }

    protected Object createAutoKey() {
        long millis = System.currentTimeMillis();
        String key = "auto" + millis;
        while (this.get(key) != null) {
            key = "auto" + millis--;
        }
        return key;
    }

    public void put(KeyStroke keyStroke, Object actionMapKey) {
        this.getInputMap().put(keyStroke, actionMapKey);
    }

    public Object get(KeyStroke keyStroke) {
        return this.getInputMap().get(keyStroke);
    }

    public void put(Object key, Action action) {
        this.getActionMap().put(key, action);
    }

    public Action get(Object key) {
        return this.getActionMap().get(key);
    }
}

