/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdesktop.animation.timing.interpolation.Evaluator;

public class KeyValues<T> {
    private final List<T> values = new ArrayList<T>();
    private final Evaluator<T> evaluator;
    private final Class<?> type;
    private T startValue;

    public static <T> KeyValues<T> create(T ... params) {
        return new KeyValues<T>(params);
    }

    public static <T> KeyValues<T> create(Evaluator evaluator, T ... params) {
        return new KeyValues<T>(evaluator, params);
    }

    private KeyValues(T ... params) {
        this(Evaluator.create(params.getClass().getComponentType()), params);
    }

    private KeyValues(Evaluator evaluator, T ... params) {
        if (params == null) {
            throw new IllegalArgumentException("params array cannot be null");
        }
        if (params.length == 0) {
            throw new IllegalArgumentException("params array must have at least one element");
        }
        if (params.length == 1) {
            this.values.add(null);
        }
        Collections.addAll(this.values, params);
        this.type = params.getClass().getComponentType();
        this.evaluator = evaluator;
    }

    int getSize() {
        return this.values.size();
    }

    Class<?> getType() {
        return this.type;
    }

    void setStartValue(T startValue) {
        if (this.isToAnimation()) {
            this.startValue = startValue;
        }
    }

    boolean isToAnimation() {
        return this.values.get(0) == null;
    }

    T getValue(int i0, int i1, float fraction) {
        T value;
        T lowerValue = this.values.get(i0);
        if (lowerValue == null) {
            lowerValue = this.startValue;
        }
        if (i0 == i1) {
            value = lowerValue;
        } else {
            T v1 = this.values.get(i1);
            value = this.evaluator.evaluate(lowerValue, v1, fraction);
        }
        return value;
    }
}

