/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jtelegraph;

import java.awt.Color;
import java.awt.Dimension;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.LayoutStyle;
import net.sf.jtelegraph.TelegraphType;

public class TelegraphEnvelope
extends JWindow {
    private static final long serialVersionUID = 3778L;
    private TelegraphType teleType;
    private JPanel ContentPanel;
    private JLabel telegraphIcon;
    private JLabel telegraphText;

    public TelegraphEnvelope() {
        this.initComponents();
    }

    private void initComponents() {
        this.ContentPanel = new JPanel();
        this.telegraphIcon = new JLabel();
        this.telegraphText = new JLabel();
        this.setAlwaysOnTop(true);
        this.ContentPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0), 2));
        this.ContentPanel.setAlignmentX(0.0f);
        this.ContentPanel.setAlignmentY(0.0f);
        this.telegraphIcon.setText("Icon");
        this.telegraphIcon.setMaximumSize(new Dimension(64, 64));
        this.telegraphIcon.setMinimumSize(new Dimension(64, 64));
        this.telegraphIcon.setPreferredSize(new Dimension(64, 64));
        this.telegraphText.setText("Text");
        GroupLayout ContentPanelLayout = new GroupLayout(this.ContentPanel);
        this.ContentPanel.setLayout(ContentPanelLayout);
        ContentPanelLayout.setHorizontalGroup(ContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ContentPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.telegraphIcon, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.telegraphText, -1, 252, Short.MAX_VALUE).addContainerGap()));
        ContentPanelLayout.setVerticalGroup(ContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ContentPanelLayout.createSequentialGroup().addContainerGap().addGroup(ContentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.telegraphText).addComponent(this.telegraphIcon, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.telegraphIcon.getAccessibleContext().setAccessibleName("telegraphIcon");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ContentPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ContentPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    protected synchronized void setMessage(String title, String message) {
        String labelText = String.format("<html><div style=\"width:%dpx;\"><b>%s</b><br/><br/>%s</div><html>", 180, title, message);
        this.telegraphText.setText(labelText);
    }

    private void fixWindowHeight() {
        int textHeight;
        int windowHeight = this.getHeight();
        if (windowHeight - 60 <= (textHeight = this.telegraphText.getHeight())) {
            this.setBounds(this.getX(), this.getY(), this.getWidth(), 60 + textHeight);
        }
    }

    protected void packTelegraph() {
        this.pack();
        this.fixWindowHeight();
        this.setTelegraphIconAndColor(this.teleType);
    }

    private void setTelegraphIconAndColor(TelegraphType iconType) {
        Color iconColor;
        String iconName;
        switch (iconType) {
            case MEDIATHEK_VIEW: {
                iconName = "mediathekView.png";
                iconColor = new Color(50, 50, 120);
                break;
            }
            case MEDIATHEK_VIEW_ERROR: {
                iconName = "mediathekView_fehler.png";
                iconColor = new Color(50, 50, 120);
                break;
            }
            case APPLICATION: {
                iconName = "application.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case APPLICATION_WARNING: {
                iconName = "application_warning.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case CALCULATOR: {
                iconName = "calculator.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case CALENDAR: {
                iconName = "calendar.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case CAMERA: {
                iconName = "camera.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case CLOCK: {
                iconName = "clock.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case COFFEE: {
                iconName = "coffee.png";
                iconColor = new Color(102, 0, 0);
                break;
            }
            case COMPUTER: {
                iconName = "computer.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case DIRECTION_DOWN: {
                iconName = "direction_down.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case DIRECTION_LEFT: {
                iconName = "direction_left.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case DIRECTION_RIGHT: {
                iconName = "direction_right.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case DIRECTION_UP: {
                iconName = "direction_up.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case DISC: {
                iconName = "disc.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case DISKETTE: {
                iconName = "diskette.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case DOCUMENT: {
                iconName = "document.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case DOCUMENT_ADD: {
                iconName = "document_add.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case DOCUMENT_DELETE: {
                iconName = "document_delete.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case DOCUMENT_EDIT: {
                iconName = "document_edit.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case DOCUMENT_SEARCH: {
                iconName = "document_search.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case DOCUMENT_WARNING: {
                iconName = "document_warning.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FILE: {
                iconName = "file.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FILE_ADD: {
                iconName = "file_add.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FILE_DELETE: {
                iconName = "file_delete.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FILE_EDIT: {
                iconName = "file_edit.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FILE_SEARCH: {
                iconName = "file_search.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FILE_WARNING: {
                iconName = "file_warning.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case FOLDER: {
                iconName = "folder.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FOLDER_ADD: {
                iconName = "folder_add.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FOLDER_DELETE: {
                iconName = "folder_delete.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FOLDER_EMPTY: {
                iconName = "folder_empty.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FOLDER_SEARCH: {
                iconName = "folder_search.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case FOLDER_WARNING: {
                iconName = "folder_warning.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case HOME: {
                iconName = "home.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case LOAD_DOWNLOAD: {
                iconName = "load_download.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case LOAD_UPLOAD: {
                iconName = "load_upload.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case MAIL: {
                iconName = "mail.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_DELETE: {
                iconName = "mail_delete.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_RECEIVE: {
                iconName = "mail_receive.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_SEARCH: {
                iconName = "mail_search.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_SEND: {
                iconName = "mail_send.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_WARNING: {
                iconName = "mail_warning.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MAIL_WRITE: {
                iconName = "mail_write.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case MESSAGE: {
                iconName = "message.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case NOTIFICATION_ADD: {
                iconName = "notification_add.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case NOTIFICATION_DONE: {
                iconName = "notification_done.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case NOTIFICATION_ERROR: {
                iconName = "notification_error.png";
                iconColor = new Color(153, 0, 0);
                break;
            }
            case NOTIFICATION_HELP: {
                iconName = "notification_help.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case NOTIFICATION_INFO: {
                iconName = "notification_info.png";
                iconColor = new Color(102, 0, 0);
                break;
            }
            case NOTIFICATION_REMOVE: {
                iconName = "notification_remove.png";
                iconColor = new Color(153, 0, 0);
                break;
            }
            case NOTIFICATION_WARNING: {
                iconName = "notification_warning.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case PIECHART: {
                iconName = "piechart.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case PLAYER_FASTFORWARD: {
                iconName = "player_fastforward.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case PLAYER_PLAY: {
                iconName = "player_play.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case PLAYER_REWIND: {
                iconName = "player_rewind.png";
                iconColor = new Color(51, 102, 0);
                break;
            }
            case PLAYER_PAUSE: {
                iconName = "player_pause.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case PLAYER_RECORD: {
                iconName = "player_record.png";
                iconColor = new Color(153, 0, 0);
                break;
            }
            case PLAYER_STOP: {
                iconName = "player_stop.png";
                iconColor = new Color(153, 0, 0);
                break;
            }
            case RSS: {
                iconName = "rss.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case SEARCH: {
                iconName = "search.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case SECURITY_KEY: {
                iconName = "security_key.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case SECURITY_KEYANDLOCK: {
                iconName = "security_keyandlock.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case SECURITY_LOCK: {
                iconName = "security_lock.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case SECURITY_UNLOCK: {
                iconName = "security_unlock.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case SHOPPINGCART: {
                iconName = "shoppingcart.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case SHOPPINGCART_ADD: {
                iconName = "shoppingcart_add.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case SHOPPINGCART_CHECKOUT: {
                iconName = "shoppingcart_checkout.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case SHOPPINGCART_REMOVE: {
                iconName = "shoppingcart_remove.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case SHOPPINGCART_WARNING: {
                iconName = "shoppingcart_warning.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case STAR_EMPTY: {
                iconName = "star_empty.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case STAR_FULL: {
                iconName = "star_full.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case STAR_HALF: {
                iconName = "star_half.png";
                iconColor = new Color(153, 153, 0);
                break;
            }
            case USER: {
                iconName = "user.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case USER_ADD: {
                iconName = "user_add.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case USER_DELETE: {
                iconName = "user_delete.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case USER_MANAGE: {
                iconName = "user_manage.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case USER_WARNING: {
                iconName = "user_warning.png";
                iconColor = new Color(0, 51, 204);
                break;
            }
            case VOLUME: {
                iconName = "volume.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case VOLUME_DOWN: {
                iconName = "volume_down.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case VOLUME_MUTE: {
                iconName = "volume_mute.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            case VOLUME_UP: {
                iconName = "volume_up.png";
                iconColor = new Color(0, 0, 153);
                break;
            }
            default: {
                iconName = "notification_info.png";
                iconColor = new Color(102, 0, 0);
            }
        }
        URL imageURL = this.getClass().getResource("icons/" + iconName);
        if (imageURL != null) {
            ImageIcon icon = new ImageIcon(imageURL);
            this.telegraphIcon.setIcon(icon);
            this.ContentPanel.setBorder(BorderFactory.createLineBorder(iconColor, 2));
            this.telegraphText.setForeground(iconColor);
        } else {
            this.telegraphIcon.setText("No icon");
        }
    }

    protected void setTelegraphType(TelegraphType telegraph) {
        this.teleType = telegraph;
    }
}

