/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import com.jidesoft.utils.SystemInfo;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import mediathek.controller.Log;
import mediathek.controller.MVUsedUrls;
import mediathek.controller.starter.Start;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.res.GetIcon;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVColor;
import mediathek.tool.MVFont;
import mediathek.tool.MVSenderIconCache;
import mediathek.tool.MVTable;
import msearch.daten.DatenFilm;

public class CellRendererFilme
extends DefaultTableCellRenderer {
    private static ImageIcon film_start_tab = null;
    private static ImageIcon film_start_sw_tab = null;
    private static ImageIcon film_rec_tab = null;
    private static ImageIcon film_rec_sw_tab = null;
    private static ImageIcon film_stop_tab = null;
    private static ImageIcon film_stop_sw_tab = null;
    private boolean geoMelden = false;
    private MVUsedUrls history = null;
    private final MVSenderIconCache senderIconCache;
    private static ImageIcon ja_16 = null;
    private static ImageIcon nein_12 = null;

    public CellRendererFilme(Daten d) {
        ja_16 = GetIcon.getProgramIcon("ja_16.png");
        nein_12 = GetIcon.getProgramIcon("nein_12.png");
        this.history = d.history;
        film_start_tab = GetIcon.getProgramIcon("film_start_tab.png");
        film_start_sw_tab = GetIcon.getProgramIcon("film_start_sw_tab.png");
        film_rec_tab = GetIcon.getProgramIcon("film_rec_tab.png");
        film_rec_sw_tab = GetIcon.getProgramIcon("film_rec_sw_tab.png");
        film_stop_tab = GetIcon.getProgramIcon("film_stop_tab.png");
        film_stop_sw_tab = GetIcon.getProgramIcon("film_stop_sw_tab.png");
        this.geoMelden = Boolean.parseBoolean(Daten.mVConfig.get("Geo-melden"));
        ListenerMediathekView.addListener(new ListenerMediathekView(31, CellRendererFilme.class.getSimpleName()){

            @Override
            public void ping() {
                CellRendererFilme.this.geoMelden = Boolean.parseBoolean(Daten.mVConfig.get("Geo-melden"));
            }
        });
        this.senderIconCache = new MVSenderIconCache();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        try {
            this.setBackground(null);
            this.setForeground(null);
            this.setIcon(null);
            this.setToolTipText(null);
            this.setHorizontalAlignment(10);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int rowModelIndex = table.convertRowIndexToModel(row);
            int columnModelIndex = table.convertColumnIndexToModel(column);
            DatenFilm datenFilm = (DatenFilm)table.getModel().getValueAt(rowModelIndex, 25);
            DatenDownload datenDownload = Daten.listeDownloadsButton.getDownloadUrlFilm(datenFilm.arr[12]);
            boolean live = datenFilm.arr[2].equals("Livestream");
            boolean start = false;
            if (!SystemInfo.isMacOSX()) {
                if (isSelected) {
                    this.setFont(new Font("Dialog", 1, MVFont.fontSize));
                } else {
                    this.setFont(new Font("Dialog", 0, MVFont.fontSize));
                }
            }
            switch (columnModelIndex) {
                case 0: 
                case 6: 
                case 7: 
                case 8: {
                    this.setHorizontalAlignment(0);
                    break;
                }
                case 9: {
                    this.setHorizontalAlignment(4);
                    break;
                }
                case 4: {
                    this.handleButtonStartColumn(datenDownload, isSelected);
                    break;
                }
                case 5: {
                    this.handleButtonDownloadColumn(isSelected);
                    break;
                }
                case 1: {
                    if (!((MVTable)table).iconAnzeigen) break;
                    this.handleSenderColumn((String)value, ((MVTable)table).iconKlein);
                    break;
                }
                case 23: {
                    this.setHorizontalAlignment(0);
                    if (datenFilm.neuerFilm) {
                        this.setIcon(ja_16);
                        break;
                    }
                    this.setIcon(nein_12);
                }
            }
            if (datenDownload != null && datenDownload.start != null) {
                start = true;
                this.setColor(this, datenDownload.start, isSelected);
            }
            if (!start) {
                if (live) {
                    this.setForeground(MVColor.FILM_LIVESTREAM.color);
                } else if (this.history.urlPruefen(datenFilm.getUrlHistory())) {
                    if (!isSelected) {
                        this.setBackground(MVColor.FILM_HISTORY.color);
                    }
                } else if (datenFilm.neuerFilm) {
                    this.setForeground(MVColor.FILM_NEU.color);
                }
            }
            if (!start && this.geoMelden && !datenFilm.arr[11].isEmpty() && !datenFilm.arr[11].contains(Daten.mVConfig.get("Geo-Standort"))) {
                if (isSelected) {
                    this.setBackground(MVColor.FILM_GEOBLOCK_BACKGROUND_SEL.color);
                } else {
                    this.setBackground(MVColor.FILM_GEOBLOCK_BACKGROUND.color);
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(630098552, ex);
        }
        return this;
    }

    private void handleButtonStartColumn(DatenDownload datenDownload, boolean isSelected) {
        this.setHorizontalAlignment(0);
        if (datenDownload != null && datenDownload.start != null && datenDownload.start.status == 2) {
            this.setToolTipText("Film stoppen");
            if (isSelected) {
                this.setIcon(film_stop_tab);
            } else {
                this.setIcon(film_stop_sw_tab);
            }
        }
        if (this.getIcon() == null) {
            this.setToolTipText("Film abspielen");
            if (isSelected) {
                this.setIcon(film_start_tab);
            } else {
                this.setIcon(film_start_sw_tab);
            }
        }
    }

    private void handleButtonDownloadColumn(boolean isSelected) {
        this.setHorizontalAlignment(0);
        this.setToolTipText("Film aufzeichnen");
        if (isSelected) {
            this.setIcon(film_rec_tab);
        } else {
            this.setIcon(film_rec_sw_tab);
        }
    }

    private void handleSenderColumn(String sender, boolean small) {
        this.setHorizontalAlignment(0);
        ImageIcon icon = this.senderIconCache.get(sender, small);
        if (icon != null) {
            this.setText("");
            this.setIcon(icon);
        }
    }

    private void setColor(Component c, Start s, boolean isSelected) {
        switch (s.status) {
            case 1: {
                if (isSelected) {
                    c.setBackground(MVColor.DOWNLOAD_WAIT_SEL.color);
                    break;
                }
                c.setBackground(MVColor.DOWNLOAD_WAIT.color);
                break;
            }
            case 2: {
                if (isSelected) {
                    c.setBackground(MVColor.DOWNLOAD_RUN_SEL.color);
                    break;
                }
                c.setBackground(MVColor.DOWNLOAD_RUN.color);
                break;
            }
            case 3: {
                if (isSelected) {
                    c.setBackground(MVColor.DOWNLOAD_FERTIG_SEL.color);
                    break;
                }
                c.setBackground(MVColor.DOWNLOAD_FERTIG.color);
                break;
            }
            case 4: {
                if (isSelected) {
                    c.setBackground(MVColor.DOWNLOAD_FEHLER_SEL.color);
                    break;
                }
                c.setBackground(MVColor.DOWNLOAD_FEHLER.color);
            }
        }
    }
}

