/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import com.jidesoft.utils.SystemInfo;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.LookAndFeel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mediathek.controller.Log;
import mediathek.controller.ProgrammUpdateSuchen;
import mediathek.daten.Daten;
import mediathek.gui.PanelVorlage;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVMessageDialog;

public class PanelEinstellungen
extends PanelVorlage {
    private static final String ICONSET_STANDARD = "Standard";
    private JButton jButtonHelpDays;
    private JButton jButtonInfos;
    private JButton jButtonLoad;
    private JButton jButtonRefresh;
    private JButton jButtonSuchen;
    private JCheckBox jCheckBoxEchtzeit;
    private JCheckBox jCheckBoxSuchen;
    private JCheckBox jCheckBoxTray;
    private JComboBox<String> jComboBoxIcons;
    private JComboBox<String> jComboBoxLookAndFeel;
    private JSpinner jSpinnerDays;

    public PanelEinstellungen(Daten d, JFrame parent) {
        super(d, parent);
        this.initComponents();
        this.jButtonInfos.setIcon(GetIcon.getProgramIcon("icons_refresh_16.png"));
        this.daten = d;
        this.initSpinner();
        this.jSpinnerDays.addChangeListener(new BeobSpinnerDays());
        this.jButtonLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.listeFilme.clear();
                Daten.filmeLaden.importFilmliste("");
            }
        });
        this.setupLookAndFeelComboBox();
        this.jButtonHelpDays.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHelpDays.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(PanelEinstellungen.this.parentComponent, true, "\nEs werden nur Filme der letzten\nxx Tage geladen.\nBei \"0\" werden alle Filme geladen.\n\n(Eine kleinere Filmliste\nkann bei Rechnern mit wenig\nSpeicher hilfreich sein.)\n\nAuswirkung hat das erst nach dem\nNeuladen der kompletten Filmliste.").setVisible(true);
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(6, PanelEinstellungen.class.getSimpleName()){

            @Override
            public void ping() {
                PanelEinstellungen.this.initSpinner();
            }
        });
        ListenerMediathekView.addListener(new ListenerMediathekView(35, PanelEinstellungen.class.getSimpleName()){

            @Override
            public void ping() {
                PanelEinstellungen.this.jCheckBoxTray.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Tray-anzeigen")));
            }
        });
        this.jCheckBoxEchtzeit.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Echtzeitsuche")));
        this.jCheckBoxEchtzeit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.mVConfig.add("Echtzeitsuche", Boolean.toString(PanelEinstellungen.this.jCheckBoxEchtzeit.isSelected()));
            }
        });
        if (SystemInfo.isMacOSX()) {
            this.jCheckBoxTray.setSelected(false);
            this.jCheckBoxTray.setEnabled(false);
        } else {
            this.jCheckBoxTray.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("Tray-anzeigen")));
            this.jCheckBoxTray.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ae) {
                    Daten.mVConfig.add("Tray-anzeigen", Boolean.toString(PanelEinstellungen.this.jCheckBoxTray.isSelected()));
                    PanelEinstellungen.this.daten.mediathekGui.setTray();
                }
            });
        }
        this.jCheckBoxSuchen.setSelected(Boolean.parseBoolean(Daten.mVConfig.get("update-suchen")));
        this.jCheckBoxSuchen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                Daten.mVConfig.add("update-suchen", Boolean.toString(PanelEinstellungen.this.jCheckBoxSuchen.isSelected()));
            }
        });
        this.jButtonSuchen.addActionListener(new BeobSuchen(false));
        this.jButtonInfos.addActionListener(new BeobSuchen(true));
        this.jButtonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelEinstellungen.this.fillIconList();
            }
        });
        this.fillIconList();
        this.jComboBoxIcons.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    PanelEinstellungen.this.cbxIconPackagesItemStateChanged(evt);
                }
            }
        });
    }

    private void cbxIconPackagesItemStateChanged(ItemEvent evt) {
        block5: {
            MVMessageDialog.showMessageDialog(this, "Sie m\u00fcssen die Applikation neu starten damit die Icons genutzt werden k\u00f6nnen.", "MediathekView", 2);
            String iconName = (String)this.jComboBoxIcons.getModel().getElementAt(this.jComboBoxIcons.getSelectedIndex());
            if (iconName.equals(ICONSET_STANDARD)) {
                Daten.mVConfig.add("Icon-Standard", Boolean.TRUE.toString());
                Daten.mVConfig.add("Icon-Pfad", "");
            } else {
                Daten.mVConfig.add("Icon-Standard", Boolean.FALSE.toString());
            }
            try {
                File[] files = new File(MVFunctionSys.pathProgramIcons()).listFiles();
                if (files == null) break block5;
                for (File file : files) {
                    if (!file.isDirectory() || !file.getName().equals(iconName)) continue;
                    Daten.mVConfig.add("Icon-Pfad", file.getAbsolutePath());
                    break;
                }
            }
            catch (Exception ex) {
                Daten.mVConfig.add("Icon-Standard", Boolean.TRUE.toString());
                Daten.mVConfig.add("Icon-Pfad", "");
                Log.fehlerMeldung(829304789, ex);
            }
        }
    }

    private void initSpinner() {
        if (Daten.mVConfig.get("system-anz-tage-filmilste").equals("")) {
            Daten.mVConfig.add("system-anz-tage-filmilste", "0");
        }
        this.jSpinnerDays.setValue(Integer.parseInt(Daten.mVConfig.get("system-anz-tage-filmilste")));
    }

    private void setupLookAndFeelComboBox() {
        try {
            final UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
            LookAndFeel aktLaf = UIManager.getLookAndFeel();
            String classNameAktLaf = aktLaf.getClass().getName();
            int idx = 0;
            ArrayList<String> themeList = new ArrayList<String>();
            for (int i = 0; i < info.length; ++i) {
                themeList.add(info[i].getName());
                if (!info[i].getClassName().equals(classNameAktLaf)) continue;
                idx = i;
            }
            DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(themeList.toArray());
            this.jComboBoxLookAndFeel.setModel(model);
            this.jComboBoxLookAndFeel.setSelectedIndex(idx);
            ActionListener lst = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String lafName = (String)PanelEinstellungen.this.jComboBoxLookAndFeel.getModel().getElementAt(PanelEinstellungen.this.jComboBoxLookAndFeel.getSelectedIndex());
                    String lafClass = "";
                    for (UIManager.LookAndFeelInfo i : info) {
                        if (!i.getName().equals(lafName)) continue;
                        lafClass = i.getClassName();
                        break;
                    }
                    try {
                        UIManager.setLookAndFeel(lafClass);
                        SwingUtilities.updateComponentTreeUI(PanelEinstellungen.this.daten.mediathekGui);
                        for (Frame f : Frame.getFrames()) {
                            SwingUtilities.updateComponentTreeUI(f);
                            for (Window w : f.getOwnedWindows()) {
                                SwingUtilities.updateComponentTreeUI(w);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    Daten.mVConfig.add("System-look", lafClass);
                }
            };
            this.jComboBoxLookAndFeel.addActionListener(lst);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void fillIconList() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(ICONSET_STANDARD);
        try {
            File[] files = new File(MVFunctionSys.pathProgramIcons()).listFiles();
            if (files != null) {
                for (File file : files) {
                    if (!file.isDirectory()) continue;
                    model.addElement(file.getName());
                }
            }
        }
        catch (Exception ex) {
            Log.fehlerMeldung(636875409, ex);
        }
        this.jComboBoxIcons.setModel(model);
        if (!Boolean.parseBoolean(Daten.mVConfig.get("Icon-Standard")) && !Daten.mVConfig.get("Icon-Pfad").equals("")) {
            File f = new File(Daten.mVConfig.get("Icon-Pfad"));
            this.jComboBoxIcons.setSelectedItem(f.getName());
        }
    }

    private void initComponents() {
        JPanel pnlProgramUpdate = new JPanel();
        this.jCheckBoxSuchen = new JCheckBox();
        this.jButtonSuchen = new JButton();
        this.jButtonInfos = new JButton();
        JPanel jPanel1 = new JPanel();
        JLabel jLabel2 = new JLabel();
        this.jComboBoxLookAndFeel = new JComboBox();
        JLabel jLabel1 = new JLabel();
        this.jComboBoxIcons = new JComboBox();
        this.jButtonRefresh = new JButton();
        JPanel jPanel2 = new JPanel();
        this.jCheckBoxEchtzeit = new JCheckBox();
        JLabel jLabel6 = new JLabel();
        this.jSpinnerDays = new JSpinner();
        this.jButtonHelpDays = new JButton();
        this.jButtonLoad = new JButton();
        this.jCheckBoxTray = new JCheckBox();
        this.setMinimumSize(this.getPreferredSize());
        pnlProgramUpdate.setBorder(BorderFactory.createTitledBorder("Programmupdate"));
        this.jCheckBoxSuchen.setText("einmal am Tag nach einer neuen Programmversion suchen");
        this.jButtonSuchen.setText("Jetzt suchen");
        this.jButtonInfos.setText("Programminfos anzeigen");
        GroupLayout pnlProgramUpdateLayout = new GroupLayout(pnlProgramUpdate);
        pnlProgramUpdate.setLayout(pnlProgramUpdateLayout);
        pnlProgramUpdateLayout.setHorizontalGroup(pnlProgramUpdateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlProgramUpdateLayout.createSequentialGroup().addContainerGap().addGroup(pnlProgramUpdateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxSuchen).addGroup(pnlProgramUpdateLayout.createSequentialGroup().addComponent(this.jButtonSuchen, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonInfos))).addContainerGap(-1, Short.MAX_VALUE)));
        pnlProgramUpdateLayout.setVerticalGroup(pnlProgramUpdateLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pnlProgramUpdateLayout.createSequentialGroup().addComponent(this.jCheckBoxSuchen).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pnlProgramUpdateLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonSuchen).addComponent(this.jButtonInfos)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        jLabel2.setText("Look&Feel:");
        jLabel1.setText("Icon-Pack:");
        this.jButtonRefresh.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/icons_refresh_16.png")));
        this.jButtonRefresh.setToolTipText("neue Icons suchen");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBoxIcons, 0, -1, Short.MAX_VALUE).addComponent(this.jComboBoxLookAndFeel, 0, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonRefresh).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxLookAndFeel, -2, -1, -2).addComponent(jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jComboBoxIcons, -2, -1, -2).addComponent(jLabel1)).addComponent(this.jButtonRefresh)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2.setBorder(BorderFactory.createTitledBorder(""));
        this.jCheckBoxEchtzeit.setText("Echtzeitsuche im Filter");
        jLabel6.setText("nur die Filme der letzten Tage laden:");
        this.jSpinnerDays.setModel(new SpinnerNumberModel(0, 0, 30, 1));
        this.jButtonHelpDays.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        this.jButtonLoad.setText("Filmliste jetzt neu laden");
        this.jCheckBoxTray.setText("Programm ins Tray minimieren");
        GroupLayout jPanel2Layout = new GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jCheckBoxEchtzeit, -1, -1, Short.MAX_VALUE).addGap(64, 64, 64)).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSpinnerDays, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelpDays).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonLoad)).addComponent(this.jCheckBoxTray)).addGap(0, 16, Short.MAX_VALUE)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.jCheckBoxEchtzeit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jCheckBoxTray).addGap(5, 5, 5).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel6).addComponent(this.jSpinnerDays, -2, -1, -2).addComponent(this.jButtonHelpDays).addComponent(this.jButtonLoad)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(pnlProgramUpdate, -1, -1, Short.MAX_VALUE).addComponent(jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(pnlProgramUpdate, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private class BeobSuchen
    implements ActionListener {
        private boolean infos = false;

        public BeobSuchen(boolean iinfos) {
            this.infos = iinfos;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            new ProgrammUpdateSuchen().checkVersion(!this.infos, this.infos, true);
        }
    }

    private class BeobSpinnerDays
    implements ChangeListener {
        private BeobSpinnerDays() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            Daten.mVConfig.add("system-anz-tage-filmilste", String.valueOf(((Number)PanelEinstellungen.this.jSpinnerDays.getModel().getValue()).intValue()));
        }
    }
}

