/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import com.jidesoft.utils.SystemInfo;
import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.controller.Log;
import mediathek.daten.Daten;
import mediathek.daten.DatenDownload;
import mediathek.res.GetIcon;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVColor;
import mediathek.tool.MVMessageDialog;

public class MVPanelDownloadZiel
extends JPanel {
    public boolean nameGeaendert = false;
    private DatenDownload datenDownload;
    private JFrame parent = null;
    boolean letztenPfadAnzeigen = false;
    private JButton jButtonDelPath;
    private JButton jButtonPath;
    private JComboBox<String> jComboBoxPath;
    private JLabel jLabelExists;
    private JTextField jTextFieldName;

    public MVPanelDownloadZiel(JFrame p, DatenDownload download, boolean letzterPfad) {
        this.initComponents();
        this.parent = p;
        this.datenDownload = download;
        this.letztenPfadAnzeigen = letzterPfad;
        this.jButtonPath.setIcon(GetIcon.getProgramIcon("fileopen_16.png"));
        this.jButtonDelPath.setIcon(GetIcon.getProgramIcon("del_16.png"));
        this.jLabelExists.setText("");
        this.jButtonPath.addActionListener(new ZielBeobachter());
        this.jButtonDelPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Daten.mVConfig.add("Pfade-zum-Speichern", "");
                MVPanelDownloadZiel.this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(new String[]{((MVPanelDownloadZiel)MVPanelDownloadZiel.this).datenDownload.arr[28]}));
            }
        });
        this.jTextFieldName.setText(this.datenDownload.arr[27]);
        this.jTextFieldName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                MVPanelDownloadZiel.this.nameGeaendert = true;
                MVPanelDownloadZiel.this.checkPfadName();
                String n1 = MVPanelDownloadZiel.this.jTextFieldName.getText();
                String n2 = FilenameUtils.checkDateiname(n1, false);
                if (!n1.equals(n2)) {
                    MVPanelDownloadZiel.this.jTextFieldName.setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    MVPanelDownloadZiel.this.jTextFieldName.setBackground(UIManager.getDefaults().getColor("TextField.background"));
                }
            }
        });
        this.setModelPfad(this.datenDownload.arr[28]);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.tus();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.tus();
            }

            private void tus() {
                MVPanelDownloadZiel.this.nameGeaendert = true;
                MVPanelDownloadZiel.this.checkPfadName();
                String s = ((JTextComponent)MVPanelDownloadZiel.this.jComboBoxPath.getEditor().getEditorComponent()).getText();
                if (!s.equals(FilenameUtils.checkDateiname(s, true))) {
                    MVPanelDownloadZiel.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
                } else {
                    MVPanelDownloadZiel.this.jComboBoxPath.getEditor().getEditorComponent().setBackground(Color.WHITE);
                }
            }
        });
        this.checkPfadName();
    }

    private void setModelPfad(String pfad) {
        ArrayList<String> pfade = new ArrayList<String>();
        if (!this.letztenPfadAnzeigen && !pfad.isEmpty()) {
            pfade.add(pfad);
        }
        if (!Daten.mVConfig.get("Pfade-zum-Speichern").isEmpty()) {
            String[] p;
            for (String s : p = Daten.mVConfig.get("Pfade-zum-Speichern").split("<>")) {
                if (pfade.contains(s)) continue;
                pfade.add(s);
            }
        }
        if (this.letztenPfadAnzeigen && !pfad.isEmpty() && !pfade.contains(pfad)) {
            pfade.add(pfad);
        }
        this.jComboBoxPath.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[pfade.size()])));
    }

    private void checkPfadName() {
        String pfad = ((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getText();
        String name = this.jTextFieldName.getText();
        String p = pfad.endsWith(File.separator) ? pfad.substring(0, pfad.length() - 1) : pfad;
        String pfadName = GuiFunktionen.concatPaths(p, name);
        try {
            File file = new File(pfadName);
            if (file.exists()) {
                this.jLabelExists.setForeground(MVColor.DOWNLOAD_DATEINAME_EXISTIERT.color);
                this.jLabelExists.setText("Datei existiert schon!");
            } else if (!this.jTextFieldName.getText().equals(this.datenDownload.arr[27]) || !((JTextComponent)this.jComboBoxPath.getEditor().getEditorComponent()).getText().equals(this.datenDownload.arr[28])) {
                this.jLabelExists.setForeground(MVColor.DOWNLOAD_DATEINAME_NEU.color);
                this.jLabelExists.setText("Neuer Name");
            } else {
                this.jLabelExists.setForeground(MVColor.DOWNLOAD_DATEINAME_ALT.color);
                this.jLabelExists.setText("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean setPfadName_geaendert() {
        String pfad = this.jComboBoxPath.getSelectedItem().toString();
        String name = this.jTextFieldName.getText();
        if (pfad.endsWith(File.separator)) {
            pfad = pfad.substring(0, pfad.length() - 1);
        }
        if (pfad.equals("")) {
            pfad = GuiFunktionen.getStandardDownloadPath();
        }
        if (name.equals("")) {
            name = new SimpleDateFormat("yyyyMMdd").format(new Date()) + "_" + this.datenDownload.arr[4] + "-" + this.datenDownload.arr[5] + ".mp4";
        }
        String[] pathName = new String[]{pfad, name};
        GuiFunktionen.checkLengthPath(pathName);
        if (!pathName[0].equals(pfad) || !pathName[1].equals(name)) {
            MVMessageDialog.showMessageDialog(this.parent, "Dateiname war zu lang und wurde gek\u00fcrzt!", "Pfad zu lang!", 0);
            pfad = pathName[0];
            name = pathName[1];
        }
        String orgPfad = this.datenDownload.arr[29];
        this.datenDownload.arr[27] = name;
        this.datenDownload.arr[28] = pfad;
        this.datenDownload.arr[29] = GuiFunktionen.addsPfad(pfad, name);
        return !orgPfad.equals(this.datenDownload.arr[29]);
    }

    private void initComponents() {
        JLabel jLabel1 = new JLabel();
        this.jComboBoxPath = new JComboBox();
        this.jButtonPath = new JButton();
        this.jButtonDelPath = new JButton();
        JLabel jLabel2 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabelExists = new JLabel();
        jLabel1.setText("Zielpfad:");
        this.jComboBoxPath.setEditable(true);
        this.jButtonPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/fileopen_16.png")));
        this.jButtonDelPath.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/del_16.png")));
        jLabel2.setText("Dateiname:");
        this.jLabelExists.setText("Datei existiert schon!");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabelExists).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jLabel2).addComponent(jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jComboBoxPath, 0, 429, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonDelPath)).addComponent(this.jTextFieldName)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel1).addComponent(this.jComboBoxPath, -2, -1, -2).addComponent(this.jButtonPath).addComponent(this.jButtonDelPath)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(jLabel2).addComponent(this.jTextFieldName, -2, -1, -2)).addGap(10, 10, 10).addComponent(this.jLabelExists).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.jButtonDelPath, this.jButtonPath, this.jComboBoxPath, this.jTextFieldName);
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemInfo.isMacOSX()) {
                System.setProperty("apple.awt.fileDialogForDirectories", "true");
                FileDialog chooser = new FileDialog((Frame)MVPanelDownloadZiel.this.parent, "Film speichern");
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        MVPanelDownloadZiel.this.jComboBoxPath.addItem(chooser.getDirectory() + chooser.getFile());
                        MVPanelDownloadZiel.this.jComboBoxPath.setSelectedItem(chooser.getDirectory() + chooser.getFile());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(356871087, ex);
                    }
                }
                System.setProperty("apple.awt.fileDialogForDirectories", "false");
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!MVPanelDownloadZiel.this.jComboBoxPath.getSelectedItem().toString().equals("")) {
                    chooser.setCurrentDirectory(new File(MVPanelDownloadZiel.this.jComboBoxPath.getSelectedItem().toString()));
                }
                chooser.setFileSelectionMode(1);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        MVPanelDownloadZiel.this.jComboBoxPath.addItem(chooser.getSelectedFile().getAbsolutePath());
                        MVPanelDownloadZiel.this.jComboBoxPath.setSelectedItem(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        Log.fehlerMeldung(356871087, ex);
                    }
                }
            }
        }
    }
}

