/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import mediathek.daten.Daten;
import mediathek.daten.DatenAbo;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.res.GetIcon;
import mediathek.tool.EscBeenden;
import mediathek.tool.FilenameUtils;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVColor;
import mediathek.tool.MVMessageDialog;

public class DialogEditAbo
extends JDialog {
    private final DatenAbo aktAbo;
    private JTextField[] textfeldListe;
    private final JComboBox<String> comboboxPSet = new JComboBox();
    private final JComboBox<String> comboboxSender = new JComboBox();
    private final JComboBox<String> comboboxPfad = new JComboBox();
    private final JCheckBox checkBoxEingeschaltet = new JCheckBox();
    private final JSlider sliderDauer = new JSlider(0, 100, 0);
    private final JLabel labelDauer = new JLabel("0");
    public boolean ok = false;
    private JButton jButtonAbbrechen;
    private JButton jButtonBeenden;
    private JButton jButtonHelp;
    private JPanel jPanelExtra;
    private JScrollPane jScrollPane1;

    public DialogEditAbo(final JFrame parent, boolean modal, Daten d, DatenAbo aktA) {
        super((Frame)parent, modal);
        this.initComponents();
        this.aktAbo = aktA;
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(16);
        this.comboboxPSet.setModel(new DefaultComboBoxModel<String>(Daten.listePset.getListeAbo().getObjectDataCombo()));
        this.comboboxSender.setModel(new DefaultComboBoxModel<String>(GuiFunktionen.addLeerListe(Daten.filmeLaden.getSenderNamen())));
        ArrayList<String> pfade = Daten.listeAbo.getPfade();
        if (!pfade.contains(this.aktAbo.arr[9])) {
            pfade.add(0, this.aktAbo.arr[9]);
        }
        this.comboboxPfad.setModel(new DefaultComboBoxModel<String>(pfade.toArray(new String[pfade.size()])));
        this.comboboxPfad.setEditable(true);
        this.checkPfad();
        ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).setOpaque(true);
        ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DialogEditAbo.this.checkPfad();
            }
        });
        this.jButtonBeenden.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogEditAbo.this.check()) {
                    DialogEditAbo.this.beenden();
                } else {
                    MVMessageDialog.showMessageDialog(parent, "Filter angeben!", "Leeres Abo", 0);
                }
            }
        });
        this.jButtonAbbrechen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogEditAbo.this.beenden();
            }
        });
        this.getRootPane().setDefaultButton(this.jButtonBeenden);
        new EscBeenden(this){

            @Override
            public void beenden_() {
                DialogEditAbo.this.beenden();
            }
        };
        this.setExtra();
        this.jButtonHelp.setIcon(GetIcon.getProgramIcon("help_16.png"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new DialogHilfe(parent, true, new GetFile().getHilfeSuchen(GetFile.PFAD_HILFETEXT_DIALOG_ADD_ABO)).setVisible(true);
            }
        });
    }

    private void checkPfad() {
        String s = ((JTextComponent)this.comboboxPfad.getEditor().getEditorComponent()).getText();
        if (!s.equals(FilenameUtils.checkDateiname(s, false))) {
            this.comboboxPfad.getEditor().getEditorComponent().setBackground(MVColor.DOWNLOAD_FEHLER.color);
        } else {
            this.comboboxPfad.getEditor().getEditorComponent().setBackground(Color.WHITE);
        }
    }

    private void setExtra() {
        this.textfeldListe = new JTextField[12];
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(5, 10, 10, 5);
        this.jPanelExtra.setLayout(gridbag);
        int zeile = 0;
        for (int i = 0; i < 12; ++i) {
            this.addExtraFeld(i, gridbag, c, this.jPanelExtra);
            c.gridy = ++zeile;
        }
    }

    private void addExtraFeld(int i, GridBagLayout gridbag, GridBagConstraints c, JPanel panel) {
        JLabel label;
        c.gridx = 0;
        c.weightx = 0.0;
        if (i == 3 || i == 4 || i == 5 || i == 6 || i == 7) {
            label = new JLabel("  " + DatenAbo.COLUMN_NAMES[i] + ": ");
            label.setForeground(Color.BLUE);
        } else {
            label = new JLabel(DatenAbo.COLUMN_NAMES[i] + ": ");
        }
        gridbag.setConstraints(label, c);
        panel.add(label);
        c.gridx = 1;
        c.weightx = 10.0;
        if (i == 11) {
            this.comboboxPSet.setSelectedItem(this.aktAbo.arr[i]);
            this.aktAbo.arr[11] = this.comboboxPSet.getSelectedItem().toString();
            gridbag.setConstraints(this.comboboxPSet, c);
            panel.add(this.comboboxPSet);
        } else if (i == 3) {
            this.comboboxSender.setSelectedItem(this.aktAbo.arr[i]);
            gridbag.setConstraints(this.comboboxSender, c);
            panel.add(this.comboboxSender);
        } else if (i == 9) {
            this.comboboxPfad.setSelectedItem(this.aktAbo.arr[i]);
            gridbag.setConstraints(this.comboboxPfad, c);
            panel.add(this.comboboxPfad);
        } else if (i == 8) {
            this.sliderDauer.setValue(this.aktAbo.mindestdauerMinuten);
            this.labelDauer.setText(String.valueOf(this.aktAbo.mindestdauerMinuten));
            this.sliderDauer.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    DialogEditAbo.this.labelDauer.setText("  " + DialogEditAbo.this.sliderDauer.getValue() + " ");
                }
            });
            JPanel p = new JPanel(new BorderLayout());
            p.add((Component)this.sliderDauer, "Center");
            p.add((Component)this.labelDauer, "East");
            gridbag.setConstraints(p, c);
            panel.add(p);
        } else if (i == 1) {
            this.checkBoxEingeschaltet.setSelected(Boolean.parseBoolean(this.aktAbo.arr[i]));
            gridbag.setConstraints(this.checkBoxEingeschaltet, c);
            panel.add(this.checkBoxEingeschaltet);
        } else {
            JTextField textfeld;
            this.textfeldListe[i] = textfeld = new JTextField();
            if (i == 0 || i == 10) {
                textfeld.setEditable(false);
            }
            if (i == 2) {
                textfeld.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                        DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                        DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        DialogEditAbo.this.textfeldListe[2].setBackground(DialogEditAbo.this.textfeldListe[2].getText().isEmpty() ? Color.red : Color.white);
                        DialogEditAbo.this.jButtonBeenden.setEnabled(!DialogEditAbo.this.textfeldListe[2].getText().isEmpty());
                    }
                });
            }
            textfeld.setText(this.aktAbo.arr[i]);
            gridbag.setConstraints(textfeld, c);
            panel.add(textfeld);
        }
    }

    private boolean check() {
        DatenAbo test = new DatenAbo();
        this.get(test);
        if (test.isEmpty()) {
            this.ok = false;
        } else {
            this.get(this.aktAbo);
            this.ok = true;
        }
        return this.ok;
    }

    private void get(DatenAbo abo) {
        block8: for (int i = 0; i < 12; ++i) {
            switch (i) {
                case 9: {
                    abo.arr[9] = this.comboboxPfad.getSelectedItem().toString();
                    continue block8;
                }
                case 11: {
                    abo.arr[11] = this.comboboxPSet.getSelectedItem().toString();
                    continue block8;
                }
                case 3: {
                    abo.arr[3] = this.comboboxSender.getSelectedItem().toString();
                    continue block8;
                }
                case 1: {
                    abo.arr[1] = Boolean.toString(this.checkBoxEingeschaltet.isSelected());
                    continue block8;
                }
                case 8: {
                    abo.setMindestDauerMinuten(this.sliderDauer.getValue());
                    continue block8;
                }
                case 0: 
                case 10: {
                    continue block8;
                }
                default: {
                    abo.arr[i] = this.textfeldListe[i].getText().trim();
                }
            }
        }
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanelExtra = new JPanel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonBeenden = new JButton();
        this.jButtonHelp = new JButton();
        this.setDefaultCloseOperation(2);
        GroupLayout jPanelExtraLayout = new GroupLayout(this.jPanelExtra);
        this.jPanelExtra.setLayout(jPanelExtraLayout);
        jPanelExtraLayout.setHorizontalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 513, Short.MAX_VALUE));
        jPanelExtraLayout.setVerticalGroup(jPanelExtraLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 502, Short.MAX_VALUE));
        this.jScrollPane1.setViewportView(this.jPanelExtra);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonBeenden.setText("Ok");
        this.jButtonHelp.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/programm/help_16.png")));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonBeenden, -2, 93, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHelp))).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonBeenden);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonBeenden).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonHelp)).addContainerGap()));
        this.pack();
    }
}

