/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import mediathek.daten.Daten;
import mediathek.tool.GuiFunktionenProgramme;

public class DatenProg {
    public static final String PROGRAMM = "Programm";
    public static final String PROGRAMM_NAME = "Programmname";
    public static final int PROGRAMM_NAME_NR = 0;
    public static final String PROGRAMM_ZIEL_DATEINAME = "Zieldateiname";
    public static final int PROGRAMM_ZIEL_DATEINAME_NR = 1;
    public static final String PROGRAMM_PROGRAMMPFAD = "Programmpfad";
    public static final int PROGRAMM_PROGRAMMPFAD_NR = 2;
    public static final String PROGRAMM_SCHALTER = "Programmschalter";
    public static final int PROGRAMM_SCHALTER_NR = 3;
    public static final String PROGRAMM_PRAEFIX = "Praefix";
    public static final int PROGRAMM_PRAEFIX_NR = 4;
    public static final String PROGRAMM_SUFFIX = "Suffix";
    public static final int PROGRAMM_SUFFIX_NR = 5;
    public static final String PROGRAMM_RESTART = "Restart";
    public static final int PROGRAMM_RESTART_NR = 6;
    public static final String PROGRAMM_DOWNLOADMANAGER = "Downloadmanager";
    public static final int PROGRAMM_DOWNLOADMANAGER_NR = 7;
    public static final int MAX_ELEM = 8;
    public static final String[] COLUMN_NAMES = new String[]{"Beschreibung", "Zieldateiname", "Programm", "Schalter", "Pr\u00e4fix", "Suffix", "Restart", "Downloadmanager"};
    public static final String[] COLUMN_NAMES_ = new String[]{"Programmname", "Zieldateiname", "Programmpfad", "Programmschalter", "Praefix", "Suffix", "Restart", "Downloadmanager"};
    public static boolean[] spaltenAnzeigen = new boolean[8];
    public String[] arr;

    public DatenProg() {
        this.makeArr();
        this.arr[6] = Boolean.toString(false);
        this.arr[7] = Boolean.toString(false);
    }

    public DatenProg(String name, String programmpfad, String schalter, String restart, String downloadmanager) {
        this.makeArr();
        this.arr[0] = name;
        this.arr[2] = programmpfad;
        this.arr[3] = schalter;
        this.arr[6] = restart.equals("") ? Boolean.toString(false) : restart;
        this.arr[7] = downloadmanager.equals("") ? Boolean.toString(false) : downloadmanager;
    }

    public DatenProg copy() {
        DatenProg ret = new DatenProg();
        System.arraycopy(this.arr, 0, ret.arr, 0, this.arr.length);
        return ret;
    }

    public boolean isRestart() {
        if (this.arr[6].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[6]);
    }

    public boolean isDownloadManager() {
        if (this.arr[7].equals("")) {
            return false;
        }
        return Boolean.parseBoolean(this.arr[7]);
    }

    public boolean urlTesten(String url) {
        boolean ret = false;
        if (url != null && GuiFunktionenProgramme.praefixTesten(this.arr[4], url, true) && GuiFunktionenProgramme.praefixTesten(this.arr[5], url, false)) {
            ret = true;
        }
        return ret;
    }

    public String getProgrammAufruf() {
        return this.arr[2] + " " + this.arr[3];
    }

    public String getProgrammAufrufArray() {
        String[] ar;
        String ret = this.arr[2];
        for (String s : ar = this.arr[3].split(" ")) {
            ret = ret + "<>" + s;
        }
        return ret;
    }

    public static String makeProgAufrufArray(String pArray) {
        String[] progArray = pArray.split("<>");
        String execStr = "";
        for (String s : progArray) {
            execStr = execStr + s + " ";
        }
        execStr = execStr.trim();
        return execStr;
    }

    public String toString() {
        String ret = "";
        for (int i = 0; i < 8; ++i) {
            ret = i == 0 ? ret + "| ***|" + COLUMN_NAMES[i] + ": " + this.arr[i] + Daten.LINE_SEPARATOR : ret + "|    |" + COLUMN_NAMES[i] + ": " + this.arr[i] + Daten.LINE_SEPARATOR;
        }
        return ret;
    }

    private void makeArr() {
        this.arr = new String[8];
        for (int i = 0; i < this.arr.length; ++i) {
            this.arr[i] = "";
        }
    }
}

