/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import com.jidesoft.utils.SystemInfo;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import mediathek.MediathekGui;
import mediathek.controller.FilmeLaden;
import mediathek.controller.IoXmlLesen;
import mediathek.controller.IoXmlSchreiben;
import mediathek.controller.Log;
import mediathek.controller.MVUsedUrls;
import mediathek.controller.starter.StarterClass;
import mediathek.daten.DownloadInfos;
import mediathek.daten.ListeAbo;
import mediathek.daten.ListeBlacklist;
import mediathek.daten.ListeDownloads;
import mediathek.daten.ListePset;
import mediathek.gui.GuiAbo;
import mediathek.gui.GuiDebug;
import mediathek.gui.GuiDownloads;
import mediathek.gui.GuiFilme;
import mediathek.gui.dialog.DialogMediaDB;
import mediathek.gui.dialog.MVFilmInfo;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.Konstanten;
import mediathek.tool.ListenerMediathekView;
import mediathek.tool.MVColor;
import mediathek.tool.MVConfig;
import mediathek.tool.MVFont;
import mediathek.tool.MVFunctionSys;
import mediathek.tool.MVListeFilme;
import mediathek.tool.MVMediaDB;
import mediathek.tool.MVMessageDialog;
import mediathek.tool.MVReplaceList;
import msearch.daten.ListeFilme;
import msearch.filmlisten.MSFilmlisteLesen;
import msearch.filmlisten.WriteFilmlistJson;

public class Daten {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static boolean debug = false;
    public static boolean startMaximized = false;
    public static boolean auto = false;
    public static boolean RESET = false;
    public static MVConfig mVConfig = new MVConfig();
    public static MVColor mVColor = new MVColor();
    public static MVReplaceList mVReplaceList = new MVReplaceList();
    public static MVMediaDB mVMediaDB = new MVMediaDB();
    public static FilmeLaden filmeLaden;
    public static ListeFilme listeFilme;
    public static ListeFilme listeFilmeNachBlackList;
    public static ListeFilme listeFilmeHistory;
    public static ListeDownloads listeDownloads;
    public static ListeDownloads listeDownloadsButton;
    public static ListeBlacklist listeBlacklist;
    public static ListeAbo listeAbo;
    public static DownloadInfos downloadInfos;
    private static String basisverzeichnis;
    public static ListePset listePset;
    public MVUsedUrls history = null;
    public MVUsedUrls erledigteAbos = null;
    public StarterClass starterClass = null;
    public MediathekGui mediathekGui = null;
    public GuiFilme guiFilme = null;
    public GuiDownloads guiDownloads = null;
    public GuiAbo guiAbo = null;
    public static GuiDebug guiDebug;
    public MVFilmInfo filmInfo = null;
    public DialogMediaDB dialogMediaDB = null;
    private boolean alreadyMadeBackup = false;
    private static final int MAX_COPY = 5;

    public Daten(String basis, MediathekGui gui) {
        basisverzeichnis = basis;
        this.mediathekGui = gui;
        this.init();
        listeFilme = new ListeFilme();
        filmeLaden = new FilmeLaden();
        listeFilmeHistory = new ListeFilme();
        this.updateSplashScreen("Lade Blacklist...");
        listeFilmeNachBlackList = new ListeFilme();
        listeBlacklist = new ListeBlacklist(this);
        this.updateSplashScreen("Lade Programmsets...");
        listePset = new ListePset();
        this.updateSplashScreen("Lade Abos...");
        listeAbo = new ListeAbo(this);
        this.updateSplashScreen("Lade Downloads...");
        listeDownloads = new ListeDownloads(this);
        listeDownloadsButton = new ListeDownloads(this);
        this.updateSplashScreen("Lade erledigte Abos...");
        this.erledigteAbos = new MVUsedUrls("downloadAbos.txt", 11);
        this.updateSplashScreen("Lade History...");
        this.history = new MVUsedUrls("history.txt", 2);
        downloadInfos = new DownloadInfos();
        this.starterClass = new StarterClass(this);
        Timer timer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                downloadInfos.makeDownloadInfos();
                ListenerMediathekView.notify(30, Daten.class.getName());
            }
        });
        timer.setInitialDelay(4000);
        timer.start();
    }

    public static void setUserAgentAuto() {
        mVConfig.add("User-Agent-Auto", Boolean.TRUE.toString());
    }

    public static void setUserAgentManuel(String ua) {
        mVConfig.add("User-Agent-Auto", Boolean.FALSE.toString());
        mVConfig.add("User-Agent", ua);
    }

    public static boolean isUserAgentAuto() {
        return Boolean.parseBoolean(mVConfig.get("User-Agent-Auto"));
    }

    public static String getUserAgent() {
        if (Daten.isUserAgentAuto()) {
            return Konstanten.USER_AGENT_DEFAULT;
        }
        return mVConfig.get("User-Agent");
    }

    public static String getDateiFilmliste() {
        String strFile = SystemInfo.isMacOSX() ? GuiFunktionen.getHomePath() + File.separator + "Library/Caches/MediathekView" + File.separator + "filme.json" : Daten.getSettingsDirectory_String() + File.separator + "filme.json";
        return strFile;
    }

    public static Path getSettingsDirectory() throws IOException {
        String baseDirectoryString = basisverzeichnis.equals("") ? System.getProperty("user.home") + File.separator + ".mediathek3" + File.separator : basisverzeichnis;
        Path baseDirectoryPath = Paths.get(baseDirectoryString, new String[0]);
        if (Files.notExists(baseDirectoryPath, new LinkOption[0])) {
            Files.createDirectories(baseDirectoryPath, new FileAttribute[0]);
        }
        return baseDirectoryPath;
    }

    public static String getSettingsDirectory_String() {
        try {
            return Daten.getSettingsDirectory().toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static Path getMediathekXmlFilePath() {
        Path xmlFilePath = null;
        try {
            xmlFilePath = Daten.getSettingsDirectory().resolve("mediathek.xml");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return xmlFilePath;
    }

    public static void getMediathekXmlCopyFilePath(ArrayList<Path> xmlFilePath) {
        try {
            for (int i = 1; i <= 5; ++i) {
                Path path = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + i);
                if (!Files.exists(path, new LinkOption[0])) continue;
                xmlFilePath.add(path);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static void filmlisteSpeichern() {
        new WriteFilmlistJson().filmlisteSchreibenJson(Daten.getDateiFilmliste(), listeFilme);
    }

    private void init() {
        mVConfig.add("maxDownload", "1");
        mVConfig.add("System-look", "0");
        mVConfig.add("update-suchen", Boolean.TRUE.toString());
        mVConfig.add("Abos-sofort-suchen", Boolean.TRUE.toString());
        mVConfig.add("Download-sofort-starten", Boolean.FALSE.toString());
        mVConfig.add("Ersetzungstabelle-verwenden", SystemInfo.isLinux() || SystemInfo.isMacOSX() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        mVConfig.add("nur-ascii", Boolean.FALSE.toString());
        mVConfig.add("Echtzeitsuche", Boolean.TRUE.toString());
        mVConfig.add("Media_DB_Echtzeitsuche", Boolean.TRUE.toString());
        mVConfig.add("Tray-anzeigen", Boolean.FALSE.toString());
        mVConfig.add("Icon-Standard", Boolean.TRUE.toString());
        mVConfig.add("system-panel-beschreibung-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("Blacklist-ausgeschaltet", Boolean.FALSE.toString());
        mVConfig.add("Blacklist-Start-ausgeschaltet", Boolean.FALSE.toString());
        mVConfig.add("Blacklist-Filmlaenge", "0");
        mVConfig.add("Icon-Pfad", MVFunctionSys.getPathJar() + File.separator + "Icons" + File.separator + "SchwarzWeiss");
        mVConfig.add("maxBandbreite", String.valueOf(1000));
        mVConfig.add("Notification-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("Dialog-Download-D-Starten", Boolean.TRUE.toString());
        mVConfig.add("Toolbar-Alles-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("Vis-Download", Boolean.TRUE.toString());
        mVConfig.add("Vis-Abo", Boolean.TRUE.toString());
        mVConfig.add("Vis-Filter", Boolean.TRUE.toString());
        mVConfig.add("Geo-melden", Boolean.TRUE.toString());
        mVConfig.add("Geo-Standort", "DE");
        mVConfig.add("system-panel-filme-divider", "260");
        mVConfig.add("system-tab-download-icon-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("system-tab-filme-icon-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("system-tab-abo-icon-anzeigen", Boolean.TRUE.toString());
        mVConfig.add("system-tab-download-icon-klein", Boolean.TRUE.toString());
        mVConfig.add("system-tab-filme-icon-klein", Boolean.TRUE.toString());
        mVConfig.add("system-tab-abo-icon-klein", Boolean.TRUE.toString());
        mVConfig.add("system-font-size", "0");
        mVConfig.add("system-anz-tage-filmilste", "0");
        mVConfig.add("User-Agent-Auto", Boolean.TRUE.toString());
        try {
            mVConfig.add("pfad-vlc", GuiFunktionenProgramme.getMusterPfadVlc());
            mVConfig.add("pfad-flvstreamer", GuiFunktionenProgramme.getMusterPfadFlv());
            mVConfig.add("pfad-ffmpeg", GuiFunktionenProgramme.getMusterPfadFFmpeg());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug) {
            mVConfig.add("update-filme", String.valueOf(0));
        }
    }

    private void updateSplashScreen(String text) {
        if (this.mediathekGui != null) {
            this.mediathekGui.updateSplashScreenText(text);
        }
    }

    public boolean allesLaden() {
        this.updateSplashScreen("Lade Konfigurationsdaten...");
        if (!this.load()) {
            Log.systemMeldung("Weder Konfig noch Backup konnte geladen werden!");
            this.clearKonfig();
            return false;
        }
        Log.systemMeldung("Konfig wurde gelesen!");
        mVColor.load();
        MVFont.initFont();
        this.updateSplashScreen("Lade Filmliste...");
        new MSFilmlisteLesen().readFilmListe(Daten.getDateiFilmliste(), listeFilme, Integer.parseInt(mVConfig.get("system-anz-tage-filmilste")));
        int c = listeFilme.setFilmNew();
        Log.systemMeldung("Liste Filme gelesen am: " + new SimpleDateFormat("dd.MM.yyyy, HH:mm").format(new Date()));
        Log.systemMeldung("  erstellt am: " + listeFilme.genDate());
        Log.systemMeldung("  Anzahl Filme: " + listeFilme.size());
        Log.systemMeldung("  Anzahl Neue: " + c);
        listeFilme.themenLaden();
        listeAbo.setAboFuerFilm(listeFilme, false);
        listeDownloads.filmEintragen();
        mVConfig.add("Blacklist-ausgeschaltet", mVConfig.get("Blacklist-Start-ausgeschaltet"));
        MVListeFilme.checkBlacklist();
        return true;
    }

    private void clearKonfig() {
        this.init();
        listePset.clear();
        Daten.mVReplaceList.list.clear();
        listeAbo.clear();
        listeDownloads.clear();
        listeBlacklist.clear();
    }

    private boolean load() {
        boolean ret = false;
        Path xmlFilePath = Daten.getMediathekXmlFilePath();
        if (Files.exists(xmlFilePath, new LinkOption[0])) {
            if (IoXmlLesen.datenLesen(xmlFilePath)) {
                return true;
            }
            Log.systemMeldung("Konfig konnte nicht gelesen werden!");
        } else {
            Log.systemMeldung("Konfig existiert nicht!");
        }
        if (this.loadBackup()) {
            ret = true;
        }
        return ret;
    }

    private boolean loadBackup() {
        boolean ret = false;
        ArrayList<Path> path = new ArrayList<Path>();
        Daten.getMediathekXmlCopyFilePath(path);
        if (path.isEmpty()) {
            Log.systemMeldung("Es gibt kein Backup");
            return false;
        }
        Log.systemMeldung("Es gibt ein Backup");
        this.mediathekGui.closeSplashScreen();
        int r = JOptionPane.showConfirmDialog(null, "Die Einstellungen sind besch\u00e4digt\nund k\u00f6nnen nicht geladen werden.\nSoll versucht werden, mit gesicherten\nEinstellungen zu starten?\n\n(ansonsten startet das Programm mit\nStandardeinstellungen)", "Gesicherte Einstellungen laden?", 0);
        if (r != 0) {
            Log.systemMeldung("User will kein Backup laden.");
            return false;
        }
        for (Path p : path) {
            this.clearKonfig();
            Log.systemMeldung(new String[]{"Versuch Backup zu laden:", p.toString()});
            if (!IoXmlLesen.datenLesen(p)) continue;
            Log.systemMeldung(new String[]{"Backup hat geklappt:", p.toString()});
            ret = true;
            break;
        }
        return ret;
    }

    public void allesSpeichern() {
        this.konfigCopy();
        IoXmlSchreiben.datenSchreiben();
        if (RESET) {
            String dir1 = Daten.getSettingsDirectory_String();
            if (dir1.endsWith(File.separator)) {
                dir1 = dir1.substring(0, dir1.length() - 1);
            }
            try {
                Path path1 = Paths.get(dir1, new String[0]);
                String dir2 = dir1 + "--" + new SimpleDateFormat("yyyy.MM.dd__HH.mm.ss").format(new Date());
                Files.move(path1, Paths.get(dir2, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                Files.deleteIfExists(path1);
            }
            catch (IOException e) {
                Log.systemMeldung("Die Einstellungen konnten nicht zur\u00fcckgesetzt werden.");
                MVMessageDialog.showMessageDialog(this.mediathekGui, "Die Einstellungen konnten nicht zur\u00fcckgesetzt werden.\nSie m\u00fcssen jetzt das Programm beenden und dann den Ordner:\n" + Daten.getSettingsDirectory_String() + "\n" + "von Hand l\u00f6schen und dann das Programm wieder starten.\n\n" + "Im Forum finden Sie weitere Hilfe.", "Fehler", 0);
                Log.fehlerMeldung(465690123, e);
            }
        }
    }

    private void konfigCopy() {
        if (!this.alreadyMadeBackup) {
            Log.systemMeldung("-------------------------------------------------------");
            Log.systemMeldung("Einstellungen sichern");
            try {
                Path xmlFilePath = Daten.getMediathekXmlFilePath();
                long creatTime = -1L;
                Path xmlFilePathCopy_1 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_1");
                if (Files.exists(xmlFilePathCopy_1, new LinkOption[0])) {
                    BasicFileAttributes attrs = Files.readAttributes(xmlFilePathCopy_1, BasicFileAttributes.class, new LinkOption[0]);
                    FileTime d = attrs.lastModifiedTime();
                    creatTime = d.toMillis();
                }
                if (creatTime == -1L || creatTime < Daten.getHeute_0Uhr()) {
                    for (int i = 5; i > 1; --i) {
                        xmlFilePathCopy_1 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + (i - 1));
                        Path xmlFilePathCopy_2 = Daten.getSettingsDirectory().resolve("mediathek.xml_copy_" + i);
                        if (!Files.exists(xmlFilePathCopy_1, new LinkOption[0])) continue;
                        Files.move(xmlFilePathCopy_1, xmlFilePathCopy_2, StandardCopyOption.REPLACE_EXISTING);
                    }
                    if (Files.exists(xmlFilePath, new LinkOption[0])) {
                        Files.move(xmlFilePath, Daten.getSettingsDirectory().resolve("mediathek.xml_copy_1"), StandardCopyOption.REPLACE_EXISTING);
                    }
                    Log.systemMeldung("Einstellungen wurden gesichert");
                } else {
                    Log.systemMeldung("Einstellungen wurden heute schon gesichert");
                }
            }
            catch (IOException e) {
                Log.systemMeldung("Die Einstellungen konnten nicht komplett gesichert werden!");
                Log.fehlerMeldung(795623147, e);
            }
            this.alreadyMadeBackup = true;
            Log.systemMeldung("-------------------------------------------------------");
        }
    }

    public static long getHeute_0Uhr() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    static {
        listeFilme = null;
        listeFilmeNachBlackList = null;
        listeFilmeHistory = null;
        listeDownloads = null;
        listeDownloadsButton = null;
        listeBlacklist = null;
        listeAbo = null;
        downloadInfos = null;
        basisverzeichnis = "";
        listePset = null;
        guiDebug = null;
    }
}

